/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.operations.notify;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.internal.GradleInternal;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.operations.notify.BuildOperationFinishedNotification;
import org.gradle.internal.operations.notify.BuildOperationNotificationListener;
import org.gradle.internal.operations.notify.BuildOperationNotificationListener2;
import org.gradle.internal.operations.notify.BuildOperationNotificationListenerRegistrar;
import org.gradle.internal.operations.notify.BuildOperationProgressNotification;
import org.gradle.internal.operations.notify.BuildOperationStartedNotification;
import org.gradle.internal.progress.BuildOperationDescriptor;
import org.gradle.internal.progress.BuildOperationListener;
import org.gradle.internal.progress.BuildOperationListenerManager;
import org.gradle.internal.progress.OperationFinishEvent;
import org.gradle.internal.progress.OperationProgressEvent;
import org.gradle.internal.progress.OperationStartEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildOperationNotificationBridge
implements BuildOperationNotificationListenerRegistrar,
Stoppable {
    private static final Logger LOGGER = LoggerFactory.getLogger(BuildOperationNotificationBridge.class);
    private final BuildOperationListenerManager listenerManager;
    private final ReplayAndAttachListener replayAndAttachListener = new ReplayAndAttachListener();
    private BuildOperationListener adapter = new Adapter(this.replayAndAttachListener);
    private BuildOperationNotificationListener2 listener;
    private boolean stopped;

    BuildOperationNotificationBridge(BuildOperationListenerManager buildOperationListenerManager) {
        this.listenerManager = buildOperationListenerManager;
    }

    public void start(GradleInternal gradle) {
        this.listenerManager.addListener(this.adapter);
        gradle.rootProject((Action)new Action<Project>(){

            public void execute(Project project) {
                project.afterEvaluate((Action)new Action<Project>(){

                    public void execute(Project project) {
                        if (BuildOperationNotificationBridge.this.listener == null) {
                            BuildOperationNotificationBridge.this.stop();
                        }
                    }
                });
            }
        });
    }

    public void registerBuildScopeListener(BuildOperationNotificationListener notificationListener) {
        BuildOperationNotificationListener2 adapted = BuildOperationNotificationBridge.adapt(notificationListener);
        this.assignSingleListener(adapted);
        this.listenerManager.removeListener(this.adapter);
        this.adapter = new Adapter(adapted);
        this.listenerManager.addListener(this.adapter);
    }

    public void registerBuildScopeListenerAndReceiveStoredOperations(BuildOperationNotificationListener notificationListener) {
        this.register(BuildOperationNotificationBridge.adapt(notificationListener));
    }

    public void register(BuildOperationNotificationListener2 listener) {
        this.assignSingleListener(listener);
        this.replayAndAttachListener.attach(listener);
    }

    private void assignSingleListener(BuildOperationNotificationListener2 notificationListener) {
        if (this.listener != null) {
            throw new IllegalStateException("listener is already registered (implementation class " + this.listener.getClass().getName() + ")");
        }
        this.listener = notificationListener;
    }

    public void stop() {
        if (!this.stopped) {
            this.listenerManager.removeListener(this.adapter);
            this.adapter = null;
            this.stopped = true;
        }
    }

    private static BuildOperationNotificationListener2 adapt(final BuildOperationNotificationListener listener) {
        return new BuildOperationNotificationListener2(){

            public void started(BuildOperationStartedNotification notification) {
                listener.started(notification);
            }

            public void progress(BuildOperationProgressNotification notification) {
            }

            public void finished(BuildOperationFinishedNotification notification) {
                listener.finished(notification);
            }
        };
    }

    private static class Finished
    implements BuildOperationFinishedNotification {
        private final long timestamp;
        private final Object id;
        private final Object parentId;
        private final Object details;
        private final Object result;
        private final Throwable failure;

        private Finished(long timestamp, Object id, Object parentId, Object details, Object result, Throwable failure) {
            this.timestamp = timestamp;
            this.id = id;
            this.parentId = parentId;
            this.details = details;
            this.result = result;
            this.failure = failure;
        }

        public long getNotificationOperationFinishedTimestamp() {
            return this.timestamp;
        }

        public Object getNotificationOperationId() {
            return this.id;
        }

        @Nullable
        public Object getNotificationOperationParentId() {
            return this.parentId;
        }

        public Object getNotificationOperationDetails() {
            return this.details;
        }

        public Object getNotificationOperationResult() {
            return this.result;
        }

        public Throwable getNotificationOperationFailure() {
            return this.failure;
        }

        public String toString() {
            return "BuildOperationFinishedNotification{id=" + this.id + ", parentId=" + this.parentId + ", timestamp=" + this.timestamp + ", details=" + this.details + ", result=" + this.result + ", failure=" + this.failure + '}';
        }
    }

    private static class Progress
    implements BuildOperationProgressNotification {
        private final Object id;
        private final long timestamp;
        private final Object details;

        public Progress(Object id, long timestamp, Object details) {
            this.id = id;
            this.timestamp = timestamp;
            this.details = details;
        }

        public Object getNotificationOperationId() {
            return this.id;
        }

        public long getNotificationOperationProgressTimestamp() {
            return this.timestamp;
        }

        public Object getNotificationOperationProgressDetails() {
            return this.details;
        }
    }

    private static class Started
    implements BuildOperationStartedNotification {
        private final long timestamp;
        private final Object id;
        private final Object parentId;
        private final Object details;

        private Started(long timestamp, Object id, Object parentId, Object details) {
            this.timestamp = timestamp;
            this.id = id;
            this.parentId = parentId;
            this.details = details;
        }

        public long getNotificationOperationStartedTimestamp() {
            return this.timestamp;
        }

        public Object getNotificationOperationId() {
            return this.id;
        }

        public Object getNotificationOperationParentId() {
            return this.parentId;
        }

        public Object getNotificationOperationDetails() {
            return this.details;
        }

        public String toString() {
            return "BuildOperationStartedNotification{id=" + this.id + ", parentId=" + this.parentId + ", timestamp=" + this.timestamp + ", details=" + this.details + '}';
        }
    }

    private static class ReplayAndAttachListener
    implements BuildOperationNotificationListener2 {
        private RecordingListener recordingListener = new RecordingListener();
        private BuildOperationNotificationListener2 listener = this.recordingListener;

        private ReplayAndAttachListener() {
        }

        private synchronized void attach(BuildOperationNotificationListener2 realListener) {
            for (Object storedEvent : this.recordingListener.storedEvents) {
                if (storedEvent instanceof BuildOperationStartedNotification) {
                    realListener.started((BuildOperationStartedNotification)storedEvent);
                    continue;
                }
                if (storedEvent instanceof BuildOperationProgressNotification) {
                    realListener.progress((BuildOperationProgressNotification)storedEvent);
                    continue;
                }
                if (!(storedEvent instanceof BuildOperationFinishedNotification)) continue;
                realListener.finished((BuildOperationFinishedNotification)storedEvent);
            }
            this.listener = realListener;
            this.recordingListener = null;
        }

        public synchronized void started(BuildOperationStartedNotification notification) {
            this.listener.started(notification);
        }

        public void progress(BuildOperationProgressNotification notification) {
            this.listener.progress(notification);
        }

        public synchronized void finished(BuildOperationFinishedNotification notification) {
            this.listener.finished(notification);
        }
    }

    private static class RecordingListener
    implements BuildOperationNotificationListener2 {
        private final List<Object> storedEvents = Lists.newArrayList();

        private RecordingListener() {
        }

        public void started(BuildOperationStartedNotification notification) {
            this.storedEvents.add(notification);
        }

        public void progress(BuildOperationProgressNotification notification) {
            this.storedEvents.add(notification);
        }

        public void finished(BuildOperationFinishedNotification notification) {
            this.storedEvents.add(notification);
        }
    }

    private static class Adapter
    implements BuildOperationListener {
        private final BuildOperationNotificationListener2 notificationListener;
        private final Map<Object, Object> parents = new ConcurrentHashMap<Object, Object>();
        private final Map<Object, Object> active = new ConcurrentHashMap<Object, Object>();

        private Adapter(BuildOperationNotificationListener2 notificationListener) {
            this.notificationListener = notificationListener;
        }

        public void started(BuildOperationDescriptor buildOperation, OperationStartEvent startEvent) {
            Object id = buildOperation.getId();
            Object parentId = buildOperation.getParentId();
            if (parentId != null) {
                if (this.active.containsKey(parentId)) {
                    this.parents.put(id, parentId);
                } else if ((parentId = this.parents.get(parentId)) != null) {
                    this.parents.put(id, parentId);
                }
            }
            if (buildOperation.getDetails() == null) {
                return;
            }
            this.active.put(id, "");
            Started notification = new Started(startEvent.getStartTime(), id, parentId, buildOperation.getDetails());
            try {
                this.notificationListener.started((BuildOperationStartedNotification)notification);
            }
            catch (Throwable e) {
                LOGGER.debug("Build operation notification listener threw an error on " + notification, e);
                this.maybeThrow(e);
            }
        }

        private void maybeThrow(Throwable e) {
            if (e instanceof Error && !(e instanceof LinkageError)) {
                throw (Error)e;
            }
        }

        public void progress(BuildOperationDescriptor buildOperation, OperationProgressEvent progressEvent) {
            Object id = buildOperation.getId();
            if (!this.active.containsKey(id)) {
                return;
            }
            Object details = progressEvent.getDetails();
            if (details == null) {
                return;
            }
            this.notificationListener.progress((BuildOperationProgressNotification)new Progress(buildOperation.getId(), progressEvent.getTime(), details));
        }

        public void finished(BuildOperationDescriptor buildOperation, OperationFinishEvent finishEvent) {
            Object id = buildOperation.getId();
            Object parentId = this.parents.remove(id);
            if (this.active.remove(id) == null) {
                return;
            }
            Finished notification = new Finished(finishEvent.getEndTime(), id, parentId, buildOperation.getDetails(), finishEvent.getResult(), finishEvent.getFailure());
            try {
                this.notificationListener.finished((BuildOperationFinishedNotification)notification);
            }
            catch (Throwable e) {
                LOGGER.debug("Build operation notification listener threw an error on " + notification, e);
                this.maybeThrow(e);
            }
        }
    }
}

