/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.operations.trace;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import org.gradle.api.internal.plugins.ApplyPluginBuildOperationType;
import org.gradle.internal.execution.ExecuteTaskBuildOperationType;
import org.gradle.internal.logging.events.OperationIdentifier;
import org.gradle.internal.progress.BuildOperationDescriptor;
import org.gradle.internal.progress.OperationStartEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SerializedOperationStart {
    final Object id;
    final Object parentId;
    final String displayName;
    final long startTime;
    final Object details;
    final String detailsClassName;

    SerializedOperationStart(BuildOperationDescriptor descriptor, OperationStartEvent startEvent) {
        this.id = ((OperationIdentifier)descriptor.getId()).getId();
        this.parentId = descriptor.getParentId() == null ? null : Long.valueOf(((OperationIdentifier)descriptor.getParentId()).getId());
        this.displayName = descriptor.getDisplayName();
        this.startTime = startEvent.getStartTime();
        this.details = this.transform(descriptor.getDetails());
        this.detailsClassName = this.details == null ? null : descriptor.getDetails().getClass().getName();
    }

    private Object transform(Object details) {
        if (details instanceof ExecuteTaskBuildOperationType.Details) {
            ExecuteTaskBuildOperationType.Details cast = (ExecuteTaskBuildOperationType.Details)details;
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("buildPath", cast.getBuildPath());
            map.put("taskPath", cast.getTaskPath());
            map.put("taskClass", cast.getTaskClass().getName());
            map.put("taskId", cast.getTaskId());
            return map;
        }
        if (details instanceof ApplyPluginBuildOperationType.Details) {
            ApplyPluginBuildOperationType.Details cast = (ApplyPluginBuildOperationType.Details)details;
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("pluginId", cast.getPluginId());
            map.put("pluginClass", cast.getPluginClass().getName());
            map.put("targetType", cast.getTargetType());
            map.put("targetPath", cast.getTargetPath());
            map.put("buildPath", cast.getBuildPath());
            return map;
        }
        return details;
    }

    SerializedOperationStart(Map<String, ?> map) {
        this.id = map.get("id");
        this.parentId = map.get("parentId");
        this.displayName = (String)map.get("displayName");
        this.startTime = (Long)map.get("startTime");
        this.details = map.get("details");
        this.detailsClassName = (String)map.get("detailsClassName");
    }

    Map<String, ?> toMap() {
        ImmutableMap.Builder map = ImmutableMap.builder();
        map.put((Object)"displayName", (Object)this.displayName);
        if (this.details != null) {
            map.put((Object)"details", this.details);
            map.put((Object)"detailsClassName", (Object)this.detailsClassName);
        }
        map.put((Object)"id", this.id);
        if (this.parentId != null) {
            map.put((Object)"parentId", this.parentId);
        }
        map.put((Object)"startTime", (Object)this.startTime);
        return map.build();
    }
}

