/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.scan.config;

import org.gradle.internal.scan.config.BuildScanConfig;
import org.gradle.internal.scan.config.UnsupportedBuildScanPluginVersionException;
import org.gradle.util.VersionNumber;

class BuildScanPluginCompatibility {
    public static final VersionNumber MIN_SUPPORTED_VERSION = VersionNumber.parse("1.8");
    public static final String UNSUPPORTED_PLUGIN_VERSION_MESSAGE = "This version of Gradle requires version " + MIN_SUPPORTED_VERSION + " of the build scan plugin or later.\n" + "Please see https://gradle.com/scans/help/gradle-incompatible-plugin-version for more information.";
    public static final VersionNumber MIN_VERSION_AWARE_OF_VCS_MAPPINGS = VersionNumber.parse("1.11");
    public static final String UNSUPPORTED_VCS_MAPPINGS_MESSAGE = "Build scans are not supported when using VCS mappings. It may be supported when using newer versions of the build scan plugin.";
    public static final String UNSUPPORTED_TOGGLE = "org.gradle.internal.unsupported-scan-plugin";
    public static final String UNSUPPORTED_TOGGLE_MESSAGE = "Build scan support disabled by secret toggle";

    BuildScanPluginCompatibility() {
    }

    String unsupportedReason(VersionNumber pluginVersion, BuildScanConfig.Attributes attributes) {
        if (pluginVersion.compareTo(MIN_SUPPORTED_VERSION) < 0) {
            return UNSUPPORTED_PLUGIN_VERSION_MESSAGE;
        }
        if (pluginVersion.compareTo(MIN_VERSION_AWARE_OF_VCS_MAPPINGS) < 0 && attributes.isRootProjectHasVcsMappings()) {
            return UNSUPPORTED_VCS_MAPPINGS_MESSAGE;
        }
        if (Boolean.getBoolean(UNSUPPORTED_TOGGLE)) {
            return UNSUPPORTED_TOGGLE_MESSAGE;
        }
        return null;
    }

    UnsupportedBuildScanPluginVersionException unsupportedVersionException() {
        return new UnsupportedBuildScanPluginVersionException(UNSUPPORTED_PLUGIN_VERSION_MESSAGE);
    }
}

