/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transport.http;

import java.io.Closeable;
import java.io.IOException;
import java.util.Locale;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.http.Header;
import org.apache.http.HeaderIterator;
import org.apache.http.HttpEntity;
import org.apache.http.ProtocolVersion;
import org.apache.http.StatusLine;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.gradle.internal.resource.transport.http.AlwaysRedirectRedirectStrategy;
import org.gradle.internal.resource.transport.http.HttpClientConfigurer;
import org.gradle.internal.resource.transport.http.HttpErrorStatusCodeException;
import org.gradle.internal.resource.transport.http.HttpRequestException;
import org.gradle.internal.resource.transport.http.HttpSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientHelper
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpClientHelper.class);
    private CloseableHttpClient client;
    private final HttpSettings settings;
    private final ConcurrentLinkedQueue<HttpContext> sharedContext;

    public HttpClientHelper(HttpSettings settings) {
        this.settings = settings;
        this.sharedContext = !settings.getAuthenticationSettings().isEmpty() ? new ConcurrentLinkedQueue() : null;
    }

    public CloseableHttpResponse performRawHead(String source, boolean revalidate) {
        return this.performRequest((HttpRequestBase)new HttpHead(source), revalidate);
    }

    public CloseableHttpResponse performHead(String source, boolean revalidate) {
        return this.processResponse(source, "HEAD", this.performRawHead(source, revalidate));
    }

    public CloseableHttpResponse performRawGet(String source, boolean revalidate) {
        return this.performRequest((HttpRequestBase)new HttpGet(source), revalidate);
    }

    public CloseableHttpResponse performGet(String source, boolean revalidate) {
        return this.processResponse(source, "GET", this.performRawGet(source, revalidate));
    }

    public CloseableHttpResponse performRequest(HttpRequestBase request, boolean revalidate) {
        CloseableHttpResponse response;
        String method = request.getMethod();
        if (revalidate) {
            request.addHeader("Cache-Control", "max-age=0");
        }
        try {
            response = this.executeGetOrHead(request);
        }
        catch (IOException e) {
            throw new HttpRequestException(String.format("Could not %s '%s'.", method, request.getURI()), e);
        }
        return response;
    }

    protected CloseableHttpResponse executeGetOrHead(HttpRequestBase method) throws IOException {
        CloseableHttpResponse httpResponse = this.performHttpRequest(method);
        if (!this.wasSuccessful(httpResponse)) {
            AutoClosedHttpResponse response = new AutoClosedHttpResponse(httpResponse);
            HttpClientUtils.closeQuietly((CloseableHttpResponse)httpResponse);
            return response;
        }
        return httpResponse;
    }

    public boolean wasMissing(CloseableHttpResponse response) {
        int statusCode = response.getStatusLine().getStatusCode();
        return statusCode == 404;
    }

    public boolean wasSuccessful(CloseableHttpResponse response) {
        int statusCode = response.getStatusLine().getStatusCode();
        return statusCode >= 200 && statusCode < 400;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CloseableHttpResponse performHttpRequest(HttpRequestBase request) throws IOException {
        if (this.sharedContext == null) {
            return this.performHttpRequest(request, (HttpContext)new BasicHttpContext());
        }
        HttpContext httpContext = this.nextAvailableSharedContext();
        try {
            CloseableHttpResponse closeableHttpResponse = this.performHttpRequest(request, httpContext);
            return closeableHttpResponse;
        }
        finally {
            this.sharedContext.add(httpContext);
        }
    }

    private HttpContext nextAvailableSharedContext() {
        HttpContext context = this.sharedContext.poll();
        if (context == null) {
            return new BasicHttpContext();
        }
        return context;
    }

    private CloseableHttpResponse performHttpRequest(HttpRequestBase request, HttpContext httpContext) throws IOException {
        httpContext.removeAttribute("http.protocol.redirect-locations");
        LOGGER.debug("Performing HTTP {}: {}", (Object)request.getMethod(), (Object)request.getURI());
        return this.getClient().execute((HttpUriRequest)request, httpContext);
    }

    private CloseableHttpResponse processResponse(String source, String method, CloseableHttpResponse response) {
        if (this.wasMissing(response)) {
            LOGGER.info("Resource missing. [HTTP {}: {}]", (Object)method, (Object)source);
            return null;
        }
        if (!this.wasSuccessful(response)) {
            LOGGER.info("Failed to get resource: {}. [HTTP {}: {}]", new Object[]{method, response.getStatusLine(), source});
            throw new HttpErrorStatusCodeException(method, source, response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase());
        }
        return response;
    }

    private synchronized CloseableHttpClient getClient() {
        if (this.client == null) {
            HttpClientBuilder builder = HttpClientBuilder.create();
            builder.setRedirectStrategy((RedirectStrategy)new AlwaysRedirectRedirectStrategy());
            new HttpClientConfigurer(this.settings).configure(builder);
            this.client = builder.build();
        }
        return this.client;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.client != null) {
            this.client.close();
            if (this.sharedContext != null) {
                this.sharedContext.clear();
            }
        }
    }

    private static class AutoClosedHttpResponse
    implements CloseableHttpResponse {
        private final HttpEntity entity;
        private final CloseableHttpResponse httpResponse;

        public AutoClosedHttpResponse(CloseableHttpResponse httpResponse) throws IOException {
            this.httpResponse = httpResponse;
            HttpEntity entity = httpResponse.getEntity();
            this.entity = entity != null ? new BufferedHttpEntity(entity) : null;
        }

        public void close() throws IOException {
        }

        public StatusLine getStatusLine() {
            return this.httpResponse.getStatusLine();
        }

        public void setStatusLine(StatusLine statusline) {
            throw new UnsupportedOperationException();
        }

        public void setStatusLine(ProtocolVersion ver, int code) {
            throw new UnsupportedOperationException();
        }

        public void setStatusLine(ProtocolVersion ver, int code, String reason) {
            throw new UnsupportedOperationException();
        }

        public void setStatusCode(int code) throws IllegalStateException {
            throw new UnsupportedOperationException();
        }

        public void setReasonPhrase(String reason) throws IllegalStateException {
            throw new UnsupportedOperationException();
        }

        public HttpEntity getEntity() {
            return this.entity;
        }

        public void setEntity(HttpEntity entity) {
            throw new UnsupportedOperationException();
        }

        public Locale getLocale() {
            return this.httpResponse.getLocale();
        }

        public void setLocale(Locale loc) {
            throw new UnsupportedOperationException();
        }

        public ProtocolVersion getProtocolVersion() {
            return this.httpResponse.getProtocolVersion();
        }

        public boolean containsHeader(String name) {
            return this.httpResponse.containsHeader(name);
        }

        public Header[] getHeaders(String name) {
            return this.httpResponse.getHeaders(name);
        }

        public Header getFirstHeader(String name) {
            return this.httpResponse.getFirstHeader(name);
        }

        public Header getLastHeader(String name) {
            return this.httpResponse.getLastHeader(name);
        }

        public Header[] getAllHeaders() {
            return this.httpResponse.getAllHeaders();
        }

        public void addHeader(Header header) {
            throw new UnsupportedOperationException();
        }

        public void addHeader(String name, String value) {
            throw new UnsupportedOperationException();
        }

        public void setHeader(Header header) {
            throw new UnsupportedOperationException();
        }

        public void setHeader(String name, String value) {
            throw new UnsupportedOperationException();
        }

        public void setHeaders(Header[] headers) {
            throw new UnsupportedOperationException();
        }

        public void removeHeader(Header header) {
            throw new UnsupportedOperationException();
        }

        public void removeHeaders(String name) {
            throw new UnsupportedOperationException();
        }

        public HeaderIterator headerIterator() {
            return this.httpResponse.headerIterator();
        }

        public HeaderIterator headerIterator(String name) {
            return this.httpResponse.headerIterator(name);
        }

        public HttpParams getParams() {
            return this.httpResponse.getParams();
        }

        public void setParams(HttpParams params) {
            throw new UnsupportedOperationException();
        }
    }
}

