/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.syntax;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.Rectangle2D;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import org.gjt.sp.jedit.Debug;
import org.gjt.sp.jedit.IPropertyManager;
import org.gjt.sp.jedit.syntax.ParserRuleSet;
import org.gjt.sp.jedit.syntax.SyntaxStyle;
import org.gjt.sp.jedit.syntax.Token;

public class Chunk
extends Token {
    SyntaxStyle style;
    float width;
    private static final char[] EMPTY_TEXT = new char[0];
    private static boolean fontSubstEnabled;
    private static boolean fontSubstSystemFontsEnabled;
    private static Font[] preferredFonts;
    private static Font[] fontSubstList;
    private static int glyphCacheCapacity;
    private static SoftReference<GlyphCache> glyphCache;
    private Color background;
    private String str;
    private GlyphVector[] glyphs;

    public static float paintChunkList(Chunk chunk, Graphics2D graphics2D, float f, float f2, boolean bl) {
        Rectangle rectangle = graphics2D.getClipBounds();
        float f3 = 0.0f;
        while (chunk != null) {
            if (f + f3 + chunk.width > (float)rectangle.x && f + f3 < (float)(rectangle.x + rectangle.width)) {
                if (Debug.CHUNK_PAINT_DEBUG) {
                    graphics2D.draw(new Rectangle2D.Float(f + f3, f2 - 10.0f, chunk.width, 10.0f));
                }
                if (chunk.isAccessible() && chunk.glyphs != null) {
                    graphics2D.setFont(chunk.style.getFont());
                    graphics2D.setColor(chunk.style.getForegroundColor());
                    if (bl) {
                        chunk.drawGlyphs(graphics2D, f + f3, f2);
                    } else if (chunk.str != null) {
                        graphics2D.drawString(chunk.str, f + f3, f2);
                    }
                }
            }
            f3 += chunk.width;
            chunk = (Chunk)chunk.next;
        }
        return f3;
    }

    public static float paintChunkBackgrounds(Chunk chunk, Graphics2D graphics2D, float f, float f2, float f3) {
        Rectangle rectangle = graphics2D.getClipBounds();
        float f4 = 0.0f;
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n = fontMetrics.getAscent();
        float f5 = f3;
        while (chunk != null) {
            Color color;
            if (f + f4 + chunk.width > (float)rectangle.x && f + f4 < (float)(rectangle.x + rectangle.width) && chunk.isAccessible() && (color = chunk.background) != null) {
                graphics2D.setColor(color);
                graphics2D.fill(new Rectangle2D.Float(f + f4, f2 - (float)n, f4 + chunk.width - f4, f5));
            }
            f4 += chunk.width;
            chunk = (Chunk)chunk.next;
        }
        return f4;
    }

    public static float offsetToX(Chunk chunk, int n) {
        if (chunk != null && n < chunk.offset) {
            throw new ArrayIndexOutOfBoundsException(n + " < " + chunk.offset);
        }
        float f = 0.0f;
        while (chunk != null) {
            if (chunk.isAccessible() && n < chunk.offset + chunk.length) {
                return f + chunk.offsetToX(n - chunk.offset);
            }
            f += chunk.width;
            chunk = (Chunk)chunk.next;
        }
        return f;
    }

    public static int xToOffset(Chunk chunk, float f, boolean bl) {
        float f2 = 0.0f;
        while (chunk != null) {
            if (chunk.isAccessible() && f < f2 + chunk.width) {
                return chunk.xToOffset(f - f2, bl);
            }
            f2 += chunk.width;
            chunk = (Chunk)chunk.next;
        }
        return -1;
    }

    public static void propertiesChanged(IPropertyManager iPropertyManager) {
        fontSubstList = null;
        if (iPropertyManager == null) {
            fontSubstEnabled = false;
            fontSubstSystemFontsEnabled = true;
            preferredFonts = null;
        } else {
            fontSubstEnabled = Boolean.parseBoolean(iPropertyManager.getProperty("view.enableFontSubst"));
            fontSubstSystemFontsEnabled = Boolean.parseBoolean(iPropertyManager.getProperty("view.enableFontSubstSystemFonts"));
        }
        ArrayList<Font> arrayList = new ArrayList<Font>();
        int n = 0;
        if (iPropertyManager != null) {
            String string;
            while ((string = iPropertyManager.getProperty("view.fontSubstList." + n)) != null) {
                Font font = new Font(string, 0, 12);
                if (!"dialog".equalsIgnoreCase(font.getFamily()) || "dialog".equalsIgnoreCase(string)) {
                    arrayList.add(font);
                }
                ++n;
            }
        }
        preferredFonts = arrayList.toArray(new Font[arrayList.size()]);
        glyphCache = null;
    }

    Chunk(float f, int n, ParserRuleSet parserRuleSet) {
        super((byte)0, n, 0, parserRuleSet);
        this.width = f;
        assert (!this.isAccessible());
        assert (this.isInitialized());
    }

    Chunk(byte by, int n, int n2, ParserRuleSet parserRuleSet, SyntaxStyle[] syntaxStyleArray, byte by2) {
        super(by, n, n2, parserRuleSet);
        this.style = syntaxStyleArray[by];
        this.background = this.style.getBackgroundColor();
        if (this.background == null) {
            this.background = syntaxStyleArray[by2].getBackgroundColor();
        }
        assert (this.isAccessible());
        assert (!this.isInitialized());
    }

    Chunk(byte by, int n, int n2, ParserRuleSet parserRuleSet, SyntaxStyle syntaxStyle, Color color) {
        super(by, n, n2, parserRuleSet);
        this.style = syntaxStyle;
        this.background = color;
        assert (this.isAccessible());
        assert (!this.isInitialized());
    }

    final boolean isAccessible() {
        return this.length > 0;
    }

    final boolean isInitialized() {
        return !this.isAccessible() || this.glyphs != null || this.width > 0.0f;
    }

    final boolean isTab(Segment segment) {
        return this.length == 1 && segment.array[segment.offset + this.offset] == '\t';
    }

    final Chunk snippetBefore(int n) {
        assert (0 <= n && n < this.length);
        return new Chunk(this.id, this.offset, n, this.rules, this.style, this.background);
    }

    final Chunk snippetAfter(int n) {
        assert (0 <= n && n < this.length);
        return new Chunk(this.id, this.offset + n, this.length - n, this.rules, this.style, this.background);
    }

    final Chunk snippetBeforeLineOffset(int n) {
        return this.snippetBefore(n - this.offset);
    }

    final float offsetToX(int n) {
        if (this.glyphs == null) {
            return 0.0f;
        }
        float f = 0.0f;
        for (GlyphVector glyphVector : this.glyphs) {
            if (n < glyphVector.getNumGlyphs()) {
                return f += (float)glyphVector.getGlyphPosition(n).getX();
            }
            f += (float)glyphVector.getLogicalBounds().getWidth();
            n -= glyphVector.getNumGlyphs();
        }
        assert (false) : "Shouldn't reach this.";
        return -1.0f;
    }

    final int xToOffset(float f, boolean bl) {
        if (this.glyphs == null) {
            if (bl && this.width - f < f) {
                return this.offset + this.length;
            }
            return this.offset;
        }
        int n = this.offset;
        float f2 = 0.0f;
        for (GlyphVector glyphVector : this.glyphs) {
            float f3 = (float)glyphVector.getLogicalBounds().getWidth();
            if (f2 + f3 >= f) {
                float[] fArray = glyphVector.getGlyphPositions(0, glyphVector.getNumGlyphs(), null);
                for (int i = 0; i < glyphVector.getNumGlyphs(); ++i) {
                    float f4;
                    float f5 = f2 + fArray[i << 1];
                    float f6 = f4 = i == glyphVector.getNumGlyphs() - 1 ? this.width : f2 + fArray[(i << 1) + 2];
                    if (!(f4 > f)) continue;
                    if (!bl || f4 - f > f - f5) {
                        return n + i;
                    }
                    return n + i + 1;
                }
            }
            f2 += f3;
            n += glyphVector.getNumGlyphs();
        }
        assert (false) : "Shouldn't reach this.";
        return -1;
    }

    void init(Segment segment, TabExpander tabExpander, float f, FontRenderContext fontRenderContext, int n) {
        if (this.isAccessible()) {
            if (this.isTab(segment)) {
                float f2 = tabExpander.nextTabStop(f, n + this.offset);
                this.width = f2 - f;
            } else {
                this.str = new String(segment.array, segment.offset + this.offset, this.length);
                GlyphKey glyphKey = new GlyphKey(this.str, this.style.getFont(), fontRenderContext);
                GlyphCache glyphCache = Chunk.getGlyphCache();
                GlyphVector[] glyphVectorArray = (GlyphVector[])glyphCache.get(glyphKey);
                if (glyphVectorArray != null) {
                    this.glyphs = glyphVectorArray;
                } else {
                    int n2 = segment.offset + this.offset;
                    int n3 = n2 + this.length;
                    this.glyphs = Chunk.layoutGlyphs(this.style.getFont(), fontRenderContext, segment.array, n2, n3);
                    glyphCache.put(glyphKey, this.glyphs);
                }
                float f3 = 0.0f;
                for (GlyphVector glyphVector : this.glyphs) {
                    f3 += (float)glyphVector.getLogicalBounds().getWidth();
                }
                this.width = f3;
            }
        }
        assert (this.isInitialized());
    }

    private static Font[] getFontSubstList() {
        if (fontSubstList == null) {
            if (fontSubstSystemFontsEnabled) {
                Font[] fontArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
                fontSubstList = new Font[preferredFonts.length + fontArray.length];
                System.arraycopy(preferredFonts, 0, fontSubstList, 0, preferredFonts.length);
                System.arraycopy(fontArray, 0, fontSubstList, preferredFonts.length, fontArray.length);
            } else {
                fontSubstList = new Font[preferredFonts.length];
                System.arraycopy(preferredFonts, 0, fontSubstList, 0, preferredFonts.length);
            }
        }
        return fontSubstList;
    }

    private static Font getSubstFont(int n) {
        if (Character.isISOControl(n)) {
            return null;
        }
        for (Font font : Chunk.getFontSubstList()) {
            if (!font.canDisplay(n)) continue;
            return font;
        }
        return null;
    }

    private void drawGlyphs(Graphics2D graphics2D, float f, float f2) {
        for (GlyphVector glyphVector : this.glyphs) {
            graphics2D.drawGlyphVector(glyphVector, f, f2);
            f += (float)glyphVector.getLogicalBounds().getWidth();
        }
    }

    private static GlyphVector layoutGlyphVector(Font font, FontRenderContext fontRenderContext, char[] cArray, int n, int n2) {
        int n3 = 6;
        GlyphVector glyphVector = font.layoutGlyphVector(fontRenderContext, cArray, n, n2, n3);
        font.layoutGlyphVector(fontRenderContext, EMPTY_TEXT, 0, 0, n3);
        return glyphVector;
    }

    private static GlyphVector[] layoutGlyphs(Font font, FontRenderContext fontRenderContext, char[] cArray, int n, int n2) {
        int n3;
        int n4 = n3 = !fontSubstEnabled ? -1 : font.canDisplayUpTo(cArray, n, n2);
        if (n3 == -1) {
            GlyphVector glyphVector = Chunk.layoutGlyphVector(font, fontRenderContext, cArray, n, n2);
            return new GlyphVector[]{glyphVector};
        }
        FontSubstitution fontSubstitution = new FontSubstitution(font, fontRenderContext, cArray, n);
        fontSubstitution.addNonSubstRange(n3 - n);
        Chunk.doFontSubstitution(fontSubstitution, font, cArray, n3, n2);
        fontSubstitution.finish();
        return fontSubstitution.getGlyphs();
    }

    private static void doFontSubstitution(FontSubstitution fontSubstitution, Font font, char[] cArray, int n, int n2) {
        while (true) {
            assert (n < n2);
            int n3 = Character.codePointAt(cArray, n);
            int n4 = Character.charCount(n3);
            assert (!font.canDisplay(n3));
            Font font2 = Chunk.getSubstFont(n3);
            if (font2 != null) {
                fontSubstitution.addRange(font2, n4);
            } else {
                fontSubstitution.addNonSubstRange(n4);
            }
            if ((n += n4) >= n2) break;
            int n5 = font.canDisplayUpTo(cArray, n, n2);
            if (n5 == -1) {
                fontSubstitution.addNonSubstRange(n2 - n);
                break;
            }
            fontSubstitution.addNonSubstRange(n5 - n);
            n = n5;
        }
    }

    private static GlyphCache getGlyphCache() {
        GlyphCache glyphCache;
        if (Chunk.glyphCache != null && (glyphCache = Chunk.glyphCache.get()) != null) {
            return glyphCache;
        }
        glyphCache = new GlyphCache(glyphCacheCapacity);
        Chunk.glyphCache = new SoftReference<GlyphCache>(glyphCache);
        return glyphCache;
    }

    static {
        glyphCacheCapacity = 256;
    }

    private static class GlyphCache
    extends LinkedHashMap<GlyphKey, GlyphVector[]> {
        private final int capacity;

        public GlyphCache(int n) {
            super(n + 1, 1.0f, true);
            this.capacity = n;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<GlyphKey, GlyphVector[]> entry) {
            return this.size() > this.capacity;
        }
    }

    private static class GlyphKey {
        public final String token;
        public final Font font;
        public final FontRenderContext context;

        GlyphKey(String string, Font font, FontRenderContext fontRenderContext) {
            assert (string != null);
            assert (font != null);
            assert (fontRenderContext != null);
            this.token = string;
            this.font = font;
            this.context = fontRenderContext;
        }

        public final int hashCode() {
            return this.token.hashCode() + this.font.hashCode() + this.context.hashCode();
        }

        public final boolean equals(Object object) {
            GlyphKey glyphKey = (GlyphKey)object;
            return this.token.equals(glyphKey.token) && this.font.equals(glyphKey.font) && this.context.equals(glyphKey.context);
        }

        public final String toString() {
            return this.token;
        }
    }

    private static class FontSubstitution {
        private final Font mainFont;
        private final FontRenderContext frc;
        private final char[] text;
        private int rangeStart;
        private Font rangeFont;
        private int rangeLength;
        private final ArrayList<GlyphVector> glyphs;

        public FontSubstitution(Font font, FontRenderContext fontRenderContext, char[] cArray, int n) {
            this.mainFont = font;
            this.frc = fontRenderContext;
            this.text = cArray;
            this.rangeStart = n;
            this.rangeFont = null;
            this.rangeLength = 0;
            this.glyphs = new ArrayList();
        }

        public void addNonSubstRange(int n) {
            this.addRange(null, n);
        }

        private void addRange(Font font, int n) {
            assert (n >= 0);
            if (n == 0) {
                return;
            }
            if (font == this.rangeFont) {
                this.rangeLength += n;
            } else {
                this.addGlyphVectorOfLastRange();
                this.rangeFont = font;
                this.rangeStart += this.rangeLength;
                this.rangeLength = n;
            }
        }

        public void finish() {
            this.addGlyphVectorOfLastRange();
            this.rangeFont = null;
            this.rangeStart += this.rangeLength;
            this.rangeLength = 0;
        }

        public GlyphVector[] getGlyphs() {
            return this.glyphs.toArray(new GlyphVector[this.glyphs.size()]);
        }

        private void addGlyphVectorOfLastRange() {
            if (this.rangeLength == 0) {
                return;
            }
            Font font = this.rangeFont == null ? this.mainFont : this.rangeFont.deriveFont(this.mainFont.getStyle(), this.mainFont.getSize());
            GlyphVector glyphVector = Chunk.layoutGlyphVector(font, this.frc, this.text, this.rangeStart, this.rangeStart + this.rangeLength);
            this.glyphs.add(glyphVector);
        }
    }
}

