/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.upload;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.upload.UploadHook;
import org.openstreetmap.josm.data.APIDataSet;
import org.openstreetmap.josm.data.osm.CyclicUploadDependencyException;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.OsmPrimitivRenderer;
import org.openstreetmap.josm.gui.util.WindowGeometry;
import org.openstreetmap.josm.tools.I18n;

public class RelationUploadOrderHook
implements UploadHook {
    protected JPanel buildWarningPanel(List<Relation> dep) {
        JPanel pnl = new JPanel(new BorderLayout());
        String msg = I18n.tr("<html>{0} relations build a cycle because they refer to each other.<br>JOSM cannot upload them. Please edit the relations and remove the cyclic dependency.</html>", dep.size() - 1);
        pnl.add((Component)new JLabel(msg), "North");
        DefaultTableModel model = new DefaultTableModel();
        model.addColumn(I18n.tr("Relation ...", new Object[0]));
        model.addColumn(I18n.tr("... refers to relation", new Object[0]));
        for (int i = 0; i < dep.size() - 1; ++i) {
            Relation r1 = dep.get(i);
            Relation r2 = dep.get(i + 1);
            model.addRow(new Relation[]{r1, r2});
        }
        JTable tbl = new JTable(model);
        OsmPrimitivRenderer renderer = new OsmPrimitivRenderer();
        tbl.getColumnModel().getColumn(0).setCellRenderer(renderer);
        tbl.getColumnModel().getColumn(1).setCellRenderer(renderer);
        pnl.add((Component)new JScrollPane(tbl), "Center");
        return pnl;
    }

    protected void warnCyclicUploadDependency(CyclicUploadDependencyException e) {
        ArrayList<Relation> dep = new ArrayList<Relation>(e.getCyclicUploadDependency());
        Relation last = (Relation)dep.get(dep.size() - 1);
        Iterator it = dep.iterator();
        while (it.hasNext() && it.next() != last) {
            it.remove();
        }
        JPanel pnl = this.buildWarningPanel(dep);
        ExtendedDialog dialog = new ExtendedDialog(Main.parent, I18n.tr("Cycling dependencies", new Object[0]), I18n.tr("OK", new Object[0]));
        dialog.setContent(pnl, false);
        dialog.setButtonIcons("ok");
        dialog.setRememberWindowGeometry(this.getClass().getName() + ".geometry", WindowGeometry.centerInWindow(Main.parent, new Dimension(300, 300)));
        dialog.showDialog();
    }

    @Override
    public boolean checkUpload(APIDataSet apiDataSet) {
        try {
            apiDataSet.adjustRelationUploadOrder();
            return true;
        }
        catch (CyclicUploadDependencyException e) {
            this.warnCyclicUploadDependency(e);
            return false;
        }
    }
}

