#version 330

//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Lesser General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

// Compatibility #ifdefs needed for parameters
#ifdef GL_ES
#define COMPAT_PRECISION mediump
precision mediump float;
#else
#define COMPAT_PRECISION
#endif

#if defined(VERTEX)

#if __VERSION__ >= 130
#define COMPAT_VARYING out
#define COMPAT_ATTRIBUTE in
#define COMPAT_TEXTURE texture
#else
#define COMPAT_VARYING varying 
#define COMPAT_ATTRIBUTE attribute 
#define COMPAT_TEXTURE texture2D
#endif

#ifdef GL_ES
#define COMPAT_PRECISION mediump
#else
#define COMPAT_PRECISION
#endif

COMPAT_ATTRIBUTE vec4 VertexCoord;
COMPAT_ATTRIBUTE vec4 COLOR;
COMPAT_ATTRIBUTE vec4 TexCoord;
COMPAT_VARYING vec4 COL0;
COMPAT_VARYING vec4 TEX0;

vec4 _oPosition1; 
uniform mat4 MVPMatrix;
uniform COMPAT_PRECISION int FrameDirection;
uniform COMPAT_PRECISION int FrameCount;
uniform COMPAT_PRECISION vec2 OutputSize;
uniform COMPAT_PRECISION vec2 TextureSize;
uniform COMPAT_PRECISION vec2 InputSize;

// compatibility #defines
#define vTexCoord TEX0.xy
#define SourceSize vec4(TextureSize, 1.0 / TextureSize) //either TextureSize or InputSize
#define OutSize vec4(OutputSize, 1.0 / OutputSize)

void main()
{
    gl_Position = MVPMatrix * VertexCoord;
    TEX0.xy = TexCoord.xy;
}

#elif defined(FRAGMENT)

#if __VERSION__ >= 130
#define COMPAT_VARYING in
#define COMPAT_TEXTURE texture
out vec4 FragColor;
#else
#define COMPAT_VARYING varying
#define FragColor gl_FragColor
#define COMPAT_TEXTURE texture2D
#endif

#ifdef GL_ES
#ifdef GL_FRAGMENT_PRECISION_HIGH
precision highp float;
#else
precision mediump float;
#endif
#define COMPAT_PRECISION mediump
#else
#define COMPAT_PRECISION
#endif

uniform COMPAT_PRECISION int FrameDirection;
uniform COMPAT_PRECISION int FrameCount;
uniform COMPAT_PRECISION vec2 OutputSize;
uniform COMPAT_PRECISION vec2 TextureSize;
uniform COMPAT_PRECISION vec2 InputSize;
uniform sampler2D Texture;
COMPAT_VARYING vec4 TEX0;

// compatibility #defines
#define Source Texture
#define vTexCoord TEX0.xy
#define texture(c, d) COMPAT_TEXTURE(c, d)
#define SourceSize vec4(TextureSize, 1.0 / TextureSize) //either TextureSize or InputSize
#define OutSize vec4(OutputSize, 1.0 / OutputSize)

float nnedi3(int comp) {
    vec2 p = floor(gl_FragCoord.xy);//vec2(floor(vTexCoord.x * OutputSize.x), floor(vTexCoord.y * OutputSize.y));
    if (mod(p.x, 2.0) == 0.0) {
        return texture(Source, vTexCoord.xy)[comp];
    }
#define GET(i, j) texture(Source, vTexCoord.xy + (vec2((j) - (1.500000), (i) - (3.000000))/SourceSize.xy))[comp]
	vec4 samples[8];
	samples[0] = vec4(GET(0.0, 0.0), GET(1.0, 0.0), GET(2.0, 0.0), GET(3.0, 0.0));
	samples[1] = vec4(GET(4.0, 0.0), GET(5.0, 0.0), GET(6.0, 0.0), GET(7.0, 0.0));
	samples[2] = vec4(GET(0.0, 1.0), GET(1.0, 1.0), GET(2.0, 1.0), GET(3.0, 1.0));
	samples[3] = vec4(GET(4.0, 1.0), GET(5.0, 1.0), GET(6.0, 1.0), GET(7.0, 1.0));
	samples[4] = vec4(GET(0.0, 2.0), GET(1.0, 2.0), GET(2.0, 2.0), GET(3.0, 2.0));
	samples[5] = vec4(GET(4.0, 2.0), GET(5.0, 2.0), GET(6.0, 2.0), GET(7.0, 2.0));
	samples[6] = vec4(GET(0.0, 3.0), GET(1.0, 3.0), GET(2.0, 3.0), GET(3.0, 3.0));
	samples[7] = vec4(GET(4.0, 3.0), GET(5.0, 3.0), GET(6.0, 3.0), GET(7.0, 3.0));
	float sum = 0.0, sumsq = 0.0;
	for (int i = 0; i < 8; i++) {
		sum += dot(samples[i], vec4(1.0));
		sumsq += dot(samples[i], samples[i]);
	}
	float mstd0 = sum / 32.0;
	float mstd1 = sumsq / 32.0 - mstd0 * mstd0;
	float mstd2 = mix(0.0, inversesqrt(mstd1), mstd1 >= 1.192092896e-7);
	mstd1 *= mstd2;
	float vsum = 0.0, wsum = 0.0, sum1, sum2;
#define T(x) intBitsToFloat(x)
#define W(i,w0,w1,w2,w3) dot(samples[i],vec4(T(w0),T(w1),T(w2),T(w3)))
#define WS(w0,w1) sum1 = exp(sum1 * mstd2 + T(w0)); sum2 = sum2 * mstd2 + T(w1); wsum += sum1; vsum += sum1*(sum2/(1.0+abs(sum2)));
	sum1=W(0,1040079017,-1129953383,-1112255447,-1100320116)+W(1,1039284509,991372703,1013856427,-1108390802)+W(2,-1115658697,1052077971,1056937139,1052646725)+W(3,-1091236407,-1106109018,-1112818013,1030287040)+W(4,-1107150591,-1102425550,-1089460941,1029401490)+W(5,1057992884,1043570389,1044897031,1028923089)+W(6,-1119789534,1027055297,1033358144,-1121552872)+W(7,-1097729145,-1111268755,-1110301789,-1132036495);sum2=W(0,-1108031914,1026461175,1032549274,1041814131)+W(1,1017353224,-1121140359,-1132764107,-1138465879)+W(2,-1118430023,1041449883,1072973866,-1076980873)+W(3,-1111091488,1028730196,-1121430441,-1127880506)+W(4,1012288055,1027150813,1049697467,-1082819831)+W(5,1041587393,1027133694,-1122016279,-1141547063)+W(6,1013768747,-1122068949,1026059807,1036691428)+W(7,-1152272302,-1116481805,1025296987,1012449399);WS(-1098744132,1034278418);
	sum1=W(0,-1103397220,-1124165708,-1110800938,1026719460)+W(1,1022646298,1032193166,1022064347,-1136800346)+W(2,-1145635621,1041815523,-1099348442,-1092523700)+W(3,-1100009602,-1088889154,-1104673163,-1098235958)+W(4,-1105248316,-1120033612,1050332487,1047722705)+W(5,1037024150,1057456646,1045722836,1051861685)+W(6,1050544938,1021903208,1035939706,994253234)+W(7,1017012340,992386946,-1126668889,1007925993);sum2=W(0,-1097631923,1038271179,1016052501,1038061501)+W(1,-1098093629,1036023945,-1103222197,1049634734)+W(2,1051137052,-1138123466,1047950529,1066995446)+W(3,1052164534,-1086456688,-1092315790,-1088937960)+W(4,1049915324,-1101382095,1053016941,1044310058)+W(5,-1101624661,-1097740488,1025704121,-1095498431)+W(6,-1103655169,1030554459,-1103587135,1039796029)+W(7,1022295275,1002073396,1009745942,1037237655);WS(-1082862242,-1106529553);
	sum1=W(0,-1130854575,-1136558799,-1106220300,1011297096)+W(1,1032803517,1003802452,-1130818358,-1115833284)+W(2,1035507577,-1134799464,1050921813,1017516694)+W(3,-1083278305,-1113237716,-1166618304,1036440480)+W(4,-1111381151,-1109420173,-1090777253,1058584025)+W(5,1053793791,1038764911,1011564912,-1125528356)+W(6,-1121770975,1040932752,1042678624,1023914089)+W(7,-1114891124,1024022374,1003125716,-1148371520);sum2=W(0,-1113253112,1017383795,-1098397046,-1105653936)+W(1,1043748521,-1130700635,1040646747,-1134989990)+W(2,-1114468103,-1105748811,1042070822,1062131274)+W(3,-1088478625,1039489157,-1112481937,-1118262998)+W(4,1046106511,1042779663,1049941293,1049624420)+W(5,-1093962905,-1102421728,-1120850913,-1124158867)+W(6,1029911106,-1111927878,-1106009556,-1113543954)+W(7,-1110290200,1032413051,1032000907,1027657598);WS(1055738180,1034492849);
	sum1=W(0,-1130881323,-1114926341,1041145701,-1109424308)+W(1,-1112247108,-1112831856,-1114665081,-1121239258)+W(2,-1111251428,-1128721888,-1099536939,1051914904)+W(3,1058202118,1051860704,1026763985,-1130346670)+W(4,1042092597,1039888312,1055510938,-1131357522)+W(5,-1089549409,-1104754439,-1109075065,-1117425768)+W(6,1006685651,-1103919286,-1104400342,-1113433279)+W(7,1022435899,-1139575663,-1129253153,-1142807791);sum2=W(0,-1110077216,1036549925,-1103858204,1011211476)+W(1,1008268344,1023981444,1010863636,1034090633)+W(2,-1118181126,-1116107500,1042025735,1056055130)+W(3,-1090440399,-1117941654,1001166765,-1130298175)+W(4,1049383148,1034915268,1044994486,1058209450)+W(5,-1098004228,-1099569204,-1121873216,-1107211558)+W(6,-1110853226,-1119533468,-1101175453,-1113779586)+W(7,-1109857174,1034145803,1026441284,1033292040);WS(1056018244,-1109435672);
	sum1=W(0,1028147653,1025593127,1019179235,1042157337)+W(1,-1110312463,1019247612,-1120006735,-1144225212)+W(2,-1121172806,-1108190871,1044333967,-1098176216)+W(3,1052400296,1041545807,-1152440548,1040728133)+W(4,-1156629272,1019648283,-1105021998,-1084323638)+W(5,1052575762,-1144495302,960835398,-1117757541)+W(6,1029524274,998861994,-1126875818,1048944704)+W(7,-1112766254,1027979993,-1115664295,-1127435447);sum2=W(0,-1133465842,1037565600,-1114814180,1023511793)+W(1,1028077461,1005396583,1022326514,-1149118303)+W(2,1020564842,-1103457632,1043192653,1057142397)+W(3,-1101196001,1038394412,-1113456189,-1137100532)+W(4,-1109452473,1042355402,-1103393926,1042803000)+W(5,-1093624788,-1094252679,1041416796,1021621854)+W(6,1020759546,1025892619,1033812672,1040091206)+W(7,-1104532905,-1153222990,-1130818626,1028700597);WS(1058353218,1042996167);
	sum1=W(0,1024954343,1015847030,1036476495,-1110665693)+W(1,-1121159378,-1108641009,-1137738249,-1102251787)+W(2,-1094124879,-1107919793,-1097421664,1048862286)+W(3,1033331871,1049066134,1023600450,1041347474)+W(4,1052314513,-1138612357,1044445371,1050687635)+W(5,-1102818752,998963493,-1113493234,1023627001)+W(6,1009270680,-1116609353,-1202266712,-1105910956)+W(7,1018868510,-1115498359,1016588291,-1119202191);sum2=W(0,-1126808420,980939457,-1123796075,1037410136)+W(1,1002142140,-1139817292,-1134378480,-1142652688)+W(2,-1120540574,-1110048722,1033167871,-1106277561)+W(3,-1166268225,-1116671070,-1143978200,1011961658)+W(4,-1098896413,-1075343834,-1086151008,1075199384)+W(5,1058982643,-1127002394,1028067074,1027681870)+W(6,1039187917,-1110843188,1032482295,991431992)+W(7,-1123555130,-1163241473,1021947375,-1117918702);WS(1065448321,-1123448424);
	sum1=W(0,1033675765,1010310940,-1135157253,-1130617674)+W(1,1045868403,1037821135,1029877230,-1107423852)+W(2,1042933049,1048779866,1053164479,1054681092)+W(3,-1088933089,-1096402228,-1112063319,-1132569296)+W(4,-1113419593,-1098481070,-1085464413,1025088582)+W(5,1052703622,1043193000,1039463880,1039088003)+W(6,-1107290229,1033876859,1028430645,-1126554424)+W(7,-1113028565,-1114258373,-1131689691,992526257);sum2=W(0,992398551,1027463162,-1110914988,-1119896935)+W(1,-1100289244,1024218964,-1111923136,1036361104)+W(2,-1118632904,-1115592424,-1094541616,1058308065)+W(3,1052134722,-1139018826,1043392525,-1114310803)+W(4,-1109433050,998577524,-1095126430,1059518579)+W(5,1038527426,-1109739820,1004586244,1020338285)+W(6,-1143518596,-1122494561,-1116426235,-1103007923)+W(7,-1121464784,-1115201103,-1120049915,-1128089075);WS(1050696068,-1101686596);
	sum1=W(0,1030829490,1025629886,1028506281,1044306231)+W(1,1022456523,1033300499,1025382374,-1126351518)+W(2,1032239887,1039198082,1035777849,-1094476563)+W(3,1053256444,-1108777674,-1125496907,1013615278)+W(4,1015204626,1033819234,1052890832,-1083567844)+W(5,-1095460989,1028011096,-1117978119,1022077689)+W(6,-1113406309,1030627629,-1111973334,1049080890)+W(7,1026744658,1009469122,1014700692,-1117484787);sum2=W(0,-1123705959,1033160533,1021465594,1019539230)+W(1,-1115261066,1030761443,1021971134,-1122567677)+W(2,-1116235595,1028975273,-1105037500,1055127070)+W(3,1039390029,-1104569658,1024962787,999405400)+W(4,1034058997,-1094422871,-1106553103,1036912081)+W(5,-1113630050,1034816057,-1131788338,1014360364)+W(6,-1139597844,-1122943830,-1103106284,1037858431)+W(7,1034945731,997585040,-1137214108,1023175710);WS(1058623938,1044469574);
	sum1=W(0,1045615020,1035147318,1047639223,1050348390)+W(1,1030161626,1044899106,-1132009366,1044251461)+W(2,-1108426137,-1141312974,-1105886038,-1079944741)+W(3,1039515483,1021302290,-1167333042,991624716)+W(4,-1135193336,1044306859,-1122107414,-1085342603)+W(5,-1100470855,-1110191310,-1180200419,-1100960996)+W(6,1044911680,1030580258,1043270872,1051720601)+W(7,1041363874,1041545713,1040848727,1042676794);sum2=W(0,-1126998679,-1112584470,-1125720699,1026650453)+W(1,-1098785634,1035354845,-1103280207,-1117822839)+W(2,-1097249916,-1101780852,-1124055793,1050619160)+W(3,1044368398,-1115949975,1036370417,1013784870)+W(4,1048536708,1037003529,1040132893,1058508674)+W(5,1037637019,-1106591466,-1109803757,-1104576316)+W(6,-1118913729,-1122142287,1008038822,-1117660887)+W(7,-1121056345,1006096779,-1116815483,-1119752481);WS(-1092650820,-1093598320);
	sum1=W(0,-1126483198,-1136033646,1019177644,-1119240794)+W(1,-1095523617,-1108863241,-1113123137,-1126435736)+W(2,-1111185837,-1107026560,-1096033968,-1101350837)+W(3,1057301262,1042409572,1040959081,1035081684)+W(4,1032567139,-1113511425,1059010394,1042563567)+W(5,-1131092420,-1108714423,-1114101506,-1106962654)+W(6,1028684103,1034982933,1025024233,-1118967697)+W(7,-1118984463,1023629806,-1128061252,-1142697342);sum2=W(0,-1118904411,-1158272012,1013234849,1030464194)+W(1,-1106482941,1025489390,-1129648553,1028128070)+W(2,-1134435633,-1107189637,-1120249847,1057018316)+W(3,1048792270,1024832618,1031754422,-1125347555)+W(4,-1102280300,992574886,-1083559741,1062197029)+W(5,1040811198,-1114392001,1031998303,1029475610)+W(6,-1150017862,-1122133752,-1146867651,-1097179586)+W(7,-1115216614,1021081809,-1112304821,993658022);WS(1058173058,1066808129);
	sum1=W(0,-1107348220,-1099127505,-1103913530,-1113478482)+W(1,1040539139,-1113016318,-1120477164,1000206250)+W(2,1035236882,1036577094,1044208414,1029276252)+W(3,-1097605967,-1100723463,1029619500,-1122925746)+W(4,1041707116,1043659283,1046852514,1039741986)+W(5,1044710619,1043551606,-1133641268,994694705)+W(6,-1121094224,-1105652573,-1107481241,-1121409754)+W(7,1032545388,-1115290924,1013015214,950366748);sum2=W(0,-1094008764,-1105723160,-1087139249,1052425931)+W(1,1056772124,1034445536,1012087213,1037095176)+W(2,1034130054,-1120175931,1064201383,1002356625)+W(3,-1089869944,-1114835724,-1123264660,-1129286431)+W(4,1031813868,1042930394,-1110465854,-1098172076)+W(5,1043061462,-1102352886,1040830367,-1111397998)+W(6,1011760553,-1124103013,-1131636845,1006833373)+W(7,1007319139,1014923704,1016549099,993051546);WS(1061928770,1027279769);
	sum1=W(0,1034406912,-1113862823,1039933724,-1111710246)+W(1,-1111349982,-1109997378,-1113344954,-1114279935)+W(2,-1100123699,-1162686055,-1096018034,1056786929)+W(3,1056534441,1044907121,1022437288,1031029722)+W(4,1029564087,-1109708970,1050604450,1037263862)+W(5,-1098017894,1038664521,-1116167797,1027389387)+W(6,1033006716,-1128579510,1007368299,-1109765633)+W(7,-1113416432,-1101798872,-1105438789,-1113862289);sum2=W(0,1026006751,-1108403600,1035073774,-1122004937)+W(1,1035952663,1015050843,-1124438030,-1133483016)+W(2,-1115270559,1031363022,-1104904057,1031769509)+W(3,-1106336513,1027760004,1019789656,-1118390529)+W(4,1024783342,1033798448,1037041630,1039898935)+W(5,1057393141,1027825620,-1121305243,-1128829234)+W(6,-1130316822,-1139293944,1025961213,1021529214)+W(7,-1112547455,-1096601581,-1105185563,-1106336479);WS(1053752708,1043937257);
	sum1=W(0,-1114168512,-1112521242,-1097902456,-1095288434)+W(1,-1094410051,-1114520925,-1115668990,-1105295129)+W(2,-1105170221,-1098204331,1046102006,1066642253)+W(3,1054367941,-1100810554,-1121904763,1031167873)+W(4,1031197758,-1104934543,1042705158,1070561411)+W(5,1038022813,1032266099,-1114135854,-1123380722)+W(6,-1109039567,-1113606305,-1098767200,-1089903115)+W(7,-1100846418,-1108028099,-1115062077,-1118408200);sum2=W(0,-1113064749,-1144787532,-1115681675,1041111385)+W(1,-1130408019,-1136936214,1022660811,-1121651306)+W(2,-1090786559,-1094418907,1009808406,1053253351)+W(3,1015714915,1020895003,-1117683238,1028089270)+W(4,1038982572,-1102980167,1041806798,1054413523)+W(5,1024043560,-1114777947,1021536435,-1123371786)+W(6,-1136678198,-1129681067,1023762114,1035936399)+W(7,-1114747797,1001107148,-1129865467,1019986163);WS(-1077899937,-1095640595);
	sum1=W(0,1038010313,1026389718,1040451742,1038149954)+W(1,1012098034,1041468735,1036152598,1035936827)+W(2,1032811586,1036208246,-1100196466,-1112596654)+W(3,1057575303,1025151035,-1108998502,-1117388883)+W(4,-1097475626,-1123908524,1051006893,-1096170677)+W(5,-1089360567,-1102384270,-1117118702,1019229383)+W(6,1033727032,-1117534996,-1116405267,1043001855)+W(7,1035677341,-1122502968,959089718,-1122221082);sum2=W(0,1014408115,1031626038,1042237958,1024306585)+W(1,1005347958,-1108949069,-1129272561,-1155665460)+W(2,1037203464,-1111295182,-1111204470,1046645930)+W(3,1036175171,-1102667672,-1105300490,-1098212068)+W(4,-1112987386,1033188726,1033012571,1040504174)+W(5,1022488131,-1113110436,1012028387,1026136762)+W(6,1006518986,998532726,1002908510,-1142339005)+W(7,1028667874,1028194944,991631364,-1118275484);WS(1052188868,-1105025774);
	sum1=W(0,1026006805,-1127133881,-1111238899,1039605133)+W(1,1036489378,1027868467,1028341284,1040022103)+W(2,1053332527,1046329385,1054121990,1041936861)+W(3,-1098161716,-1100202284,-1114580002,-1112308133)+W(4,-1093124457,-1102124985,-1093232644,-1108714798)+W(5,1047964177,1042303686,1042593657,1033044781)+W(6,1016895952,1015047702,1031180874,-1123947762)+W(7,-1116894641,-1100188956,-1114267170,-1120167377);sum2=W(0,-1098242390,-1090155459,-1080159437,-1083172772)+W(1,1043663143,1066420271,1065821018,1052081121)+W(2,1038124206,-1111850856,-1111691725,1045262621)+W(3,-1107342132,-1115094311,1045364599,1039539139)+W(4,1035251585,-1110800852,1033462452,-1116129960)+W(5,-1117401930,1036826747,-1121811075,1031476522)+W(6,-1146833441,1015159009,-1114532383,1037947101)+W(7,-1115149205,-1118954060,-1159263732,-1144829650);WS(-1102870152,1022622513);
	sum1=W(0,1055644087,1035394969,1045649819,1045987408)+W(1,1030573816,1031111560,1035095156,1041054212)+W(2,-1105950504,-1108831748,1041190721,1039545500)+W(3,1049616144,1056957379,1047436506,1055423038)+W(4,-1114669622,1043185370,-1098060649,-1093030704)+W(5,-1093912525,-1084377448,-1093512673,-1094643096)+W(6,-1099940547,1029691760,-1105006556,1034170571)+W(7,1028754581,1032315050,1008186016,1002093997);sum2=W(0,-1084145430,1037387540,-1091365810,-1096604175)+W(1,-1095647742,1043123500,-1106696806,1053814194)+W(2,1070336926,-1098862516,1050914492,1068317532)+W(3,1054262144,-1083131387,1046449081,-1081281727)+W(4,1055168354,-1095516697,1050568943,1069441477)+W(5,-1090345251,-1085743049,1048225937,-1086819148)+W(6,-1086613448,1056626754,-1097405209,-1099937369)+W(7,-1106692290,1045945631,-1106594556,1058187197);WS(-1069426976,-1120848841);
	sum1=W(0,1036938172,1035259664,1047028417,1052190352)+W(1,1041456894,1039915051,1015525967,1036563112)+W(2,1037072255,997868135,1031706371,-1092031243)+W(3,1045414333,1026900661,-1119324359,1015048091)+W(4,-1103659451,1049019033,-1095105906,-1081236347)+W(5,-1090672009,1032303833,1008361890,-1146656500)+W(6,1032159990,1025792718,1020529436,1049696791)+W(7,1038916826,1035011641,1039253091,-1145253028);sum2=W(0,-1131675185,-1130807793,-1137547874,-1119117212)+W(1,-1138868050,-1139313154,-1127085641,-1144490820)+W(2,1029191442,-1132163681,-1115933340,-1086087178)+W(3,-1112002886,1014175682,1023290113,-1135148482)+W(4,-1114450600,1018117017,1033829647,1063181450)+W(5,1026390676,-1143924164,-1138352802,1007342770)+W(6,1024984252,-1115031522,1037592454,1006729954)+W(7,1017409241,-1134939410,-1125048401,974288160);WS(-1092511940,1056045775);
	sum1=W(0,1034351639,1036571263,1026078569,1044122211)+W(1,-1145831724,-1113387827,1018446892,-1119385695)+W(2,-1122413709,-1107220477,-1123595634,-1099810889)+W(3,1052039823,1050308552,1032192235,1047960215)+W(4,1034842253,1031880235,1048156900,-1106066347)+W(5,-1096815763,-1095462256,-1104039774,-1105858435)+W(6,-1109413949,-1128037178,-1106487287,1038991202)+W(7,1016305349,1039930976,-1145490603,-1115254417);sum2=W(0,-1129634341,-1125984965,-1131211232,1032304695)+W(1,-1126835561,-1135310730,1030376830,-1115706548)+W(2,1017418680,-1145267460,1019434782,-1112808134)+W(3,1027589163,-1164412329,1012340975,1024240430)+W(4,1033383321,-1108053053,1035592777,1017461836)+W(5,-1125819067,1048432434,-1132396034,1037084632)+W(6,-1086264457,-1078809375,-1073693037,-1098879629)+W(7,1071963841,1073307463,1053688201,-1110470100);WS(1042257800,-1115776325);
	sum1=W(0,-1146926115,1032352980,-1109330569,-1114314051)+W(1,1039411448,-1111850704,1040829028,-1123393177)+W(2,-1107281138,-1098526814,1043068219,-1109412128)+W(3,-1097266597,1039093055,-1100632132,-1104810789)+W(4,1038400362,1045994468,-1111135982,-1144690495)+W(5,1057956169,-1128243973,1048043508,1025450855)+W(6,1010013391,-1117084567,1043908518,-1120663934)+W(7,-1098521248,-1122589083,1029880783,997333453);sum2=W(0,1029402915,-1131137316,1031911869,1023173531)+W(1,1023792141,-1123803784,1014267385,-1128776324)+W(2,-1139977433,-1118253197,-1122896144,-1122404168)+W(3,-1098422336,1037623928,-1106514445,1036548666)+W(4,-1102627522,1040550677,-1088615745,1061434285)+W(5,1075510495,1067804318,1045458757,1035151624)+W(6,1041328458,-1112092070,1058291503,-1087193418)+W(7,-1072676007,-1079538943,-1106625048,-1107997040);WS(1062572194,-1113128476);
	sum1=W(0,1025054504,1032745069,-1111717923,-1115121012)+W(1,1039928305,-1108655721,1042636501,-1121873307)+W(2,-1105909778,-1098454710,1040855323,-1102647392)+W(3,-1094658254,1048800872,-1098634802,-1107065062)+W(4,1035303099,1048922046,-1111940687,1030883818)+W(5,1056642050,-1114397119,1045405821,1028123977)+W(6,1030405814,-1107189334,1047137430,-1120733568)+W(7,-1102007432,-1121522301,1030940241,-1129454014);sum2=W(0,-1114559261,1015935669,-1119968612,1034980574)+W(1,-1134322843,1031387619,-1130912561,1028413753)+W(2,-1138228901,1029828517,-1110320033,-1095660939)+W(3,1043622789,-1103434641,1043842027,-1104010102)+W(4,1049277284,-1107208114,1062476231,-1090290563)+W(5,-1071408041,-1079628774,-1100585862,-1110973692)+W(6,-1102431407,1036930870,-1086736101,1061616421)+W(7,1075586093,1068626110,1036267766,1043722127);WS(1060774594,1031131703);
	sum1=W(0,-1107942447,-1105426838,-1102134060,-1108928460)+W(1,1030069408,-1109912496,-1111247296,1016389396)+W(2,1045023814,1048858052,1057375412,1053310638)+W(3,-1086363546,-1121814959,-1121700033,-1112979299)+W(4,1022102280,1019498368,-1089780107,1054202179)+W(5,1056436400,1045750878,1017717699,-1115080444)+W(6,-1109726834,-1115599332,1024119623,-1117349999)+W(7,-1105657043,-1112636534,1020787328,1034439495);sum2=W(0,1036474850,-1117613837,993333704,-1124280889)+W(1,-1120272689,-1147158916,-1136721538,1006917274)+W(2,-1115841609,1015990489,-1114813616,1046600726)+W(3,-1127188969,-1101686418,-1106242516,-1111325506)+W(4,-1115206474,-1121605429,1041891165,1051997378)+W(5,-1122067781,1035140408,1020051521,-1113122752)+W(6,1027456791,-1155010952,-1115442992,-1145891812)+W(7,-1135549634,1009536026,1019245009,1017045509);WS(1060194466,-1100017114);
	sum1=W(0,-1107280066,-1110455654,-1108454907,-1102634810)+W(1,-1103570769,-1103041901,-1108837738,-1103753711)+W(2,-1105747811,-1101985628,1018718942,-1106901713)+W(3,1046100821,1055521256,1047438565,1059153514)+W(4,1059466063,1043733237,1057500851,1036011765)+W(5,1016328357,-1113318903,-1139455183,-1111475141)+W(6,-1103466926,-1106475814,-1106517942,-1094721336)+W(7,-1110005824,-1108487663,-1116101330,-1118902112);sum2=W(0,-1134258178,1016306377,-1119701101,-1121134035)+W(1,-1110905440,-1123898542,-1120388479,-1131815221)+W(2,-1116481221,-1123533287,-1150894505,1050682292)+W(3,1003934853,1016401385,1010383122,1025651043)+W(4,1032034504,-1130975497,-1129842733,1050657130)+W(5,1032136922,-1114630639,-1135861370,-1115813895)+W(6,-1123729210,-1124034546,-1119840142,-1118895679)+W(7,-1115758498,-1135589646,-1140270714,-1126135829);WS(-1094780356,-1096037829);
	sum1=W(0,-1094564683,998269945,-1106439374,-1099790159)+W(1,1039955171,-1116696534,1026955814,-1132274079)+W(2,1051641704,1048993133,-1105882161,1021385644)+W(3,-1110801281,-1093602407,1040928722,-1094848202)+W(4,1042321778,-1097112145,1049078036,1039341071)+W(5,1035258371,1056382370,1035779188,1053064740)+W(6,-1109647669,1034946343,-1120792141,-1101585581)+W(7,1020526630,-1124429730,-1106396689,1027970323);sum2=W(0,-1137596463,-1129205035,-1126343315,1039861741)+W(1,-1126312459,-1123052878,996868828,-1125851727)+W(2,1029577680,-1107142480,1047351132,-1098569120)+W(3,1038608299,-1116615219,-1112533224,-1107291575)+W(4,1038439017,1015352075,1070713407,1073186805)+W(5,1038004689,-1073950732,-1077903771,-1107100148)+W(6,-1113448033,1012914617,-1114069586,1046610276)+W(7,-1144677526,1007385420,-1108941862,1037961064);WS(1053603780,-1115461008);
	sum1=W(0,-1137418943,1030817204,1016256157,1021933093)+W(1,-1107174285,1024187323,-1121722108,1027865701)+W(2,-1097293942,-1095449155,-1092155167,1049349309)+W(3,-1125654285,-1107838901,-1112035518,-1115980033)+W(4,1049585228,1046317951,1056038503,1058232189)+W(5,-1109114845,-1104780729,-1104946775,-1096840466)+W(6,1014991997,-1134044169,-1118818050,-1129232467)+W(7,1020919504,1042320778,1033110781,1040979266);sum2=W(0,1033231462,-1122607696,-1126070520,1021774826)+W(1,-1120788802,1023918789,-1127228708,-1155086158)+W(2,-1115237141,1031925962,1042960949,1053325526)+W(3,-1107200469,-1112013861,-1114604471,-1120863174)+W(4,-1111323807,-1115623012,-1119706606,1049744257)+W(5,1005054791,1026671690,-1107279270,-1119270266)+W(6,1022510111,1016053183,999155791,-1130112624)+W(7,-1116359926,-1115047971,-1133439199,-1114777589);WS(1049944452,-1118177299);
	sum1=W(0,1004954534,1034605113,1042179871,1046072096)+W(1,-1119832136,-1115172412,1021914321,-1125265763)+W(2,-1113835168,-1117712807,1049772083,-1089565448)+W(3,-1087875066,1028249398,-1115173764,1016032028)+W(4,-1131743895,1044152226,-1105992217,-1102704504)+W(5,1051885673,1023284205,1032417701,1023720959)+W(6,1036431958,-1113909672,1034469319,1047091406)+W(7,-1117867957,1037431354,-1128742159,1027934165);sum2=W(0,-1122048832,-1102028824,-1098388207,1042109429)+W(1,1037898289,1035691269,-1120157845,1026959129)+W(2,1053033259,1033866732,-1083784972,1035235216)+W(3,1056376564,-1103367787,1034674212,-1128193065)+W(4,-1121809206,1014156522,1055740053,-1104400409)+W(5,-1126110057,-1120368299,1015248281,984939091)+W(6,-1100778293,1033801710,-1112352078,1046653262)+W(7,-1111071353,1025902829,997672170,-1153716682);WS(-1165444096,-1119710264);
	sum1=W(0,1042994118,1034244741,1037778378,1041081798)+W(1,1016348739,1044760836,-1126699940,1049969601)+W(2,1051115175,1042802936,1051394930,-1114386041)+W(3,1044466585,1039392600,1042064672,-1111502020)+W(4,-1098028621,1040688824,-1088773549,-1087521946)+W(5,-1089153334,-1102706330,987979863,-1112154588)+W(6,-1108071955,1032455940,-1120702728,1029133552)+W(7,1045508004,-1117660781,1043978432,-1112358151);sum2=W(0,-1113048377,-1169925094,1033233769,1022227231)+W(1,973479782,1025958326,-1175748301,-1108998850)+W(2,1060341068,1041247352,999982909,-1081289783)+W(3,-1090689511,1036288861,1044034366,1055733822)+W(4,1067872749,1057359743,-1089189226,-1075624869)+W(5,-1088323315,1048635178,1052769876,1060416891)+W(6,-1107478445,-1121919154,-1112420946,1030919570)+W(7,1049895882,-1108655271,1042449401,-1098757157);WS(-1077066897,-1138646112);
	sum1=W(0,1024267775,1009759453,1034803609,-1105412061)+W(1,-1118414542,-1104989395,1000523125,-1099033634)+W(2,-1092381223,-1106693383,-1096180043,1042083852)+W(3,1031147625,1050244398,1024065726,1045342865)+W(4,1053014632,1027242622,1051220983,1053447283)+W(5,-1105039519,1023828386,-1110843104,1028746421)+W(6,1025453154,-1118474373,-1149202983,-1101608091)+W(7,1010847661,-1113932053,1023831870,-1113130950);sum2=W(0,1013870164,-1133465912,1030888661,-1118337904)+W(1,1030672570,-1156287199,1014316520,-1145191680)+W(2,1032969077,1032956180,-1118666398,-1095979039)+W(3,-1102611716,1041525268,-1121602320,-1129518532)+W(4,1050672871,1076869477,1063553933,-1069322680)+W(5,-1088200357,1026168517,-1129519600,-1120095414)+W(6,-1105627059,1037977967,1017901782,1026329625)+W(7,-1169512700,-1153801247,-1126632288,1031405165);WS(1059038658,1028594353);
	sum1=W(0,1030613999,-1132336275,-1117493948,1038489844)+W(1,1028206993,1044643916,1007880004,1043840791)+W(2,1027001704,1035531624,1032402678,-1152158733)+W(3,-1098315241,-1088517514,-1103996748,-1091506711)+W(4,-1089493909,-1094328658,-1106243079,1052296065)+W(5,1042911580,1049587060,1035409673,1044000434)+W(6,1046010101,1026431736,1043051950,1044337864)+W(7,1028671678,1032918142,-1137633217,1036291743);sum2=W(0,-1118922878,998383694,-1117830208,-1123342062)+W(1,-1109116635,-1124252768,-1104593856,1026377322)+W(2,-1105269646,-1109062791,1013977255,1052555170)+W(3,1041098100,1040874722,1030669290,1040986964)+W(4,1050974192,1002191246,1046707356,1051646415)+W(5,1036678597,-1098775079,-1122565606,-1098750401)+W(6,-1110275215,-1111322692,-1114811922,-1114439732)+W(7,-1108145020,-1121186646,-1115485971,-1115223671);WS(-1089038754,1070610314);
	sum1=W(0,1006818038,-1126323612,1015379312,-1107760774)+W(1,-1110158738,-1104391397,-1114553627,-1113068735)+W(2,-1112569734,-1099849389,-1090696922,-1101892281)+W(3,1028620400,1047988033,1043536901,1039930893)+W(4,-1110914124,1036085850,1053776546,1045400523)+W(5,1040930437,-1132043583,-1119469430,-1114659286)+W(6,1038135388,1043645143,1040122382,-1118717763)+W(7,1002760462,1016954112,974497054,-1139206280);sum2=W(0,-1120363159,-1119340063,-1119078724,1035843986)+W(1,1035175754,-1106992039,-1128507307,-1129270833)+W(2,1029972206,1020623843,-1137841818,-1094446255)+W(3,1049035968,-1128810267,-1123633215,-1123131987)+W(4,-1135126990,1026762268,1064611900,1017486399)+W(5,-1094749382,1039608352,-1194223384,-1197948696)+W(6,-1111466112,-1099605665,-1102195223,1042926586)+W(7,1014516782,-1112006203,-1136077530,-1129209333);WS(-1120775200,-1094115106);
	sum1=W(0,-1117113151,-1133090109,-1096583070,-1098081804)+W(1,-1092969217,-1119648950,-1113650835,-1105675228)+W(2,-1112921839,-1099947345,1050818928,1057531117)+W(3,1051254629,-1098660371,926574177,1035449878)+W(4,1046145098,-1097096777,1048882552,1067142180)+W(5,1054137781,1035250696,-1115652196,1024424221)+W(6,-1107062579,-1151313622,-1100319675,-1094480203)+W(7,-1100195749,-1111825641,-1118408614,-1114839546);sum2=W(0,-1122846232,1002183233,-1129631292,-1112395279)+W(1,1009610216,1001287537,-1122731504,-1139829356)+W(2,1031116535,-1113707943,988543074,-1080457005)+W(3,-1097715519,1037716560,-1112112395,1031806339)+W(4,-1118531646,1034244245,1027624889,1064104967)+W(5,1052372051,1011412016,1031591085,-1128697528)+W(6,1030028661,-1116699784,1039671963,1037992478)+W(7,-1115290878,1016046512,-1122589730,1022404309);WS(-1083041826,-1088446577);
	sum1=W(0,-1112868382,-1139686881,1037998481,1035817611)+W(1,1028314191,-1112414119,-1123391616,-1152205450)+W(2,-1138041180,998832115,-1108164766,-1106005004)+W(3,1054394898,1042585939,1037009680,1027830053)+W(4,1041478665,1026886463,1018740405,-1092605991)+W(5,-1096954228,-1105339656,-1122534560,-1128384493)+W(6,-1123809603,1007627162,-1137074328,1036557383)+W(7,1043199331,1016960213,949272012,-1161448845);sum2=W(0,1036010005,-1112615912,-1108103320,1026422893)+W(1,1043952518,-1112407780,1025610945,-1142574731)+W(2,-1080772886,-1080108640,1042883784,1067023817)+W(3,1065911618,1043418298,-1121396391,1019038275)+W(4,-1110295637,1033469827,991295446,-1106557392)+W(5,1015020021,-1113416335,-1118133995,1027619053)+W(6,-1113551367,-1118689741,-1123719569,1039881895)+W(7,1028046949,986544491,1028536389,-1114551687);WS(1059656866,1032254503);
	sum1=W(0,1051132033,1032901415,1050001035,1051046262)+W(1,1024623477,1041030197,-1129401004,1040932616)+W(2,-1087438145,-1096624519,-1093591378,-1092342973)+W(3,1024747921,1042870865,-1112612011,1037509038)+W(4,1040121644,1045530925,1040228252,-1096329486)+W(5,-1100479077,-1092498854,-1100524478,-1089145703)+W(6,1047684766,1031967406,1044069767,1050005760)+W(7,1045316401,1048633756,1041789317,1050363772);sum2=W(0,1033723840,-1120765513,-1151198348,-1121736497)+W(1,1020727265,-1111733852,1010605379,-1112033268)+W(2,1054927280,1004192518,1032813206,-1097617496)+W(3,994767756,1024454465,-1124374145,-1107458988)+W(4,-1094930774,1009606707,1018976553,-1096835022)+W(5,-1114598300,1049726638,1040837102,1057385902)+W(6,-1110893464,-1117945313,-1111742424,-1121652889)+W(7,-1144829382,1030389401,-1120942585,1035752486);WS(-1076352721,1061176787);
	sum1=W(0,-1115567878,1039493528,1037423542,1022350014)+W(1,-1114677168,-1123591576,-1143365955,-1114839417)+W(2,-1095051668,-1094852257,-1086623624,1044286862)+W(3,1057477914,1049595083,1036655988,1044280124)+W(4,1047858891,1040618482,1057001770,1036068672)+W(5,-1086915318,-1095930750,-1108386213,1029598047)+W(6,1038434246,-1116442287,-1114755255,1022609452)+W(7,1037805114,1044588197,1031697064,-1119274549);sum2=W(0,1018488840,-1109735653,-1113462230,-1112517262)+W(1,-1108529674,-1112282852,1002563934,1011039855)+W(2,-1104206436,1012246375,-1114523900,1056346033)+W(3,1029007760,-1106712811,-1113168793,-1115338003)+W(4,-1111729053,-1117505825,1042992721,1051780099)+W(5,1042618199,1035563022,1024458488,-1112797570)+W(6,1004158510,-1122544930,-1111468709,-1133433375)+W(7,-1114816198,-1136000711,-1122022613,1037211560);WS(1037340944,-1121222187);
	sum1=W(0,-1116495838,-1118176747,-1096308023,-1094205341)+W(1,-1095502171,-1115640417,-1112496425,-1105702479)+W(2,1040689218,-1110298712,1052341602,1064260668)+W(3,1052009702,-1100646016,-1117627026,1026863896)+W(4,1036502651,-1106426924,1044624667,1068943083)+W(5,1045175252,1004526500,-1108867801,-1112879076)+W(6,-1106495021,-1119752153,-1097659059,-1089978464)+W(7,-1099820424,-1108261518,-1110958217,-1111070831);sum2=W(0,1002312827,-1134403694,1025097519,-1105297347)+W(1,1007461646,-1117960999,-1123847191,-1129847887)+W(2,1043920878,1045056865,-1107896626,1060319926)+W(3,-1100756735,1018292031,-1136355134,-1108036266)+W(4,-1113959010,-1120905299,1031903433,-1100397803)+W(5,1042137547,-1106899263,-1119650359,1033071013)+W(6,-1124888335,1019347263,-1120916959,1028583233)+W(7,-1119634731,-1134844462,998264859,-1109200858);WS(-1087648930,1056984912);
	sum1=W(0,1027950097,1027762677,1025406415,1043195617)+W(1,1035903278,1031391740,1023913741,1033673899)+W(2,1048727276,1043573475,1051177331,-1092810048)+W(3,1038252876,1044809191,1035706934,1020597221)+W(4,-1101873716,1015678999,-1091649404,-1082302860)+W(5,-1097139061,1038200652,1042041459,1041744649)+W(6,-1111974664,1024202483,1016025318,1050173331)+W(7,-1156961168,998750650,1023377112,-1114494621);sum2=W(0,1035604443,-1113891962,-1155240851,-1130359386)+W(1,1025386829,1028100153,1016774458,-1126789482)+W(2,-1109665959,1017090586,1033553543,1061263788)+W(3,-1109330568,-1106256683,-1097657183,-1118236009)+W(4,1027481873,-1115818981,1023852497,1027230949)+W(5,1041592808,-1113120233,-1101411950,-1121071325)+W(6,-1121529027,1006860245,-1124657042,1039189933)+W(7,-1123139111,999905578,-1132638677,-1109638591);WS(-1090940868,1045539156);
	sum1=W(0,-1125495305,-1122547977,1049435900,1022396558)+W(1,1034779456,-1113477720,1025152496,1017461170)+W(2,-1111842948,1036262295,-1083395945,1050733040)+W(3,1050803832,1023164412,-1141132416,-1119150102)+W(4,1024315123,1017057054,1046781659,1016653136)+W(5,-1084181811,1044787970,1025666193,1039405571)+W(6,1033322010,1021788462,1041875702,1032259903)+W(7,1045300311,-1103054087,-1119238479,-1121753565);sum2=W(0,-1111850352,-1115334877,-1101312255,-1131783421)+W(1,1037660946,-1121261620,1008969141,-1118719808)+W(2,-1154701652,1045060155,1053683311,1041887968)+W(3,-1090960245,1034919558,-1118627401,-1117531173)+W(4,1008422401,1033609440,-1090718168,1047082317)+W(5,1034433310,1036748070,-1109720341,998924330)+W(6,-1128983709,-1109145509,1041457249,1009316297)+W(7,1037394704,1030040522,1034723828,-1122112519);WS(1058382658,-1101786424);
	sum1=W(0,-1110270554,-1139041509,-1106470550,-1114587164)+W(1,1023988544,1031022672,1028924449,1026679274)+W(2,1020557616,1040419632,1039037886,-1089217895)+W(3,-1116816379,-1098005290,1030444000,-1105928314)+W(4,1042446649,-1110579152,1052788411,-1102603214)+W(5,1052497916,1048850952,1041387232,1042985742)+W(6,1010032145,1021044303,-1107378131,-1101971332)+W(7,-1110520967,-1136091053,-1142630143,1036784631);sum2=W(0,-1122331173,-1116694246,-1133055086,-1106162040)+W(1,1033705060,-1119866494,1019582103,-1119480360)+W(2,1021048143,-1117334358,985385246,1058597177)+W(3,-1096472079,1040447045,-1107345628,1011504527)+W(4,-1121426033,1034622720,-1111822939,1062397265)+W(5,1007125953,-1124693001,1025700470,1026572561)+W(6,-1141905806,-1109719947,-1111398337,-1092732322)+W(7,-1104483430,-1148551778,-1142669219,-1124513225);WS(1062970978,-1081266569);
	sum1=W(0,-1102316771,1026249566,-1104248914,1037424006)+W(1,1035596338,-1122189220,1016727466,1006845944)+W(2,1049067654,1049251698,-1100292756,-1086541140)+W(3,-1092317470,-1101422105,-1130063849,-1103019359)+W(4,1040583110,1039432874,1040278772,-1096033842)+W(5,1045287213,1049598341,1043296141,1042202275)+W(6,986432279,1031488060,1034368766,1046796153)+W(7,1039493185,1029733120,-1132489681,1032483937);sum2=W(0,-1108138297,1024987284,-1107013954,1038311792)+W(1,-1140508767,999045582,1010876103,-1139420079)+W(2,-1092863213,-1095439435,1054820060,991870971)+W(3,1019051815,1003248078,-1122507350,-1120196608)+W(4,-1134447463,-1107350452,-1104627754,1058790229)+W(5,1049499199,-1113643053,1040683258,-1107048418)+W(6,1020893591,1030342296,1023656240,-1145193326)+W(7,-1111721419,-1124168067,-1111078930,1036851190);WS(-1090709444,1049440503);
	sum1=W(0,-1112814366,1009000949,-1102384190,-1098104133)+W(1,-1100420271,-1117987732,-1108681738,-1118237822)+W(2,1025170444,-1102968365,1054801672,1055216649)+W(3,1007027006,994631719,-1122456724,1037835469)+W(4,1021129071,-1107658202,-1108358704,1055155742)+W(5,1062491877,-1115514619,1032182427,-1137063726)+W(6,-1116166456,1013557870,-1112664461,-1102466049)+W(7,-1093799886,-1139587454,-1112800010,-1119596065);sum2=W(0,1010269627,1011116525,1031226256,1023655690)+W(1,-1117593255,-1139919503,-1131886173,-1132337311)+W(2,-1125700925,1031004177,991734042,1056735713)+W(3,1023598587,-1116020697,1030692092,1014084462)+W(4,-1129465449,-1111184590,-1090395945,1007034923)+W(5,-1114530604,1044588818,-1118660887,1027760305)+W(6,-1124401971,-1139731999,-1123603568,-1106780773)+W(7,1032362667,1019563835,1016903156,1003383541);WS(1052605444,-1096548047);
	sum1=W(0,-1135269079,1014261129,1035728362,1017149121)+W(1,1022065234,-1106055602,-1122459306,-1120275059)+W(2,-1099989408,-1107118442,-1095069609,1004173259)+W(3,-1102684265,1026600311,1029280393,-1114974728)+W(4,1035141158,1022832721,1036930738,1042230040)+W(5,1051854441,-1123731628,1039321653,-1108029264)+W(6,-1157809579,1034237928,1014945855,1022065263)+W(7,-1149699425,1033708682,-1120230985,1040542518);sum2=W(0,-1139099893,-1102121527,-1108414487,1039987934)+W(1,1045186917,-1096991255,1033745090,-1102163660)+W(2,-1078862437,-1076350607,1043522425,1067956735)+W(3,1072447081,1053122067,-1111637970,1040872955)+W(4,-1097588090,998819801,-1111980043,-1109442889)+W(5,1044036972,-1115256553,1027886256,1044251533)+W(6,-1129576496,1024729710,-1134118593,1032654822)+W(7,-1118463242,-1124332658,-1123595298,-1115579557);WS(1054231108,1025279114);
	sum1=W(0,1020527399,1020186806,1026191493,1046988234)+W(1,-1147857037,1041704764,-1120557618,1039867950)+W(2,-1123453065,1039341944,-1104689967,-1092316960)+W(3,-1122753069,-1093206832,-1107112804,-1094240131)+W(4,-1096862627,-1119337841,1034733383,1008801448)+W(5,-1108979241,1050167121,1027712531,1043962418)+W(6,1049493415,-1160786718,1041541558,1041661776)+W(7,1034215919,1032223662,-1156220183,1036558383);sum2=W(0,-1156731980,-1125155383,-1153680156,-1140765671)+W(1,1018992688,1030176462,1027890172,1018002108)+W(2,-1121143571,1021067288,-1101109237,-1079877582)+W(3,-1094350155,1058234221,1064456596,1058386161)+W(4,1027150242,1024911074,-1096825521,-1088644111)+W(5,-1113080073,1052444813,1024094624,1045751986)+W(6,1019039796,-1128517034,1036906894,-1110310177)+W(7,1019841700,1000349534,-1128055622,-1134555143);WS(-1097731588,1025129315);
	sum1=W(0,1033609822,972033083,1036940225,1025915127)+W(1,1037164536,1018117854,1009743167,1021572178)+W(2,1037092684,-1118357663,1046113067,1050865438)+W(3,-1109542297,1047810219,-1111680192,1036701507)+W(4,-1099469177,-1139849211,-1089626010,-1143345853)+W(5,-1104510832,-1097851227,-1113708160,-1110047355)+W(6,-1125480775,-1113410371,1035911587,1047135499)+W(7,1038594118,1031924197,-1146462713,-1120871309);sum2=W(0,-1124965724,-1134630348,-1138485084,-1143859545)+W(1,-1133066340,1030422253,-1121255807,1003464777)+W(2,1029789829,-1105084635,1035852445,1050249105)+W(3,-1114135764,1024721985,-1120848177,1033535897)+W(4,-1119672690,1036116775,1002738585,1057234226)+W(5,-1115375290,-1117221657,1007172972,-1110249095)+W(6,-1132623148,-1123511646,-1106888257,-1097411434)+W(7,-1109817844,1017260494,-1118819718,1021514610);WS(1064258306,1057427735);
	sum1=W(0,1046669668,1048078371,1049007041,1043467602)+W(1,1032131185,1040278032,995640096,-1135631084)+W(2,1041288794,1002554246,1039217007,-1117262306)+W(3,1041191743,1037075392,-1121877906,1026049048)+W(4,-1094345727,-1107049340,-1092155570,-1100296810)+W(5,-1101509636,-1100720075,1015117221,1034147956)+W(6,1024557366,1026345305,-1126800432,1017273727)+W(7,1027549470,-1136038899,-1134767685,-1111532367);sum2=W(0,-1083389635,-1081609637,-1079976349,-1090363224)+W(1,-1100056051,-1097029007,1028030408,-1118886369)+W(2,1062132206,1066099523,1066066300,1067427062)+W(3,1049064133,996873905,-1137063332,1035057689)+W(4,-1122840851,1053156114,-1105997303,-1091867230)+W(5,-1103783968,1048340523,-1134953960,-1104392578)+W(6,-1127222139,1022631188,1027246780,-1128121946)+W(7,1036294091,-1115106526,1035025213,-1117772337);WS(-1082692450,-1121765493);
	sum1=W(0,-1112587635,-1118487719,-1105756568,-1111631170)+W(1,1036199927,-1106833087,-1115752014,-1109370235)+W(2,992292947,-1104534315,1049230729,1048175951)+W(3,-1089217933,1028715132,-1121927694,1018481703)+W(4,1015927970,1038416886,-1104867982,1051898365)+W(5,1057590961,-1104675396,1012516667,1022215305)+W(6,-1121302066,-1121296341,1043167221,1037146590)+W(7,-1113442509,1030891673,-1121397517,-1113425325);sum2=W(0,-1102561169,1026098771,-1149524831,-1113975834)+W(1,-1157274159,-1105234356,1008573990,-1102778536)+W(2,1040868564,1021710972,1048116590,1041914200)+W(3,1051191259,1039729263,1018638481,1035375403)+W(4,-1126923948,1009959824,1037970343,1042300553)+W(5,1032086087,-1097615037,-1115639834,-1115667744)+W(6,-1123351116,-1125337962,1024724387,-1123062396)+W(7,1021621986,-1105344931,-1109718449,-1105611058);WS(1063145570,1065948321);
	sum1=W(0,-1113780043,-1107415145,-1103697695,-1125795137)+W(1,-1119226457,1032469064,-1118570362,-1148759702)+W(2,1042647928,1041877314,1043379605,-1105676766)+W(3,-1093770877,-1098882227,1029896809,1007275454)+W(4,1023153433,-1105577826,1035095074,1058030732)+W(5,1049757493,1047432094,-1106671851,-1110160160)+W(6,-1113344071,1034763992,-1113485016,-1107021830)+W(7,-1116457366,1028002580,1033670420,1021171309);sum2=W(0,1033443671,-1119163512,1032648925,1022262943)+W(1,-1121656898,-1125619769,-1116250872,983397903)+W(2,-1147652316,1034562054,1044843888,-1082830049)+W(3,1049609982,1025258841,1030706970,1030898199)+W(4,-1122182070,-1110746439,-1104224164,-1080473697)+W(5,1070472721,1045148854,-1138594966,1015661307)+W(6,-1114870166,-1126213983,1033622730,1036499220)+W(7,1042757767,-1125695843,-1109235057,-1105016797);WS(1047808392,-1105857653);
	sum1=W(0,1036414223,1038664639,1033646416,1045309491)+W(1,1028560677,1047007737,1035626955,1052689664)+W(2,1057255335,1050583338,1052085724,-1112577010)+W(3,1049269098,-1101673225,1020504170,-1098667351)+W(4,-1089047968,-1095111703,-1090242223,-1088425805)+W(5,-1097592171,1024927375,988289723,-1153489085)+W(6,1019549874,1027946812,1014185453,1038762993)+W(7,1038356881,-1120878336,1031636916,-1106190208);sum2=W(0,1050181400,-1114267734,1015251419,-1097894374)+W(1,1014394222,-1098468098,1043075035,-1092845444)+W(2,-1084160527,1035785784,-1094891239,1060354212)+W(3,1045924604,1054874631,1042828743,1063378281)+W(4,-1088778570,-1097051496,-1096397593,1063793540)+W(5,-1132415773,-1115217527,-1098450150,1051615858)+W(6,1059321043,-1113170400,1035392846,-1098458292)+W(7,1030978836,-1096505073,1042772598,-1088082125);WS(-1073783985,-1080098540);
	sum1=W(0,1012137476,-1111733448,1027546650,-1095391448)+W(1,-1107725963,1030910366,1024902311,-1136391487)+W(2,1004414705,-1125334283,-1098951217,1058781709)+W(3,1056582836,1054585131,-1118558951,1012935090)+W(4,994170013,1040796537,1045494048,1038631039)+W(5,-1099332954,-1102018612,-1106829042,-1113109295)+W(6,-1135747626,-1106294475,-1105932043,-1097893467)+W(7,1027155091,1001385357,-1141795121,-1118975220);sum2=W(0,-1136577003,-1123969951,-1126970134,1039844510)+W(1,1037108170,-1182117728,1024145219,-1107924935)+W(2,-1161174488,-1115268047,-1111829747,-1078035036)+W(3,1072008544,1038025274,1006927579,1013110307)+W(4,-1123274403,1023359390,1034323377,-1085317526)+W(5,1044555209,1032404118,1024479257,983390936)+W(6,1021768566,-1128609502,1026568479,1027511085)+W(7,986504280,-1139830523,-1127097094,1022685546);WS(-1104974728,1024380720);
	sum1=W(0,-1117848102,1021171896,1039153371,1036503965)+W(1,988770395,-1109841905,-1121562883,-1126175513)+W(2,-1117883163,-1127535108,-1099610928,-1100771573)+W(3,1043814114,1034691017,1034709362,1004793673)+W(4,1036325571,1018298053,1041104624,-1101972463)+W(5,-1133844875,-1107251369,1025626276,-1111468989)+W(6,-1131530510,1031544042,982295861,1036843369)+W(7,1029874576,1031396654,-1125713989,1034135320);sum2=W(0,-1125393898,1044163006,1045704700,-1110276988)+W(1,-1099412627,1044569612,-1115657155,1037394103)+W(2,1071281072,1072425553,-1104699996,-1078765241)+W(3,-1076152216,-1100004941,1036033265,-1111185479)+W(4,1044770418,-1125402454,1018560910,-1098423872)+W(5,-1103281302,1028856833,-1123488110,-1117821699)+W(6,1011595325,1021558362,1010524637,-1113439186)+W(7,-1178088596,1019143058,-1126446200,1026998165);WS(1066498257,1026989550);
	sum1=W(0,-1129927868,-1123659738,1045121333,1002634947)+W(1,1036944705,970850411,1022709187,1004856149)+W(2,1023571545,1024686464,-1084187390,1040895252)+W(3,1040663099,-1115004776,1024409057,1001199419)+W(4,1016605513,-1143882757,1042249043,1054068239)+W(5,-1089079196,-1120675276,-1112524513,-1120648472)+W(6,-1133253141,1025371048,1033458708,1032849928)+W(7,1049903454,1024612748,1017685954,-1117202350);sum2=W(0,1038138620,-1155040203,1049419982,-1094597030)+W(1,1022703337,-1117198782,-1132959015,-1121486321)+W(2,-1106434423,1038340354,-1087069176,1064410985)+W(3,-1110711879,-1112639315,1026273617,-1123727669)+W(4,1014840059,-1105689565,-1102609737,1043321526)+W(5,1043390477,1042536365,1036470844,1009362023)+W(6,-1117610677,1038431916,-1115449783,-1117967352)+W(7,-1107988055,-1112813855,-1122022929,1031915394);WS(1059170114,-1115069681);
	sum1=W(0,1041126528,1031327889,-1137442701,1027929903)+W(1,1016336432,1045677858,1027533272,1040648584)+W(2,1039057944,1043197758,1057495242,1035662548)+W(3,1036387882,1043295874,1020376880,1035357519)+W(4,-1114418030,1035998588,-1086197480,-1092661254)+W(5,-1098594899,-1097533773,-1116322521,-1106979748)+W(6,-1125005432,-1184440086,-1107377807,-1131407372)+W(7,1031309989,1017102598,1036182828,-1128058314);sum2=W(0,1029223181,1035999136,1032743888,1050206678)+W(1,1030968394,969652021,1018474295,-1138117380)+W(2,-1099457044,-1123134927,-1106245137,-1115721168)+W(3,1035536761,-1109098872,-1136790748,-1105152866)+W(4,-1094833228,-1107153986,1052844759,1029163621)+W(5,1046847142,-1111905268,-1116305850,-1102858563)+W(6,1022472216,-1129014496,1034397600,1043654862)+W(7,-1114537747,-1149928759,968266517,1033858063);WS(-1091215044,-1097536449);
	sum1=W(0,1036334229,1027816414,1046343318,1054850406)+W(1,1041878433,1040414769,1017820267,1047750528)+W(2,-1088688205,-1110004986,-1088611549,-1085760696)+W(3,-1113122464,-1115511970,-1113420363,1034437006)+W(4,1028067640,1025245044,-1104070412,-1089807987)+W(5,990395721,1024229024,1028468150,-1097347774)+W(6,1049627927,1039037582,1048707955,1052669472)+W(7,1043177720,1039929856,1044644789,1048578060);sum2=W(0,-1114440831,1030624098,988636086,-1132718391)+W(1,1030310950,1016098323,1024855622,1018716851)+W(2,1036847317,1042295753,1050034374,1031424194)+W(3,-1119733782,-1120554286,-1114648667,1035432255)+W(4,1041890716,-1115362087,-1113867927,1016671019)+W(5,-1130826523,-1097953797,-1146049358,-1096082463)+W(6,1027069126,1021176355,1029167466,1028661170)+W(7,-1183083952,-1108500823,1027651154,-1106095247);WS(-1074893425,-1117971628);
	sum1=W(0,-1094367290,-1152038187,-1103630563,-1098786216)+W(1,1037656965,-1114777697,1025099466,-1124130662)+W(2,1052023128,1049322869,-1111356283,999054287)+W(3,-1106664801,-1093651375,1040611874,-1094570594)+W(4,1042452051,-1097322793,1049675109,1040732760)+W(5,1040645714,1057236855,1040783587,1055134184)+W(6,-1107223211,1034136520,-1112379016,-1102728254)+W(7,1016544493,-1125564586,-1105965314,1008351835);sum2=W(0,1004001863,1021526755,1018968138,-1116175346)+W(1,-1139174407,1031843333,-1131104448,1009509771)+W(2,-1116735450,1032892007,-1096890588,-1099974349)+W(3,-1103015201,1040986630,1035109709,1041412407)+W(4,-1111481570,1024548251,-1073615974,-1071438395)+W(5,-1146527383,1076155388,1074182350,1041860718)+W(6,1033584975,-1130001464,1026017190,-1121576034)+W(7,-1164624762,1024580999,1043256283,-1106441216);WS(1040475912,1032695578);
	sum1=W(0,-1124525022,-1155851319,1035372099,-1122500130)+W(1,-1172701842,1033773669,1014757675,-1116930196)+W(2,-1112011377,-1123298122,-1091278169,1056532699)+W(3,1054708857,-1105035590,1007501482,1026134833)+W(4,1035534023,-1102944834,1055301749,1041895809)+W(5,-1087252087,1039100863,-1123874252,1036316385)+W(6,-1136466746,1035920825,-1130626274,-1104812886)+W(7,1028924087,-1111589035,-1142366545,-1110262076);sum2=W(0,-1109091355,-1119792870,-1111337413,-1102054262)+W(1,-1118550690,-1113960445,-1142500624,-1109065069)+W(2,1041703749,-1123886114,1026232126,1049335147)+W(3,-1114718085,-1111978783,-1124340572,1020384670)+W(4,-1120034208,-1123320808,1045621744,1063803841)+W(5,-1088756378,1016064880,1026268254,1030310973)+W(6,1010537508,1026411366,1015836410,-1098413574)+W(7,1041947548,-1123461018,999681904,-1122952578);WS(1060902754,1050355625);
	sum1=W(0,-1156790206,-1151083459,1011568442,1023922682)+W(1,1024500211,-1112644265,1033389138,-1104847739)+W(2,-1099711167,-1104333225,-1101534272,-1082482317)+W(3,-1107281952,1053813598,1025001795,-1116841801)+W(4,1048936605,1047935457,1041411896,-1103038759)+W(5,1049946264,1036831245,1037700978,1030797274)+W(6,975051222,-1120760458,1040804594,1043235660)+W(7,998453633,1030084558,1007099659,1035779080);sum2=W(0,1036801640,-1120633215,1043653368,1045612039)+W(1,-1100846658,976462574,-1115109418,-1097687290)+W(2,-1106066969,1029646415,-1102845552,1020964885)+W(3,1041841354,-1088569123,-1101549413,1054633350)+W(4,-1098529900,-1094622159,1045091011,1062435502)+W(5,-1104869009,1054359824,-1101036113,1044975639)+W(6,1051617655,-1128436081,-1108268977,-1120809462)+W(7,-1127923721,-1115259155,1041018201,-1102739129);WS(-1090140642,-1081743990);
	sum1=W(0,1014408182,-1130293844,1031847606,1042594418)+W(1,1041618980,1035968392,1009499077,1033368909)+W(2,1037549524,1009886528,1044394635,1037202321)+W(3,-1117833212,1037634256,-1122700465,1015596142)+W(4,-1119977588,1031805064,-1097431626,-1094879521)+W(5,-1119842097,-1101547735,-1107123493,-1105308242)+W(6,-1148996265,-1107483388,1015837167,1035016080)+W(7,1032499967,1034663662,1017023585,1030806526);sum2=W(0,-1123785792,1006912162,-1091554339,-1071648513)+W(1,-1078529007,-1106043455,-1108743589,-1113325201)+W(2,1013646496,-1120892227,1057715626,1076150687)+W(3,1069469884,1049558148,1035924910,1038760139)+W(4,-1105735433,1034054467,-1103626228,-1110563164)+W(5,1025732222,-1102425071,1028146935,1001130061)+W(6,1032589029,-1113324539,1043157583,1029343874)+W(7,-1120727508,1029688242,-1120545616,-1123660578);WS(1055430148,-1108560690);
	sum1=W(0,1035961997,1035029338,1036894711,1041930516)+W(1,1018389269,-1113968413,1026969083,-1119268932)+W(2,-1122962962,-1107101862,-1105458486,-1102453987)+W(3,1050880022,1050461237,1017425654,1049028992)+W(4,1001804274,1037435821,1049324163,-1115462345)+W(5,-1096234295,-1096034793,-1105484423,-1109268985)+W(6,-1109508687,-1114596033,-1105968336,1030068713)+W(7,1023650152,1041307521,1023939770,-1110794404);sum2=W(0,1020921672,1015626891,-1131154511,-1149322267)+W(1,1005570725,-1122484266,-1125609227,1019773418)+W(2,-1133145023,1000680715,1034643892,-1106033700)+W(3,-1155618307,1030350968,-1127714103,1027949553)+W(4,967639540,1038163303,1029820070,1027175814)+W(5,1050725869,-1107328459,984351189,-1113454879)+W(6,1057583079,1066461314,1070593780,1042500058)+W(7,-1076733999,-1075365186,-1095092572,1026351361);WS(1048611396,-1120253991);
	sum1=W(0,-1109906484,-1134442421,-1157090745,1038629782)+W(1,1019276152,1008425488,-1121251029,-1115994974)+W(2,-1104843595,1020368935,-1102655324,-1096452233)+W(3,-1094801150,-1098953977,-1125379561,-1120481658)+W(4,1042068462,-1116357012,-1127594975,1048790986)+W(5,1026936628,1044903358,1031973931,1042932491)+W(6,1029221016,1014414830,1044033359,1052393436)+W(7,1029702657,-1137141374,-1117911220,1022285443);sum2=W(0,-1129566974,-1143746400,1036033029,-1117052801)+W(1,-1123748463,1038502321,-1138810328,1043607047)+W(2,-1111784437,1036277891,1028988774,-1100779042)+W(3,1044450885,-1129810696,1034348699,-1108082071)+W(4,1050813877,1047551505,1061486774,1077969880)+W(5,1055586292,-1131992338,1040643987,-1108034712)+W(6,-1093517653,-1098527209,-1081514759,-1071648362)+W(7,-1089190754,-1107152864,-1111885211,1025200270);WS(-1095808772,1065647947);
	sum1=W(0,-1096536264,-1104862109,-1101976087,-1101730853)+W(1,-1126516760,-1106707963,-1123882077,-1108125731)+W(2,1055051378,1050045579,1051209263,1045989771)+W(3,-1096666661,-1098537885,1021791993,-1104774017)+W(4,-1152511995,-1106144343,-1114400236,1051130659)+W(5,1054814183,1057272194,1047598263,1057816237)+W(6,-1101629224,-1139560206,-1118447811,-1101507019)+W(7,-1103658466,-1098960762,-1106849375,-1104521538);sum2=W(0,-1110633145,-1114352725,-1120367533,-1113576661)+W(1,-1147392026,-1111220567,-1123261925,-1131596567)+W(2,1046325680,-1134514653,1030462840,1052343557)+W(3,1028577898,-1127265311,1023140267,-1109705515)+W(4,-1106205960,-1145236426,-1121802017,1052169724)+W(5,-1126550987,967975074,-1125641651,1019189507)+W(6,-1121981161,-1115188107,1009337269,-1122467029)+W(7,-1112707841,-1123885069,-1109514951,1036097210);WS(-1088656098,-1093593990);
	sum1=W(0,1009988669,1006243392,-1118924498,1040203342)+W(1,1030956655,1015251645,1032654584,1034196708)+W(2,1053407451,1046462824,1054487499,1043824044)+W(3,-1107509853,-1099069067,-1114843936,-1106663601)+W(4,-1093246956,-1100605512,-1092703459,-1110184012)+W(5,1041099456,1036164518,1040232112,1035276411)+W(6,1009810317,1021367180,1031892963,-1115326423)+W(7,1009525296,-1102894371,-1121673919,-1120762380);sum2=W(0,1045046842,1057379920,1066661430,1065556520)+W(1,-1100359290,-1079104557,-1080513286,-1090732450)+W(2,-1111686548,1047338924,1044625920,-1108706635)+W(3,1040575208,1048831397,-1106604517,-1118381857)+W(4,-1120613757,1041926325,1010608356,-1107659276)+W(5,1029226052,990146073,-1122878530,-1148427089)+W(6,-1123157156,-1122209414,1026048962,-1118064370)+W(7,1036917588,-1118722317,999828841,-1128484108);WS(-1103417864,1032685901);
	sum1=W(0,-1113840082,-1101895278,-1106883347,-1112947643)+W(1,1045150312,-1106874992,-1122615424,-1140285221)+W(2,999140540,1021813182,1050838637,1035808888)+W(3,-1089518824,-1112862903,-1123587264,991482976)+W(4,1026362243,1049323684,-1123649147,-1115046028)+W(5,1051398592,1043843226,1032255888,1025625239)+W(6,1025795300,-1104186210,1026463622,1015970396)+W(7,1028121997,-1114287989,-1148228092,-1125179546);sum2=W(0,1052414494,1041601968,1061231009,-1094738093)+W(1,-1090047391,-1112254382,-1124055261,-1106989530)+W(2,-1107019340,1032004449,-1083281727,1048799024)+W(3,1060484354,1026094686,1028491114,1016363351)+W(4,1021676257,-1101889010,1040520305,-1113266306)+W(5,-1097572834,1047868927,-1106439707,1039531031)+W(6,-1118630717,1028135044,994543087,1023423300)+W(7,1023744190,-1123297050,-1134044699,-1135541243);WS(1062251010,-1128406975);
	sum1=W(0,-1122559590,-1117783082,-1111223497,-1097132645)+W(1,-1118294493,1027318465,-1122628178,-1142140116)+W(2,-1114430084,998905218,-1117430765,1043264160)+W(3,-1137238321,-1109365760,1012147781,-1112437644)+W(4,1041522773,-1122146129,1049934150,1038499861)+W(5,1040349396,1038350478,-1161426505,1022231761)+W(6,-1200477464,1030594936,-1117296696,-1108127936)+W(7,-1117164622,1008104625,1016497826,1030977566);sum2=W(0,-1117898288,-1125963325,-1090182563,-1072766634)+W(1,-1084699977,1030742992,-1114032290,1021721886)+W(2,1035048481,1029071818,1058090849,1075259304)+W(3,1062748800,-1113008632,1039805619,-1113709765)+W(4,1015521050,-1131842712,-1155119281,-1099596444)+W(5,1015646848,-1124623837,-1116189732,-1146515621)+W(6,-1121110162,-1139107970,-1131029094,1037152077)+W(7,1018972128,1025197316,-1127481518,1027813594);WS(1065708113,-1121751611);
	sum1=W(0,-1151170552,-1113367966,-1132161740,-1102777150)+W(1,1008580363,1034637855,-1122909571,1029317996)+W(2,1004700116,1033929377,1028879143,1048992314)+W(3,-1130586604,-1123817297,997138991,-1119780649)+W(4,1029908854,-1124121476,1021289212,-1106962671)+W(5,-1145749780,1010684790,-1110778290,-1119558682)+W(6,-1203182552,-1152107167,985230639,-1118004497)+W(7,1024087440,1024857134,1018524741,1030859440);sum2=W(0,1022085973,1007192988,1059325611,1078660314)+W(1,1067996709,-1179370697,1033764027,1000911377)+W(2,-1128031215,982756722,-1087213694,-1070139299)+W(3,-1079390657,-1159362498,-1110724756,1028041806)+W(4,1012976820,-1124806095,1030136738,-1095156098)+W(5,-1131018297,1019962283,1025926144,-1121497459)+W(6,-1176062153,1022708360,-1120463845,1033425170)+W(7,-1138793506,-1124014927,1016277465,-1138055830);WS(1067144001,1026092834);
	sum1=W(0,1005864375,1014388109,-1110877439,-1100539124)+W(1,-1110133357,-1126225268,1033891677,1016160519)+W(2,1049810486,1020396467,1055042333,1042867979)+W(3,1031992147,1044290490,1034565181,1034066560)+W(4,-1103125415,1040462414,-1103579165,-1096204250)+W(5,1048911295,-1091768605,-1114007278,-1112003369)+W(6,-1120236446,-1132016387,-1107048544,-1116193256)+W(7,1010104860,1031444773,1030176378,1031923300);sum2=W(0,-1130823435,-1108591076,-1112679806,-1095898825)+W(1,-1107310218,1030441654,-1128226189,1031713190)+W(2,-1123834023,1045671991,-1133291790,1058163296)+W(3,-1100325346,-1113640367,1016405480,-1116067001)+W(4,1036568073,-1106172311,-1115701009,1057311204)+W(5,-1097367248,1044352434,-1106561364,1014762708)+W(6,-1114604843,1024976861,1033105292,-1122476787)+W(7,1035411458,-1111920852,1031834977,-1121017007);WS(1057420226,-1092362255);
	sum1=W(0,1032475105,1020346174,-1121587297,1019256762)+W(1,-1123769862,1033058515,1024808486,1030782351)+W(2,1044920519,-1144052776,1052978802,1055322687)+W(3,-1104246416,1040777765,1016898380,1041983019)+W(4,-1103664666,1027257637,-1096869991,-1116373310)+W(5,1028318277,-1096789598,-1118572551,-1106323631)+W(6,-1114304581,-1116794957,-1103967019,-1100439285)+W(7,1018564517,1036089864,1021198731,-1130998630);sum2=W(0,-1134184569,1006994613,1034914936,-1134366153)+W(1,1033598449,1009154259,989883430,1021229932)+W(2,1016741405,-1130764191,1033077740,-1112456708)+W(3,1043198162,-1132669129,1016038391,-1126067903)+W(4,1020516693,1043863088,1060988002,1071901111)+W(5,1043355315,1018979141,1034096544,1022348007)+W(6,-1102863001,-1103907912,-1084447988,-1076633620)+W(7,-1098165823,-1118646231,-1113048166,-1118544043);WS(-1105493768,-1082709441);
	return clamp(mstd0 + 5.0 * vsum / wsum * mstd1, 0.0, 1.0);
}

void main()
{
	FragColor = vec4(nnedi3(0), nnedi3(1), nnedi3(2), 1.0);
} 
#endif
