/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.swing.graphics;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.util.Arrays;
import org.freehep.swing.graphics.AbstractRegionSelectionPanel;
import org.freehep.swing.images.FreeHepImage;

public class SquareSelectionPanel
extends AbstractRegionSelectionPanel {
    public int getNumberOfControlPoints() {
        return 5;
    }

    public Cursor getControlPointCursor(int index) {
        switch (index) {
            case -1: {
                return FreeHepImage.getCursor("SquareCursor");
            }
            case 4: {
                return FreeHepImage.getCursor("0_MoveCursor", 16, 16);
            }
        }
        return SquareSelectionPanel.compassCursor("Resize", this.xCtrlPts[index] - this.xCtrlPts[4], this.yCtrlPts[index] - this.yCtrlPts[4], 4, true);
    }

    public void initializeControlPoints(int x, int y) {
        this.activeCtrlPt = 0;
        Arrays.fill(this.xCtrlPts, x);
        Arrays.fill(this.yCtrlPts, y);
    }

    public void updateActiveControlPoint(int x, int y) {
        x = this.forceXCoordinateWithinBounds(x);
        y = this.forceYCoordinateWithinBounds(y);
        if (this.activeCtrlPt == 4) {
            int dx = x - this.xCtrlPts[4];
            int dy = y - this.yCtrlPts[4];
            int i = 0;
            while (i < this.nCtrlPts) {
                int n = i;
                this.xCtrlPts[n] = this.xCtrlPts[n] + dx;
                int n2 = i++;
                this.yCtrlPts[n2] = this.yCtrlPts[n2] + dy;
            }
        } else {
            int dx = x - this.xCtrlPts[4];
            int dy = y - this.yCtrlPts[4];
            int signx = dx < 0 ? -1 : 1;
            int signy = dy < 0 ? -1 : 1;
            dx = Math.abs(dx);
            dy = Math.abs(dy);
            double ratio = (double)this.getHeight() / (double)this.getWidth();
            int xside = (int)(((double)dx + ratio * (double)dy) / (1.0 + ratio * ratio));
            int yside = xside * this.getHeight() / this.getWidth();
            this.xCtrlPts[this.activeCtrlPt] = this.xCtrlPts[4] + signx * xside;
            this.yCtrlPts[this.activeCtrlPt] = this.yCtrlPts[4] + signy * yside;
            this.xCtrlPts[(this.activeCtrlPt + 1) % 4] = this.xCtrlPts[4] - signx * xside;
            this.yCtrlPts[(this.activeCtrlPt + 1) % 4] = this.yCtrlPts[4] + signy * yside;
            this.xCtrlPts[(this.activeCtrlPt + 2) % 4] = this.xCtrlPts[4] - signx * xside;
            this.yCtrlPts[(this.activeCtrlPt + 2) % 4] = this.yCtrlPts[4] - signy * yside;
            this.xCtrlPts[(this.activeCtrlPt + 3) % 4] = this.xCtrlPts[4] + signx * xside;
            this.yCtrlPts[(this.activeCtrlPt + 3) % 4] = this.yCtrlPts[4] - signy * yside;
        }
        this.repaintPanel();
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.visible) {
            Graphics2D g2d = (Graphics2D)g;
            int side = Math.abs(this.xCtrlPts[0] - this.xCtrlPts[4]);
            g2d.setStroke(thickStroke);
            g.setColor(Color.black);
            g.drawPolygon(this.xCtrlPts, this.yCtrlPts, 4);
            if (this.visibleGuides) {
                g.drawLine(this.xCtrlPts[0], this.yCtrlPts[0], this.xCtrlPts[2], this.yCtrlPts[2]);
                g.drawLine(this.xCtrlPts[1], this.yCtrlPts[1], this.xCtrlPts[3], this.yCtrlPts[3]);
            }
            g2d.setStroke(thinStroke);
            g.setColor(Color.white);
            g.drawPolygon(this.xCtrlPts, this.yCtrlPts, 4);
            if (this.visibleGuides) {
                g.drawLine(this.xCtrlPts[0], this.yCtrlPts[0], this.xCtrlPts[2], this.yCtrlPts[2]);
                g.drawLine(this.xCtrlPts[1], this.yCtrlPts[1], this.xCtrlPts[3], this.yCtrlPts[3]);
            }
            if (this.activeCtrlPt >= 0) {
                g.setColor(Color.black);
                g.fillRect(this.xCtrlPts[this.activeCtrlPt] - ctrlPtSize - 1, this.yCtrlPts[this.activeCtrlPt] - ctrlPtSize - 1, 2 * ctrlPtSize + 3, 2 * ctrlPtSize + 3);
                g.setColor(Color.white);
                g.fillRect(this.xCtrlPts[this.activeCtrlPt] - ctrlPtSize, this.yCtrlPts[this.activeCtrlPt] - ctrlPtSize, 2 * ctrlPtSize + 1, 2 * ctrlPtSize + 1);
            }
        }
    }

    public AffineTransform makeAffineTransform() {
        double dx = Math.abs(this.xCtrlPts[0] - this.xCtrlPts[4]);
        double dy = dx * (double)this.getHeight() / (double)this.getWidth();
        double x0 = (double)this.xCtrlPts[4] - dx;
        double y0 = (double)this.yCtrlPts[4] - dy;
        double x1 = (double)this.xCtrlPts[4] + dx;
        double y1 = (double)this.yCtrlPts[4] - dy;
        double x2 = (double)this.xCtrlPts[4] + dx;
        double y2 = (double)this.yCtrlPts[4] + dy;
        return this.makeTransform(x0, y0, x1, y1, x2, y2);
    }

    public boolean isValidSelection() {
        return this.visible && (this.xCtrlPts[0] != this.xCtrlPts[2] || this.yCtrlPts[0] != this.yCtrlPts[2]);
    }
}

