/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kms.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.internal.SdkInternalMap;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.kms.model.GenerateDataKeyWithoutPlaintextRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.util.Map;

public class GenerateDataKeyWithoutPlaintextRequestMarshaller
implements Marshaller<Request<GenerateDataKeyWithoutPlaintextRequest>, GenerateDataKeyWithoutPlaintextRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public GenerateDataKeyWithoutPlaintextRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<GenerateDataKeyWithoutPlaintextRequest> marshall(GenerateDataKeyWithoutPlaintextRequest generateDataKeyWithoutPlaintextRequest) {
        if (generateDataKeyWithoutPlaintextRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GenerateDataKeyWithoutPlaintextRequest> request = new DefaultRequest<GenerateDataKeyWithoutPlaintextRequest>(generateDataKeyWithoutPlaintextRequest, "AWSKMS");
        request.addHeader("X-Amz-Target", "TrentService.GenerateDataKeyWithoutPlaintext");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList grantTokensList;
            SdkInternalMap encryptionContextMap;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (generateDataKeyWithoutPlaintextRequest.getKeyId() != null) {
                jsonGenerator.writeFieldName("KeyId").writeValue(generateDataKeyWithoutPlaintextRequest.getKeyId());
            }
            if (!(encryptionContextMap = (SdkInternalMap)generateDataKeyWithoutPlaintextRequest.getEncryptionContext()).isEmpty() || !encryptionContextMap.isAutoConstruct()) {
                jsonGenerator.writeFieldName("EncryptionContext");
                jsonGenerator.writeStartObject();
                for (Map.Entry encryptionContextMapValue : encryptionContextMap.entrySet()) {
                    if (encryptionContextMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName((String)encryptionContextMapValue.getKey());
                    jsonGenerator.writeValue((String)encryptionContextMapValue.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            if (generateDataKeyWithoutPlaintextRequest.getKeySpec() != null) {
                jsonGenerator.writeFieldName("KeySpec").writeValue(generateDataKeyWithoutPlaintextRequest.getKeySpec());
            }
            if (generateDataKeyWithoutPlaintextRequest.getNumberOfBytes() != null) {
                jsonGenerator.writeFieldName("NumberOfBytes").writeValue(generateDataKeyWithoutPlaintextRequest.getNumberOfBytes());
            }
            if (!(grantTokensList = (SdkInternalList)generateDataKeyWithoutPlaintextRequest.getGrantTokens()).isEmpty() || !grantTokensList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("GrantTokens");
                jsonGenerator.writeStartArray();
                for (String grantTokensListValue : grantTokensList) {
                    if (grantTokensListValue == null) continue;
                    jsonGenerator.writeValue(grantTokensListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

