/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.util;

import com.amazonaws.internal.Releasable;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public enum IOUtils {

    private static final int BUFFER_SIZE = 4096;
    private static final Log defaultLog = LogFactory.getLog(IOUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toByteArray(InputStream is2) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            byte[] b = new byte[4096];
            int n = 0;
            while ((n = is2.read(b)) != -1) {
                output.write(b, 0, n);
            }
            byte[] byArray = output.toByteArray();
            return byArray;
        }
        finally {
            output.close();
        }
    }

    public static String toString(InputStream is2) throws IOException {
        return new String(IOUtils.toByteArray(is2), StringUtils.UTF8);
    }

    public static void closeQuietly(Closeable is2, Log log) {
        block3: {
            if (is2 != null) {
                try {
                    is2.close();
                }
                catch (IOException ex) {
                    Log logger;
                    Log log2 = logger = log == null ? defaultLog : log;
                    if (!logger.isDebugEnabled()) break block3;
                    logger.debug("Ignore failure in closing the Closeable", ex);
                }
            }
        }
    }

    public static void release(Closeable is2, Log log) {
        IOUtils.closeQuietly(is2, log);
        if (is2 instanceof Releasable) {
            Releasable r = (Releasable)((Object)is2);
            r.release();
        }
    }

    public static long copy(InputStream in, OutputStream out) throws IOException {
        byte[] buf = new byte[4096];
        long count2 = 0L;
        int n = 0;
        while ((n = in.read(buf)) > -1) {
            out.write(buf, 0, n);
            count2 += (long)n;
        }
        return count2;
    }
}

