/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.bulk;

import java.io.IOException;
import java.util.ArrayList;
import org.elasticsearch.action.bulk.BulkItemRequest;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.support.replication.ReplicatedWriteRequest;
import org.elasticsearch.action.support.replication.ReplicationRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.shard.ShardId;

public class BulkShardRequest
extends ReplicatedWriteRequest<BulkShardRequest> {
    private BulkItemRequest[] items;

    public BulkShardRequest() {
    }

    public BulkShardRequest(ShardId shardId, WriteRequest.RefreshPolicy refreshPolicy, BulkItemRequest[] items) {
        super(shardId);
        this.items = items;
        this.setRefreshPolicy(refreshPolicy);
    }

    public BulkItemRequest[] items() {
        return this.items;
    }

    @Override
    public String[] indices() {
        ArrayList<String> indices = new ArrayList<String>();
        for (BulkItemRequest item : this.items) {
            if (item == null) continue;
            indices.add(item.index());
        }
        return indices.toArray(new String[indices.size()]);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.items.length);
        for (BulkItemRequest item : this.items) {
            if (item != null) {
                out.writeBoolean(true);
                item.writeTo(out);
                continue;
            }
            out.writeBoolean(false);
        }
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.items = new BulkItemRequest[in.readVInt()];
        for (int i = 0; i < this.items.length; ++i) {
            if (!in.readBoolean()) continue;
            this.items[i] = BulkItemRequest.readBulkItem(in);
        }
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder("BulkShardRequest [");
        b.append(this.shardId).append("] containing [");
        if (this.items.length > 1) {
            b.append(this.items.length).append("] requests");
        } else {
            b.append(this.items[0].request()).append("]");
        }
        switch (this.getRefreshPolicy()) {
            case IMMEDIATE: {
                b.append(" and a refresh");
                break;
            }
            case WAIT_UNTIL: {
                b.append(" blocking until refresh");
                break;
            }
        }
        return b.toString();
    }

    @Override
    public String getDescription() {
        return "requests[" + this.items.length + "], index[" + this.index + "]";
    }

    @Override
    public void onRetry() {
        for (BulkItemRequest item : this.items) {
            if (!(item.request() instanceof ReplicationRequest)) continue;
            ((ReplicationRequest)((Object)item.request())).onRetry();
        }
    }
}

