/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.geo.builders;

import com.vividsolutions.jts.geom.Coordinate;
import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.geo.builders.ShapeBuilder;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.locationtech.spatial4j.shape.Rectangle;

public class EnvelopeBuilder
extends ShapeBuilder {
    public static final ShapeBuilder.GeoShapeType TYPE = ShapeBuilder.GeoShapeType.ENVELOPE;
    private final Coordinate topLeft;
    private final Coordinate bottomRight;

    public EnvelopeBuilder(Coordinate topLeft, Coordinate bottomRight) {
        Objects.requireNonNull(topLeft, "topLeft of envelope cannot be null");
        Objects.requireNonNull(bottomRight, "bottomRight of envelope cannot be null");
        this.topLeft = topLeft;
        this.bottomRight = bottomRight;
    }

    public EnvelopeBuilder(StreamInput in) throws IOException {
        this.topLeft = EnvelopeBuilder.readFromStream(in);
        this.bottomRight = EnvelopeBuilder.readFromStream(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        EnvelopeBuilder.writeCoordinateTo(this.topLeft, out);
        EnvelopeBuilder.writeCoordinateTo(this.bottomRight, out);
    }

    public Coordinate topLeft() {
        return this.topLeft;
    }

    public Coordinate bottomRight() {
        return this.bottomRight;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("type", TYPE.shapeName());
        builder.startArray("coordinates");
        EnvelopeBuilder.toXContent(builder, this.topLeft);
        EnvelopeBuilder.toXContent(builder, this.bottomRight);
        builder.endArray();
        return builder.endObject();
    }

    public Rectangle build() {
        return SPATIAL_CONTEXT.makeRectangle(this.topLeft.x, this.bottomRight.x, this.bottomRight.y, this.topLeft.y);
    }

    @Override
    public ShapeBuilder.GeoShapeType type() {
        return TYPE;
    }

    public int hashCode() {
        return Objects.hash(this.topLeft, this.bottomRight);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        EnvelopeBuilder other = (EnvelopeBuilder)obj;
        return Objects.equals(this.topLeft, other.topLeft) && Objects.equals(this.bottomRight, other.bottomRight);
    }
}

