/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.similarity;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.search.similarities.PerFieldSimilarityWrapper;
import org.apache.lucene.search.similarities.Similarity;
import org.elasticsearch.Version;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.similarity.BM25SimilarityProvider;
import org.elasticsearch.index.similarity.BooleanSimilarityProvider;
import org.elasticsearch.index.similarity.ClassicSimilarityProvider;
import org.elasticsearch.index.similarity.DFISimilarityProvider;
import org.elasticsearch.index.similarity.DFRSimilarityProvider;
import org.elasticsearch.index.similarity.IBSimilarityProvider;
import org.elasticsearch.index.similarity.LMDirichletSimilarityProvider;
import org.elasticsearch.index.similarity.LMJelinekMercerSimilarityProvider;
import org.elasticsearch.index.similarity.ScriptedSimilarityProvider;
import org.elasticsearch.index.similarity.SimilarityProvider;
import org.elasticsearch.script.ScriptService;

public final class SimilarityService
extends AbstractIndexComponent {
    private static final DeprecationLogger DEPRECATION_LOGGER = new DeprecationLogger(Loggers.getLogger(SimilarityService.class));
    public static final String DEFAULT_SIMILARITY = "BM25";
    private final Similarity defaultSimilarity;
    private final Map<String, SimilarityProvider> similarities;
    private static final Map<String, SimilarityProvider.Factory> DEFAULTS;
    public static final Map<String, SimilarityProvider.Factory> BUILT_IN;

    public SimilarityService(IndexSettings indexSettings, ScriptService scriptService, Map<String, SimilarityProvider.Factory> similarities) {
        super(indexSettings);
        HashMap<String, SimilarityProvider> providers = new HashMap<String, SimilarityProvider>(similarities.size());
        Map<String, Settings> similaritySettings = this.indexSettings.getSettings().getGroups("index.similarity");
        for (Map.Entry<String, Settings> entry : similaritySettings.entrySet()) {
            String name = entry.getKey();
            if (BUILT_IN.containsKey(name) && indexSettings.getIndexVersionCreated().onOrAfter(Version.V_5_0_0_alpha1)) {
                throw new IllegalArgumentException("Cannot redefine built-in Similarity [" + name + "]");
            }
            Settings providerSettings = entry.getValue();
            String typeName = providerSettings.get("type");
            if (typeName == null) {
                throw new IllegalArgumentException("Similarity [" + name + "] must have an associated type");
            }
            if (!(similarities.containsKey(typeName) || BUILT_IN.containsKey(typeName))) {
                throw new IllegalArgumentException("Unknown Similarity type [" + typeName + "] for [" + name + "]");
            }
            SimilarityProvider.Factory defaultFactory = BUILT_IN.get(typeName);
            SimilarityProvider.Factory factory = similarities.getOrDefault(typeName, defaultFactory);
            providers.put(name, factory.create(name, providerSettings, indexSettings.getSettings(), scriptService));
        }
        Map<String, SimilarityProvider> providerMapping = this.addSimilarities(similaritySettings, indexSettings.getSettings(), scriptService, DEFAULTS);
        for (Map.Entry<String, SimilarityProvider> entry : providerMapping.entrySet()) {
            if (providers.containsKey(entry.getKey()) && indexSettings.getIndexVersionCreated().before(Version.V_5_0_0_alpha1)) continue;
            providers.put(entry.getKey(), entry.getValue());
        }
        this.similarities = providers;
        Similarity similarity = this.defaultSimilarity = providers.get("default") != null ? ((SimilarityProvider)providers.get("default")).get() : ((SimilarityProvider)providers.get(DEFAULT_SIMILARITY)).get();
        if (providers.get("base") != null) {
            DEPRECATION_LOGGER.deprecated("The [base] similarity is ignored since query normalization and coords have been removed", new Object[0]);
        }
    }

    public Similarity similarity(MapperService mapperService) {
        return mapperService != null ? new PerFieldSimilarity(this.defaultSimilarity, mapperService) : this.defaultSimilarity;
    }

    private Map<String, SimilarityProvider> addSimilarities(Map<String, Settings> similaritySettings, Settings indexSettings, ScriptService scriptService, Map<String, SimilarityProvider.Factory> similarities) {
        HashMap<String, SimilarityProvider> providers = new HashMap<String, SimilarityProvider>(similarities.size());
        for (Map.Entry<String, SimilarityProvider.Factory> entry : similarities.entrySet()) {
            String name = entry.getKey();
            SimilarityProvider.Factory factory = entry.getValue();
            Settings providerSettings = similaritySettings.get(name);
            if (providerSettings == null) {
                providerSettings = Settings.Builder.EMPTY_SETTINGS;
            }
            providers.put(name, factory.create(name, providerSettings, indexSettings, scriptService));
        }
        return providers;
    }

    public SimilarityProvider getSimilarity(String name) {
        return this.similarities.get(name);
    }

    Similarity getDefaultSimilarity() {
        return this.defaultSimilarity;
    }

    static {
        HashMap<String, SimilarityProvider.Factory> defaults = new HashMap<String, SimilarityProvider.Factory>();
        defaults.put("classic", (name, settings, indexSettings, scriptService) -> new ClassicSimilarityProvider(name, settings, indexSettings));
        defaults.put(DEFAULT_SIMILARITY, (name, settings, indexSettings, scriptService) -> new BM25SimilarityProvider(name, settings, indexSettings));
        defaults.put("boolean", (name, settings, indexSettings, scriptService) -> new BooleanSimilarityProvider(name, settings, indexSettings));
        HashMap<String, SimilarityProvider.Factory> builtIn = new HashMap<String, SimilarityProvider.Factory>(defaults);
        builtIn.put("DFR", (name, settings, indexSettings, scriptService) -> new DFRSimilarityProvider(name, settings, indexSettings));
        builtIn.put("IB", (name, settings, indexSettings, scriptService) -> new IBSimilarityProvider(name, settings, indexSettings));
        builtIn.put("LMDirichlet", (name, settings, indexSettings, scriptService) -> new LMDirichletSimilarityProvider(name, settings, indexSettings));
        builtIn.put("LMJelinekMercer", (name, settings, indexSettings, scriptService) -> new LMJelinekMercerSimilarityProvider(name, settings, indexSettings));
        builtIn.put("DFI", (name, settings, indexSettings, scriptService) -> new DFISimilarityProvider(name, settings, indexSettings));
        builtIn.put("scripted", ScriptedSimilarityProvider::new);
        DEFAULTS = Collections.unmodifiableMap(defaults);
        BUILT_IN = Collections.unmodifiableMap(builtIn);
    }

    static class PerFieldSimilarity
    extends PerFieldSimilarityWrapper {
        private final Similarity defaultSimilarity;
        private final MapperService mapperService;

        PerFieldSimilarity(Similarity defaultSimilarity, MapperService mapperService) {
            this.defaultSimilarity = defaultSimilarity;
            this.mapperService = mapperService;
        }

        public Similarity get(String name) {
            MappedFieldType fieldType = this.mapperService.fullName(name);
            return fieldType != null && fieldType.similarity() != null ? fieldType.similarity().get() : this.defaultSimilarity;
        }
    }
}

