/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.matrix.stats;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.matrix.stats.MatrixStats;
import org.elasticsearch.search.aggregations.matrix.stats.MatrixStatsResults;
import org.elasticsearch.search.aggregations.matrix.stats.RunningStats;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;

public class InternalMatrixStats
extends InternalAggregation
implements MatrixStats {
    private final RunningStats stats;
    private final MatrixStatsResults results;

    InternalMatrixStats(String name, long count, RunningStats multiFieldStatsResults, MatrixStatsResults results, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) {
        super(name, pipelineAggregators, metaData);
        assert (count >= 0L);
        this.stats = multiFieldStatsResults;
        this.results = results;
    }

    public InternalMatrixStats(StreamInput in) throws IOException {
        super(in);
        this.stats = (RunningStats)in.readOptionalWriteable(RunningStats::new);
        this.results = (MatrixStatsResults)in.readOptionalWriteable(MatrixStatsResults::new);
    }

    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeOptionalWriteable((Writeable)this.stats);
        out.writeOptionalWriteable((Writeable)this.results);
    }

    public String getWriteableName() {
        return "matrix_stats";
    }

    @Override
    public long getDocCount() {
        if (this.stats == null) {
            return 0L;
        }
        return this.stats.docCount;
    }

    @Override
    public long getFieldCount(String field) {
        if (this.results == null) {
            return 0L;
        }
        return this.results.getFieldCount(field);
    }

    @Override
    public double getMean(String field) {
        if (this.results == null) {
            return Double.NaN;
        }
        return this.results.getMean(field);
    }

    @Override
    public double getVariance(String field) {
        if (this.results == null) {
            return Double.NaN;
        }
        return this.results.getVariance(field);
    }

    @Override
    public double getSkewness(String field) {
        if (this.results == null) {
            return Double.NaN;
        }
        return this.results.getSkewness(field);
    }

    @Override
    public double getKurtosis(String field) {
        if (this.results == null) {
            return Double.NaN;
        }
        return this.results.getKurtosis(field);
    }

    @Override
    public double getCovariance(String fieldX, String fieldY) {
        if (this.results == null) {
            return Double.NaN;
        }
        return this.results.getCovariance(fieldX, fieldY);
    }

    @Override
    public double getCorrelation(String fieldX, String fieldY) {
        if (this.results == null) {
            return Double.NaN;
        }
        return this.results.getCorrelation(fieldX, fieldY);
    }

    RunningStats getStats() {
        return this.stats;
    }

    MatrixStatsResults getResults() {
        return this.results;
    }

    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(Aggregation.CommonFields.DOC_COUNT.getPreferredName(), this.getDocCount());
        if (this.results != null && !this.results.getFieldCounts().keySet().isEmpty()) {
            builder.startArray("fields");
            for (String fieldName : this.results.getFieldCounts().keySet()) {
                builder.startObject();
                builder.field("name", fieldName);
                builder.field("count", this.results.getFieldCount(fieldName));
                builder.field("mean", this.results.getMean(fieldName));
                builder.field("variance", this.results.getVariance(fieldName));
                builder.field("skewness", this.results.getSkewness(fieldName));
                builder.field("kurtosis", this.results.getKurtosis(fieldName));
                builder.startObject("covariance");
                for (String fieldB : this.results.getFieldCounts().keySet()) {
                    builder.field(fieldB, this.results.getCovariance(fieldName, fieldB));
                }
                builder.endObject();
                builder.startObject("correlation");
                for (String fieldB : this.results.getFieldCounts().keySet()) {
                    builder.field(fieldB, this.results.getCorrelation(fieldName, fieldB));
                }
                builder.endObject();
                builder.endObject();
            }
            builder.endArray();
        }
        return builder;
    }

    public Object getProperty(List<String> path) {
        if (path.isEmpty()) {
            return this;
        }
        if (path.size() == 1) {
            String element = path.get(0);
            if (this.results == null) {
                return Collections.emptyMap();
            }
            switch (element) {
                case "counts": {
                    return this.results.getFieldCounts();
                }
                case "means": {
                    return this.results.getMeans();
                }
                case "variances": {
                    return this.results.getVariances();
                }
                case "skewness": {
                    return this.results.getSkewness();
                }
                case "kurtosis": {
                    return this.results.getKurtosis();
                }
                case "covariance": {
                    return this.results.getCovariances();
                }
                case "correlation": {
                    return this.results.getCorrelations();
                }
            }
            throw new IllegalArgumentException("Found unknown path element [" + element + "] in [" + this.getName() + "]");
        }
        throw new IllegalArgumentException("path not supported for [" + this.getName() + "]: " + path);
    }

    public InternalAggregation doReduce(List<InternalAggregation> aggregations, InternalAggregation.ReduceContext reduceContext) {
        ArrayList<InternalAggregation> aggs = new ArrayList<InternalAggregation>(aggregations);
        aggs.removeIf(p -> ((InternalMatrixStats)p).stats == null);
        if (aggs.isEmpty()) {
            return new InternalMatrixStats(this.name, 0L, null, new MatrixStatsResults(), this.pipelineAggregators(), this.getMetaData());
        }
        RunningStats runningStats = new RunningStats();
        for (int i = 0; i < aggs.size(); ++i) {
            runningStats.merge(((InternalMatrixStats)aggs.get((int)i)).stats);
        }
        MatrixStatsResults results = new MatrixStatsResults(runningStats);
        return new InternalMatrixStats(this.name, results.getDocCount(), runningStats, results, this.pipelineAggregators(), this.getMetaData());
    }

    protected int doHashCode() {
        return Objects.hash(this.stats, this.results);
    }

    protected boolean doEquals(Object obj) {
        InternalMatrixStats other = (InternalMatrixStats)obj;
        return Objects.equals(this.stats, other.stats) && Objects.equals(this.results, other.results);
    }

    static class Fields {
        public static final String FIELDS = "fields";
        public static final String NAME = "name";
        public static final String COUNT = "count";
        public static final String MEAN = "mean";
        public static final String VARIANCE = "variance";
        public static final String SKEWNESS = "skewness";
        public static final String KURTOSIS = "kurtosis";
        public static final String COVARIANCE = "covariance";
        public static final String CORRELATION = "correlation";

        Fields() {
        }
    }
}

