/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.calendar;

import java.util.Calendar;
import java.util.Date;

public class CalendarUtils {
    public static final int ONE_MINUTE = 60000;
    public static final int ONE_HOUR = 3600000;
    public static final int THREE_HOURS = 10800000;
    public static final int ONE_DAY = 86400000;

    public static Date getEndOfDST(Calendar calendar) {
        if (!calendar.getTimeZone().useDaylightTime()) {
            return null;
        }
        long old = calendar.getTimeInMillis();
        calendar.set(2, 11);
        CalendarUtils.endOfMonth(calendar);
        CalendarUtils.startOfDay(calendar);
        for (int i = 0; i < 366; ++i) {
            calendar.add(5, -1);
            if (!calendar.getTimeZone().inDaylightTime(calendar.getTime())) continue;
            CalendarUtils.endOfDay(calendar);
            return calendar.getTime();
        }
        calendar.setTimeInMillis(old);
        return null;
    }

    public static Date getStartOfDST(Calendar calendar) {
        if (!calendar.getTimeZone().useDaylightTime()) {
            return null;
        }
        long old = calendar.getTimeInMillis();
        calendar.set(2, 0);
        CalendarUtils.startOfMonth(calendar);
        CalendarUtils.endOfDay(calendar);
        for (int i = 0; i < 366; ++i) {
            calendar.add(5, 1);
            if (!calendar.getTimeZone().inDaylightTime(calendar.getTime())) continue;
            CalendarUtils.endOfDay(calendar);
            return calendar.getTime();
        }
        calendar.setTimeInMillis(old);
        return null;
    }

    public static boolean isStartOfDay(Calendar calendar) {
        Calendar temp = (Calendar)calendar.clone();
        temp.add(14, -1);
        return temp.get(5) != calendar.get(5);
    }

    public static boolean isEndOfDay(Calendar calendar) {
        Calendar temp = (Calendar)calendar.clone();
        temp.add(14, 1);
        return temp.get(5) != calendar.get(5);
    }

    public static boolean isStartOfMonth(Calendar calendar) {
        Calendar temp = (Calendar)calendar.clone();
        temp.add(14, -1);
        return temp.get(2) != calendar.get(2);
    }

    public static boolean isEndOfMonth(Calendar calendar) {
        Calendar temp = (Calendar)calendar.clone();
        temp.add(14, 1);
        return temp.get(2) != calendar.get(2);
    }

    public static boolean isStartOfWeek(Calendar calendar) {
        Calendar temp = (Calendar)calendar.clone();
        temp.add(14, -1);
        return temp.get(3) != calendar.get(3);
    }

    public static boolean isEndOfWeek(Calendar calendar) {
        Calendar temp = (Calendar)calendar.clone();
        temp.add(14, 1);
        return temp.get(3) != calendar.get(3);
    }

    public static void startOfWeek(Calendar calendar) {
        calendar.set(7, calendar.getFirstDayOfWeek());
        CalendarUtils.startOfDay(calendar);
    }

    public static void endOfWeek(Calendar calendar) {
        CalendarUtils.startOfWeek(calendar);
        calendar.add(5, 7);
        calendar.add(14, -1);
    }

    public static Date endOfWeek(Calendar calendar, Date date) {
        calendar.setTime(date);
        CalendarUtils.endOfWeek(calendar);
        return calendar.getTime();
    }

    public static Date startOfWeek(Calendar calendar, Date date) {
        calendar.setTime(date);
        CalendarUtils.startOfWeek(calendar);
        return calendar.getTime();
    }

    public static void startOfMonth(Calendar calendar) {
        calendar.set(5, 1);
        CalendarUtils.startOfDay(calendar);
    }

    public static void endOfMonth(Calendar calendar) {
        calendar.add(2, 1);
        CalendarUtils.startOfMonth(calendar);
        calendar.add(14, -1);
    }

    public static Date startOfDay(Calendar calendar, Date date) {
        calendar.setTime(date);
        CalendarUtils.startOfDay(calendar);
        return calendar.getTime();
    }

    public static Date endOfDay(Calendar calendar, Date date) {
        calendar.setTime(date);
        CalendarUtils.endOfDay(calendar);
        return calendar.getTime();
    }

    public static void startOfDay(Calendar calendar) {
        calendar.set(11, 0);
        calendar.set(14, 0);
        calendar.set(13, 0);
        calendar.set(12, 0);
    }

    public static void endOfDay(Calendar calendar) {
        calendar.add(5, 1);
        CalendarUtils.startOfDay(calendar);
        calendar.add(14, -1);
    }

    public static boolean areEqual(Date current, Date date) {
        if (date == null && current == null) {
            return true;
        }
        if (date != null) {
            return date.equals(current);
        }
        return false;
    }

    public static boolean isSameDay(Calendar today, Date now) {
        Calendar temp = (Calendar)today.clone();
        CalendarUtils.startOfDay(temp);
        Date start = temp.getTime();
        temp.setTime(now);
        CalendarUtils.startOfDay(temp);
        return start.equals(temp.getTime());
    }
}

