/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;
import java.util.Random;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Direction;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoodsContainer;
import net.sf.freecol.common.model.HighSeas;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Locatable;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Region;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.pathfinding.CostDecider;
import net.sf.freecol.common.model.pathfinding.CostDeciders;
import net.sf.freecol.common.model.pathfinding.GoalDecider;
import net.sf.freecol.common.model.pathfinding.GoalDeciders;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.LogBuilder;
import net.sf.freecol.common.util.RandomUtils;
import net.sf.freecol.server.generator.TerrainGenerator;

public class Map
extends FreeColGameObject
implements Location {
    private static final Logger logger = Logger.getLogger(Map.class.getName());
    public static final int POLAR_HEIGHT = 2;
    private Tile[][] tiles;
    private Layer layer;
    private int minimumLatitude = -90;
    private int maximumLatitude = 90;
    private float latitudePerRow;
    private final List<Region> regions = new ArrayList<Region>();
    private boolean traceSearch = false;
    private static final String HEIGHT_TAG = "height";
    private static final String LAYER_TAG = "layer";
    private static final String MAXIMUM_LATITUDE_TAG = "maximumLatitude";
    private static final String MINIMUM_LATITUDE_TAG = "minimumLatitude";
    private static final String WIDTH_TAG = "width";
    private final List<Tile> missingRegions = new ArrayList<Tile>();
    private boolean fixupHighSeas = false;

    public Map(Game game, int width, int height) {
        super(game);
        this.tiles = new Tile[width][height];
        this.setLayer(Layer.RESOURCES);
        this.calculateLatitudePerRow();
    }

    public Map(Game game, FreeColXMLReader xr) throws XMLStreamException {
        super(game, null);
        this.readFromXML(xr);
    }

    public Map(Game game, String id) {
        super(game, id);
    }

    public static boolean isValid(int x, int y, int width, int height) {
        return x >= 0 && x < width && y >= 0 && y < height;
    }

    public boolean isValid(int x, int y) {
        return Map.isValid(x, y, this.getWidth(), this.getHeight());
    }

    public boolean isValid(Position position) {
        return this.isValid(position.getX(), position.getY());
    }

    public Tile getTile(int x, int y) {
        return this.isValid(x, y) ? this.tiles[x][y] : null;
    }

    public Tile getTile(Position p) {
        return this.getTile(p.getX(), p.getY());
    }

    public void setTile(Tile tile, int x, int y) {
        this.tiles[x][y] = tile;
    }

    public int getWidth() {
        return this.tiles.length;
    }

    public int getHeight() {
        return this.tiles[0].length;
    }

    public final Layer getLayer() {
        return this.layer;
    }

    public final void setLayer(Layer newLayer) {
        this.layer = newLayer;
    }

    public final int getMinimumLatitude() {
        return this.minimumLatitude;
    }

    public final void setMinimumLatitude(int newMinimumLatitude) {
        this.minimumLatitude = newMinimumLatitude;
        this.calculateLatitudePerRow();
    }

    public final int getMaximumLatitude() {
        return this.maximumLatitude;
    }

    public final void setMaximumLatitude(int newMaximumLatitude) {
        this.maximumLatitude = newMaximumLatitude;
        this.calculateLatitudePerRow();
    }

    public final float getLatitudePerRow() {
        return this.latitudePerRow;
    }

    private final void calculateLatitudePerRow() {
        this.latitudePerRow = 1.0f * (float)(this.maximumLatitude - this.minimumLatitude) / (float)(this.getHeight() - 1);
    }

    public int getLatitude(int row) {
        return this.minimumLatitude + (int)((float)row * this.latitudePerRow);
    }

    public int getRow(int latitude) {
        return (int)((float)(latitude - this.minimumLatitude) / this.latitudePerRow);
    }

    public Collection<Region> getRegions() {
        return this.regions;
    }

    public java.util.Map<String, Region> getFixedRegions() {
        HashMap<String, Region> result = new HashMap<String, Region>();
        for (Region r : this.getRegions()) {
            String n = r.getNameKey();
            if (r == null) continue;
            result.put(n, r);
        }
        return result;
    }

    public Region getRegionByKey(String key) {
        return key == null ? null : CollectionUtils.find(this.getRegions(), r -> key.equals(r.getKey()));
    }

    public Region getRegionByName(String name) {
        return name == null ? null : CollectionUtils.find(this.getRegions(), r -> name.equals(r.getName()));
    }

    public void addRegion(Region region) {
        this.regions.add(region);
    }

    public static final boolean isSameLocation(Location l1, Location l2) {
        return l1 == null || l2 == null ? false : (l1 == l2 ? true : (l1.getTile() == null ? false : l1.getTile() == l2.getTile()));
    }

    public static final boolean isSameContiguity(Location l1, Location l2) {
        return l1 == null || l2 == null ? false : (l1 == l2 ? true : (l1.getTile() == null || l2.getTile() == null ? false : l1.getTile().isConnectedTo(l2.getTile())));
    }

    public boolean isPolar(Tile tile) {
        return tile.getY() <= 2 || tile.getY() >= this.getHeight() - 2 - 1;
    }

    public Direction getDirection(Tile t1, Tile t2) {
        return t1 == null || t2 == null ? null : new Position(t1).getDirection(new Position(t2));
    }

    public static Direction getRoughDirection(Tile src, Tile dst) {
        int x = dst.getX() - src.getX();
        int y = dst.getY() - src.getY();
        if (x == 0 && y == 0) {
            return null;
        }
        double theta = Math.atan2(y, x) + 1.5707963267948966 + 0.39269908169872414;
        if (theta < 0.0) {
            theta += Math.PI * 2;
        }
        return Direction.angleToDirection(theta);
    }

    public Tile getAdjacentTile(int x, int y, Direction direction) {
        return this.getTile(direction.step(x, y));
    }

    public Tile getAdjacentTile(Tile tile, Direction direction) {
        return this.getAdjacentTile(tile.getX(), tile.getY(), direction);
    }

    public int getDistance(Tile t1, Tile t2) {
        return Position.getDistance(t1.getX(), t1.getY(), t2.getX(), t2.getY());
    }

    public Tile getClosestTile(Tile tile, Collection<Tile> tiles) {
        Tile result = null;
        int minimumDistance = Integer.MAX_VALUE;
        for (Tile t : tiles) {
            int distance = this.getDistance(t, tile);
            if (distance >= minimumDistance) continue;
            minimumDistance = distance;
            result = t;
        }
        return result;
    }

    public Tile getRandomLandTile(Random random) {
        int SLOSH = 10;
        int x = 0;
        int y = 0;
        int width = this.getWidth();
        int height = this.getHeight();
        if (width >= 10) {
            width -= 10;
            x += 5;
        }
        if (height >= 10) {
            height -= 10;
            y += 5;
        }
        for (Tile t : this.getCircleTiles(this.getTile(x += RandomUtils.randomInt(logger, "W", random, width), y += RandomUtils.randomInt(logger, "H", random, height)), true, Integer.MAX_VALUE)) {
            if (!t.isLand()) continue;
            return t;
        }
        return null;
    }

    private SearchHeuristic getManhattenHeuristic(Tile endTile) {
        return tile -> tile.getDistanceTo(endTile);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Location findRealStart(Unit unit, Location start, Unit carrier) {
        Location entry;
        if (unit == null) {
            throw new IllegalArgumentException("Null unit.");
        }
        if (carrier != null && !carrier.canCarryUnits()) {
            throw new IllegalArgumentException("Non-carrier carrier: " + carrier);
        }
        if (carrier != null && !carrier.couldCarry(unit)) {
            throw new IllegalArgumentException("Carrier could not carry unit: " + carrier + "/" + unit);
        }
        if (start == null) {
            throw new IllegalArgumentException("Null start: " + unit);
        }
        if (start instanceof Unit) {
            Location unitLoc = ((Unit)start).getLocation();
            if (unitLoc == null) {
                throw new IllegalArgumentException("Null on-carrier start: " + unit + "/" + start);
            }
            if (unitLoc instanceof HighSeas) {
                if (carrier == null) {
                    throw new IllegalArgumentException("Null carrier when starting on high seas: " + unit);
                }
                if (carrier != start) {
                    throw new IllegalArgumentException("Wrong carrier when starting on high seas: " + unit + "/" + carrier + " != " + start);
                }
                entry = carrier.resolveDestination();
                return entry.getTile() != null ? entry.getTile() : entry;
            } else {
                entry = unitLoc;
            }
            return entry.getTile() != null ? entry.getTile() : entry;
        } else if (start instanceof HighSeas) {
            if (unit.isOnCarrier()) {
                entry = unit.getCarrier().resolveDestination();
                return entry.getTile() != null ? entry.getTile() : entry;
            } else {
                if (!unit.isNaval()) throw new IllegalArgumentException("No carrier when starting on high seas: " + unit + "/" + unit.getLocation());
                entry = unit.resolveDestination();
            }
            return entry.getTile() != null ? entry.getTile() : entry;
        } else {
            if (!(start instanceof Europe) && start.getTile() == null) throw new IllegalArgumentException("Invalid start: " + start);
            entry = start;
        }
        return entry.getTile() != null ? entry.getTile() : entry;
    }

    private Location findRealEnd(Location end) {
        if (end == null) {
            throw new IllegalArgumentException("Null end.");
        }
        if (end instanceof Europe) {
            return end;
        }
        if (end.getTile() != null) {
            return end.getTile();
        }
        throw new IllegalArgumentException("Invalid end: " + end);
    }

    private PathNode getBestEntryPath(Unit unit, Tile tile, Unit carrier, CostDecider costDecider) {
        return this.searchMap(unit, tile, GoalDeciders.getHighSeasGoalDecider(), costDecider != null ? costDecider : CostDeciders.avoidSettlementsAndBlockingUnits(), Integer.MAX_VALUE, carrier, null, null);
    }

    public Tile getBestEntryTile(Unit unit, Tile tile, Unit carrier, CostDecider costDecider) {
        PathNode path = this.getBestEntryPath(unit, tile, carrier, costDecider);
        return path == null ? null : path.getLastNode().getTile();
    }

    private PathNode findMapPath(Unit unit, Tile start, Tile end, Unit carrier, CostDecider costDecider, LogBuilder lb) {
        Unit embarkTo;
        PathNode path;
        Unit offMapUnit = carrier != null ? carrier : (unit != null && unit.isNaval() ? unit : null);
        GoalDecider gd = GoalDeciders.getLocationGoalDecider(end);
        SearchHeuristic sh = this.getManhattenHeuristic(end);
        if (start.getContiguity() == end.getContiguity()) {
            PathNode carrierPath;
            path = this.searchMap(unit, start, gd, costDecider, Integer.MAX_VALUE, null, sh, lb);
            PathNode pathNode = carrierPath = carrier == null ? null : this.searchMap(unit, start, gd, costDecider, Integer.MAX_VALUE, carrier, sh, lb);
            if (carrierPath != null && (path == null || path.getLastNode().getCost() > carrierPath.getLastNode().getCost())) {
                path = carrierPath;
            }
        } else if (offMapUnit != null) {
            path = this.searchMap(unit, start, gd, costDecider, Integer.MAX_VALUE, carrier, sh, lb);
        } else if (unit != null && unit.isOnCarrier() && !start.isLand() && end.isLand() && !start.getContiguityAdjacent(end.getContiguity()).isEmpty()) {
            path = this.searchMap(unit, start, gd, costDecider, Integer.MAX_VALUE, carrier, sh, lb);
        } else if (start.isLand() && !end.isLand() && end.getFirstUnit() != null && !end.getContiguityAdjacent(start.getContiguity()).isEmpty() && unit != null && unit.getOwner().owns(end.getFirstUnit()) && (embarkTo = end.getCarrierForUnit(unit)) != null) {
            path = this.searchMap(unit, start, GoalDeciders.getAdjacentLocationGoalDecider(end), costDecider, Integer.MAX_VALUE, null, null, lb);
            if (path != null) {
                PathNode last = path.getLastNode();
                last.next = new PathNode(embarkTo, 0, last.getTurns() + 1, true, last, null);
            }
        } else {
            path = null;
        }
        return path;
    }

    private void finishPath(PathNode path, Unit unit, LogBuilder lb) {
        if (path != null) {
            int initialTurns;
            int n = !unit.isAtSea() ? 0 : (initialTurns = (unit.isOnCarrier() ? unit.getCarrier() : unit).getWorkLeft());
            if (initialTurns != 0) {
                path.addTurns(initialTurns);
            }
            if (lb != null) {
                lb.add("\nSuccess\n", path.fullPathToString());
            }
        }
        if (lb != null) {
            lb.log(logger, Level.INFO);
        }
    }

    public PathNode findPath(Unit unit, Location start, Location end, Unit carrier, CostDecider costDecider, LogBuilder lb) {
        PathNode path;
        Unit offMapUnit;
        Location realEnd;
        if (this.traceSearch) {
            lb = new LogBuilder(1024);
        }
        Location realStart = this.findRealStart(unit, start, carrier);
        try {
            realEnd = this.findRealEnd(end);
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException("Path fail: " + unit + " from " + start + " to " + end + " with " + carrier, iae);
        }
        Unit unit2 = offMapUnit = carrier != null ? carrier : unit;
        if (realEnd instanceof Tile && !((Tile)realEnd).isExplored()) {
            path = null;
        } else if (realStart instanceof Europe && realEnd instanceof Europe) {
            path = new PathNode(realStart, unit.getMovesLeft(), 0, false, null, null);
        } else if (realStart instanceof Europe && realEnd instanceof Tile) {
            if (offMapUnit == null || !offMapUnit.getType().canMoveToHighSeas()) {
                path = null;
            } else {
                PathNode p = this.getBestEntryPath(unit, (Tile)realEnd, carrier, costDecider);
                if (p == null) {
                    path = null;
                } else {
                    Tile tile = p.getLastNode().getTile();
                    path = this.findMapPath(unit, tile, (Tile)realEnd, carrier, costDecider, lb);
                    if (path == null) {
                        if (!((Tile)realEnd).isOnRiver()) {
                            LogBuilder l2 = new LogBuilder(512);
                            l2.add("Fail in findPath(", unit, ", ", tile, ", ", realEnd, ", ", carrier, ")\n");
                            l2.addStackTrace();
                            l2.add(p.fullPathToString());
                            this.findMapPath(unit, tile, (Tile)realEnd, carrier, costDecider, l2);
                            l2.log(logger, Level.WARNING);
                        }
                        path = null;
                    } else {
                        path.addTurns(offMapUnit.getSailTurns());
                        path = path.previous = new PathNode(realStart, unit.getMovesLeft(), 0, carrier != null, null, path);
                        if (carrier != null && unit.getLocation() != carrier) {
                            path = path.previous = new PathNode(realStart, unit.getMovesLeft(), 0, false, null, path);
                        }
                    }
                }
            }
        } else if (realStart instanceof Tile && realEnd instanceof Europe) {
            if (offMapUnit == null || !offMapUnit.getType().canMoveToHighSeas()) {
                path = null;
            } else {
                PathNode p = this.searchMap(unit, (Tile)realStart, GoalDeciders.getHighSeasGoalDecider(), costDecider, Integer.MAX_VALUE, carrier, null, lb);
                if (p == null) {
                    path = null;
                } else {
                    PathNode last = p.getLastNode();
                    last.next = new PathNode(realEnd, unit.getInitialMovesLeft(), last.getTurns() + offMapUnit.getSailTurns(), last.isOnCarrier(), last, null);
                    path = p;
                }
            }
        } else if (realStart instanceof Tile && realEnd instanceof Tile) {
            path = this.findMapPath(unit, (Tile)realStart, (Tile)realEnd, carrier, costDecider, lb);
        } else {
            throw new IllegalStateException("Can not happen: " + realStart + ", " + realEnd);
        }
        this.finishPath(path, unit, lb);
        return path;
    }

    public PathNode search(Unit unit, Location start, GoalDecider goalDecider, CostDecider costDecider, int maxTurns, Unit carrier, LogBuilder lb) {
        PathNode p;
        Unit offMapUnit;
        if (this.traceSearch) {
            lb = new LogBuilder(1024);
        }
        Location realStart = this.findRealStart(unit, start, carrier);
        Unit unit2 = offMapUnit = carrier != null ? carrier : unit;
        Object path = realStart instanceof Europe ? (offMapUnit == null || !offMapUnit.getType().canMoveToHighSeas() ? null : ((p = this.searchMap(unit, (Tile)offMapUnit.getEntryLocation(), goalDecider, costDecider, maxTurns, carrier, null, lb)) == null ? null : this.findPath(unit, realStart, p.getLastNode().getTile(), carrier, costDecider, lb))) : this.searchMap(unit, realStart.getTile(), goalDecider, costDecider, maxTurns, carrier, null, lb);
        this.finishPath((PathNode)path, unit, lb);
        return path;
    }

    public boolean getSearchTrace() {
        return this.traceSearch;
    }

    public boolean setSearchTrace(boolean trace) {
        boolean ret = this.traceSearch;
        this.traceSearch = trace;
        return ret;
    }

    private boolean usedCarrier(PathNode path) {
        while (path != null) {
            if (path.isOnCarrier()) {
                return true;
            }
            path = path.previous;
        }
        return false;
    }

    private PathNode searchMap(Unit unit, Tile start, GoalDecider goalDecider, CostDecider costDecider, int maxTurns, Unit carrier, SearchHeuristic searchHeuristic, LogBuilder lb) {
        Unit currentUnit;
        Unit offMapUnit;
        HashMap<String, PathNode> openMap = new HashMap<String, PathNode>();
        HashMap<String, PathNode> closedMap = new HashMap<String, PathNode>();
        final HashMap<String, Integer> f = new HashMap<String, Integer>();
        PriorityQueue<PathNode> openMapQueue = new PriorityQueue<PathNode>(1024, new Comparator<PathNode>(){

            @Override
            public int compare(PathNode p1, PathNode p2) {
                return (Integer)f.get(p1.getLocation().getId()) - (Integer)f.get(p2.getLocation().getId());
            }
        });
        Europe europe = unit == null ? null : unit.getOwner().getEurope();
        Unit unit2 = offMapUnit = carrier != null ? carrier : unit;
        Unit unit3 = start.isLand() ? (start.hasSettlement() && start.getSettlement().isConnectedPort() && unit != null && unit.getLocation() == carrier ? carrier : unit) : (currentUnit = offMapUnit);
        if (lb != null) {
            lb.add("Search trace(unit=", unit, ", from=", start, ", max=", maxTurns == Integer.MAX_VALUE ? "-" : Integer.toString(maxTurns), ", carrier=", carrier, ")");
        }
        PathNode firstNode = new PathNode(start, currentUnit != null ? currentUnit.getMovesLeft() : -1, 0, carrier != null && currentUnit == carrier, null, null);
        f.put(start.getId(), searchHeuristic == null ? 0 : searchHeuristic.getValue(start));
        openMap.put(start.getId(), firstNode);
        openMapQueue.offer(firstNode);
        PathNode best = null;
        int bestScore = Integer.MAX_VALUE;
        while (!openMap.isEmpty()) {
            PathNode currentNode = openMapQueue.poll();
            Location currentLocation = currentNode.getLocation();
            openMap.remove(currentLocation.getId());
            if (lb != null) {
                lb.add("\n  ", currentNode);
            }
            Unit unit4 = currentUnit = currentNode.isOnCarrier() ? carrier : unit;
            if (goalDecider.check(currentUnit, currentNode)) {
                if (lb != null) {
                    lb.add(" ***goal(", currentNode.getCost(), ")***");
                }
                best = goalDecider.getGoal();
                bestScore = best.getCost();
                if (goalDecider.hasSubGoals()) continue;
                break;
            }
            if (bestScore < currentNode.getCost()) {
                closedMap.put(currentLocation.getId(), currentNode);
                if (lb == null) continue;
                lb.add(" ...goal cost wins(", bestScore, " < ", currentNode.getCost(), ")...");
                continue;
            }
            if (currentNode.getTurns() > maxTurns) {
                if (lb == null) continue;
                lb.add("...out-of-range");
                continue;
            }
            closedMap.put(currentLocation.getId(), currentNode);
            if (lb != null) {
                lb.add("...close");
            }
            int currentMovesLeft = currentNode.getMovesLeft();
            int currentTurns = currentNode.getTurns();
            boolean currentOnCarrier = currentNode.isOnCarrier();
            Tile currentTile = currentNode.getTile();
            if (currentTile == null) {
                if (lb == null) continue;
                lb.add("...skip Europe");
                continue;
            }
            block12: for (Tile moveTile : currentTile.getSurroundingTiles(1)) {
                String stepLog;
                MoveCandidate move;
                int cc;
                if (lb != null) {
                    lb.add("\n    ", moveTile);
                }
                if (currentNode.previous != null && currentNode.previous.getTile() == moveTile) {
                    if (lb == null) continue;
                    lb.add(" prev");
                    continue;
                }
                PathNode closed = (PathNode)closedMap.get(moveTile.getId());
                if (closed != null && (cc = closed.getCost()) <= currentNode.getCost()) {
                    if (lb == null) continue;
                    lb.add(" ", cc);
                    continue;
                }
                boolean isGoal = goalDecider.check(unit, new PathNode(moveTile, 0, 0x3FFFFFFF, false, currentNode, null));
                if (isGoal && lb != null) {
                    lb.add(" *goal*");
                }
                Unit.MoveType umt = unit.getSimpleMoveType(currentTile, moveTile);
                boolean carrierMove = carrier != null && carrier.isTileAccessible(moveTile);
                boolean unitMove = umt.isProgress();
                if (isGoal) {
                    if (!unitMove) {
                        switch (umt) {
                            case ATTACK_UNIT: 
                            case ATTACK_SETTLEMENT: 
                            case ENTER_FOREIGN_COLONY_WITH_SCOUT: 
                            case ENTER_INDIAN_SETTLEMENT_WITH_SCOUT: 
                            case ENTER_INDIAN_SETTLEMENT_WITH_FREE_COLONIST: 
                            case ENTER_INDIAN_SETTLEMENT_WITH_MISSIONARY: 
                            case ENTER_SETTLEMENT_WITH_CARRIER_AND_GOODS: {
                                unitMove = true;
                                break;
                            }
                            case MOVE_NO_ATTACK_MARINE: 
                            case MOVE_NO_ATTACK_CIVILIAN: {
                                if (moveTile.hasSettlement()) break;
                                unitMove = currentNode.getTurns() > 0 && moveTile.getAvailableAdjacentCount() >= 3;
                                break;
                            }
                            case MOVE_NO_ACCESS_WATER: {
                                if (lb == null) continue block12;
                                lb.add(" !disembark");
                                continue block12;
                            }
                        }
                        if (!unitMove && unit == currentUnit) {
                            if (lb == null) continue;
                            lb.add(new Object[]{" fail-at-GOAL(", umt, ")"});
                            continue;
                        }
                    }
                    if (unitMove && carrierMove && currentOnCarrier) {
                        boolean bl = carrierMove = currentNode.getMovesLeft() > 0 || currentNode.embarkedThisTurn(currentTurns);
                    }
                }
                if (lb != null) {
                    lb.add(new Object[]{" ", umt, "/", unitMove ? "U" : "", carrierMove ? "C" : ""});
                }
                MoveStep step = currentOnCarrier ? (carrierMove ? MoveStep.BYWATER : (unitMove ? MoveStep.DISEMBARK : MoveStep.FAIL)) : (carrierMove && !this.usedCarrier(currentNode) ? MoveStep.EMBARK : (unitMove || isGoal ? (unit.isNaval() ? MoveStep.BYWATER : MoveStep.BYLAND) : MoveStep.FAIL));
                switch (step) {
                    case BYLAND: {
                        move = new MoveCandidate(unit, currentNode, moveTile, currentMovesLeft, currentTurns, false, costDecider != null ? costDecider : CostDeciders.defaultCostDeciderFor(unit));
                        break;
                    }
                    case BYWATER: {
                        move = new MoveCandidate(offMapUnit, currentNode, moveTile, currentMovesLeft, currentTurns, currentOnCarrier, costDecider != null ? costDecider : CostDeciders.defaultCostDeciderFor(offMapUnit));
                        break;
                    }
                    case EMBARK: {
                        move = new MoveCandidate(unit, currentNode, moveTile, currentMovesLeft, currentTurns, true, costDecider != null ? costDecider : CostDeciders.defaultCostDeciderFor(unit));
                        move.embarkUnit(carrier);
                        break;
                    }
                    case DISEMBARK: {
                        move = new MoveCandidate(unit, currentNode, moveTile, 0, currentTurns, false, costDecider != null ? costDecider : CostDeciders.defaultCostDeciderFor(unit));
                        break;
                    }
                    default: {
                        move = null;
                    }
                }
                if (move == null) {
                    stepLog = "!";
                } else {
                    move.resetPath(isGoal);
                    if (closed != null) {
                        if (move.canImprove(closed)) {
                            closedMap.remove(moveTile.getId());
                            move.improve(openMap, openMapQueue, f, searchHeuristic);
                            stepLog = "^" + Integer.toString(move.getCost());
                        } else {
                            stepLog = ".";
                        }
                    } else if (move.canImprove((PathNode)openMap.get(moveTile.getId()))) {
                        move.improve(openMap, openMapQueue, f, searchHeuristic);
                        stepLog = "+" + Integer.toString(move.getCost());
                    } else {
                        stepLog = "-";
                    }
                }
                if (lb == null) continue;
                lb.add(new Object[]{" ", step, stepLog});
            }
        }
        if ((best = goalDecider.getGoal()) != null) {
            while (best.previous != null) {
                best.previous.next = best;
                best = best.previous;
            }
        }
        return best;
    }

    public Tile searchCircle(Tile start, GoalDecider goalDecider, int radius) {
        Tile t;
        PathNode path;
        if (start == null || goalDecider == null || radius <= 0) {
            return null;
        }
        Iterator<Tile> iterator = this.getCircleTiles(start, true, radius).iterator();
        while (iterator.hasNext() && (!goalDecider.check(null, path = new PathNode(t = iterator.next(), 0, start.getDistanceTo(t), false, null, null)) || goalDecider.hasSubGoals())) {
        }
        PathNode best = goalDecider.getGoal();
        return best == null ? null : best.getTile();
    }

    public Iterator<Tile> getCircleIterator(Tile center, boolean isFilled, int radius) {
        return new CircleIterator(center, isFilled, radius);
    }

    public Iterable<Tile> getCircleTiles(final Tile center, final boolean isFilled, final int radius) {
        return new Iterable<Tile>(){

            @Override
            public Iterator<Tile> iterator() {
                return Map.this.getCircleIterator(center, isFilled, radius);
            }
        };
    }

    public Iterator<Tile> getWholeMapIterator() {
        return new WholeMapIterator();
    }

    public Iterable<Tile> getAllTiles() {
        return new Iterable<Tile>(){

            @Override
            public Iterator<Tile> iterator() {
                return new WholeMapIterator();
            }
        };
    }

    public Tile getLandWithinDistance(int x, int y, int distance) {
        for (Tile t : this.getCircleTiles(this.getTile(x, y), true, distance)) {
            if (!t.isLand()) continue;
            return t;
        }
        return null;
    }

    public void forSubMap(int x, int y, int w, int h, Consumer<Tile> consumer) {
        if (x < 0) {
            w += x;
            x = 0;
        }
        if (y < 0) {
            h += y;
            y = 0;
        }
        if (w <= 0 || h <= 0) {
            return;
        }
        int width = this.getWidth();
        int height = this.getHeight();
        if (x > width || y > height) {
            return;
        }
        if (x + w > width) {
            w = width - x;
        }
        if (y + h > height) {
            h = height - y;
        }
        for (int yi = y; yi < y + h; ++yi) {
            for (int xi = x; xi < x + w; ++xi) {
                consumer.accept(this.tiles[xi][yi]);
            }
        }
    }

    public static boolean[][] floodFill(boolean[][] boolmap, int x, int y) {
        return Map.floodFill(boolmap, x, y, Integer.MAX_VALUE);
    }

    public static boolean[][] floodFill(boolean[][] boolmap, int x, int y, int limit) {
        Position p = new Position(x, y);
        LinkedList<Position> q = new LinkedList<Position>();
        boolean[][] visited = new boolean[boolmap.length][boolmap[0].length];
        visited[p.getX()][p.getY()] = true;
        --limit;
        do {
            for (Direction direction : Direction.values()) {
                Position n = new Position(p, direction);
                if (!n.isValid(boolmap.length, boolmap[0].length) || !boolmap[n.getX()][n.getY()] || visited[n.getX()][n.getY()] || limit <= 0) continue;
                visited[n.getX()][n.getY()] = true;
                --limit;
                q.add(n);
            }
        } while ((p = (Position)q.poll()) != null && limit > 0);
        return visited;
    }

    public void resetContiguity() {
        Tile t;
        int xx;
        int yy;
        boolean[][] found;
        Tile tile;
        int y;
        boolean[][] waterMap = new boolean[this.getWidth()][this.getHeight()];
        for (int y2 = 0; y2 < this.getHeight(); ++y2) {
            for (int x = 0; x < this.getWidth(); ++x) {
                if (!this.isValid(x, y2)) continue;
                waterMap[x][y2] = !this.getTile(x, y2).isLand();
                Tile tile2 = this.getTile(x, y2);
                tile2.setContiguity(-1);
            }
        }
        int contig = 0;
        for (y = 0; y < this.getHeight(); ++y) {
            for (int x = 0; x < this.getWidth(); ++x) {
                if (!waterMap[x][y] || (tile = this.getTile(x, y)).getContiguity() >= 0) continue;
                found = Map.floodFill(waterMap, x, y);
                for (yy = 0; yy < this.getHeight(); ++yy) {
                    for (xx = 0; xx < this.getWidth(); ++xx) {
                        if (!found[xx][yy] || (t = this.getTile(xx, yy)).getContiguity() >= 0) continue;
                        t.setContiguity(contig);
                    }
                }
                ++contig;
            }
        }
        for (y = 0; y < this.getHeight(); ++y) {
            for (int x = 0; x < this.getWidth(); ++x) {
                if (!this.isValid(x, y)) continue;
                waterMap[x][y] = !waterMap[x][y];
            }
        }
        for (y = 0; y < this.getHeight(); ++y) {
            for (int x = 0; x < this.getWidth(); ++x) {
                if (!waterMap[x][y] || (tile = this.getTile(x, y)).getContiguity() >= 0) continue;
                found = Map.floodFill(waterMap, x, y);
                for (yy = 0; yy < this.getHeight(); ++yy) {
                    for (xx = 0; xx < this.getWidth(); ++xx) {
                        if (!found[xx][yy] || (t = this.getTile(xx, yy)).getContiguity() >= 0) continue;
                        t.setContiguity(contig);
                    }
                }
                ++contig;
            }
        }
    }

    public void resetHighSeas(int distToLandFromHighSeas, int maxDistanceToEdge) {
        Specification spec = this.getSpecification();
        TileType ocean = spec.getTileType("model.tile.ocean");
        TileType highSeas = spec.getTileType("model.tile.highSeas");
        if (highSeas == null) {
            throw new RuntimeException("HighSeas TileType must exist");
        }
        if (ocean == null) {
            throw new RuntimeException("Ocean TileType must exist");
        }
        if (distToLandFromHighSeas < 0) {
            throw new RuntimeException("Land<->HighSeas distance can not be negative");
        }
        if (maxDistanceToEdge < 0) {
            throw new RuntimeException("Distance to edge can not be negative");
        }
        for (Tile t : this.getAllTiles()) {
            if (t.getType() != highSeas) continue;
            t.setType(ocean);
        }
        int width = this.getWidth();
        int height = this.getHeight();
        Tile seaL = null;
        Tile seaR = null;
        int totalL = 0;
        int totalR = 0;
        int distanceL = -1;
        int distanceR = -1;
        for (int y = 0; y < height; ++y) {
            int distance;
            Tile other;
            Tile t;
            int x;
            for (x = 0; x < maxDistanceToEdge && x < width && this.isValid(x, y) && (t = this.getTile(x, y)).getType() == ocean; ++x) {
                other = this.getLandWithinDistance(x, y, distToLandFromHighSeas);
                if (other == null) {
                    t.setType(highSeas);
                    ++totalL;
                    continue;
                }
                distance = t.getDistanceTo(other);
                if (distanceL >= distance) continue;
                distanceL = distance;
                seaL = t;
            }
            for (x = 0; x < maxDistanceToEdge && x < width && this.isValid(width - 1 - x, y) && (t = this.getTile(width - 1 - x, y)).getType() == ocean; ++x) {
                other = this.getLandWithinDistance(width - 1 - x, y, distToLandFromHighSeas);
                if (other == null) {
                    t.setType(highSeas);
                    ++totalR;
                    continue;
                }
                distance = t.getDistanceTo(other);
                if (distanceR >= distance) continue;
                distanceR = distance;
                seaR = t;
            }
        }
        if (totalL <= 0 && seaL != null) {
            seaL.setType(highSeas);
            ++totalL;
        }
        if (totalR <= 0 && seaR != null) {
            seaR.setType(highSeas);
            ++totalR;
        }
        if (totalL <= 0 || totalR <= 0) {
            logger.warning("No high seas on " + (totalL <= 0 && totalR <= 0 ? "either" : (totalL <= 0 ? "left" : (totalR <= 0 ? "right" : "BOGUS"))) + " side of the map." + "  This can cause failures on small test maps.");
        }
    }

    public void resetHighSeasCount() {
        ArrayList curr = new ArrayList();
        ArrayList<Tile> next = new ArrayList<Tile>();
        int hsc = 0;
        for (Tile t : this.getAllTiles()) {
            t.setHighSeasCount(-1);
            if (t.isLand()) continue;
            if ((t.getX() == 0 || t.getX() == this.getWidth() - 1) && t.getType() != null && t.getType().isHighSeasConnected() && !t.getType().isDirectlyHighSeasConnected() && t.getMoveToEurope() == null) {
                t.setMoveToEurope(Boolean.TRUE);
            }
            if (!t.isDirectlyHighSeasConnected()) continue;
            t.setHighSeasCount(hsc);
            next.add(t);
        }
        while (!next.isEmpty()) {
            ++hsc;
            curr.addAll(next);
            next.clear();
            while (!curr.isEmpty()) {
                Tile tile = (Tile)curr.remove(0);
                Position position = new Position(tile.getX(), tile.getY());
                for (Direction d : Direction.values()) {
                    Tile t;
                    Position p = new Position(position, d);
                    if (!this.isValid(p) || (t = this.getTile(p)).getHighSeasCount() >= 0) continue;
                    t.setHighSeasCount(hsc);
                    if (t.isLand()) continue;
                    next.add(t);
                }
            }
        }
    }

    public void resetLayers() {
        boolean regions = false;
        boolean rivers = false;
        boolean lostCityRumours = false;
        boolean resources = false;
        boolean nativeSettlements = false;
        for (Tile t : this.getAllTiles()) {
            regions |= t.getRegion() != null;
            rivers |= t.hasRiver();
            lostCityRumours |= t.hasLostCityRumour();
            resources |= t.hasResource();
            nativeSettlements |= t.getSettlement() instanceof IndianSettlement;
        }
        this.setLayer(rivers && lostCityRumours && resources && nativeSettlements ? Layer.ALL : (nativeSettlements || lostCityRumours ? Layer.NATIVES : (resources ? Layer.RESOURCES : (rivers ? Layer.RIVERS : (regions ? Layer.REGIONS : Layer.TERRAIN)))));
    }

    public void fixupRegions() {
        for (Region r : this.regions) {
            if (r.isPacific()) continue;
            Region p = r.getParent();
            if (r.getDiscoverable() && p != null && p.getDiscoverable()) {
                p = p.getParent();
                r.setParent(p);
            }
            if (p == null || p.getChildren().contains(r)) continue;
            p.addChild(r);
        }
    }

    @Override
    public Tile getTile() {
        return null;
    }

    @Override
    public StringTemplate getLocationLabel() {
        return StringTemplate.key("newWorld");
    }

    @Override
    public StringTemplate getLocationLabelFor(Player player) {
        String name = player.getNewLandName();
        return name == null ? this.getLocationLabel() : StringTemplate.name(name);
    }

    @Override
    public boolean add(Locatable locatable) {
        if (locatable instanceof Unit) {
            throw new RuntimeException("Disabled Map.add(Unit)");
        }
        return false;
    }

    @Override
    public boolean remove(Locatable locatable) {
        Tile tile;
        if (locatable instanceof Unit && (tile = locatable.getTile()) != null) {
            return tile.remove(locatable);
        }
        return false;
    }

    @Override
    public boolean contains(Locatable locatable) {
        return locatable instanceof Unit && locatable.getLocation() != null && locatable.getLocation().getTile() != null;
    }

    @Override
    public boolean canAdd(Locatable locatable) {
        return locatable instanceof Unit;
    }

    @Override
    public int getUnitCount() {
        return -1;
    }

    @Override
    public List<Unit> getUnitList() {
        return Collections.emptyList();
    }

    @Override
    public Iterator<Unit> getUnitIterator() {
        return this.getUnitList().iterator();
    }

    @Override
    public GoodsContainer getGoodsContainer() {
        return null;
    }

    @Override
    public Settlement getSettlement() {
        return null;
    }

    @Override
    public Colony getColony() {
        return null;
    }

    @Override
    public IndianSettlement getIndianSettlement() {
        return null;
    }

    @Override
    public Location up() {
        return this;
    }

    @Override
    public int getRank() {
        return -3;
    }

    @Override
    public String toShortString() {
        return "Map";
    }

    @Override
    public int checkIntegrity(boolean fix) {
        int result = super.checkIntegrity(fix);
        for (Tile t : this.getAllTiles()) {
            result = Math.min(result, t.checkIntegrity(fix));
        }
        return result;
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        xw.writeAttribute(WIDTH_TAG, this.getWidth());
        xw.writeAttribute(HEIGHT_TAG, this.getHeight());
        xw.writeAttribute(LAYER_TAG, this.layer);
        xw.writeAttribute(MINIMUM_LATITUDE_TAG, this.minimumLatitude);
        xw.writeAttribute(MAXIMUM_LATITUDE_TAG, this.maximumLatitude);
    }

    @Override
    protected void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeChildren(xw);
        for (Region region : Map.getSortedCopy(this.regions)) {
            region.toXML(xw);
        }
        for (Tile tile : this.getAllTiles()) {
            tile.toXML(xw);
        }
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        this.setLayer(xr.getAttribute(LAYER_TAG, Layer.class, Layer.ALL));
        if (this.tiles == null) {
            int width = xr.getAttribute(WIDTH_TAG, -1);
            if (width < 0) {
                throw new XMLStreamException("Bogus width: " + width);
            }
            int height = xr.getAttribute(HEIGHT_TAG, -1);
            if (height < 0) {
                throw new XMLStreamException("Bogus height: " + height);
            }
            this.tiles = new Tile[width][height];
        }
        this.minimumLatitude = xr.getAttribute(MINIMUM_LATITUDE_TAG, -90);
        this.maximumLatitude = xr.getAttribute(MAXIMUM_LATITUDE_TAG, 90);
        this.calculateLatitudePerRow();
    }

    @Override
    protected void readChildren(FreeColXMLReader xr) throws XMLStreamException {
        this.fixupHighSeas = false;
        this.missingRegions.clear();
        super.readChildren(xr);
        if (this.getGame().isInServer() && !this.missingRegions.isEmpty()) {
            TerrainGenerator.makeLakes(this, this.missingRegions);
        }
        if (this.fixupHighSeas) {
            this.resetHighSeasCount();
        }
        for (Tile t : this.getAllTiles()) {
            Settlement s = t.getOwningSettlement();
            if (s == null) continue;
            s.addTile(t);
        }
        this.fixupRegions();
    }

    @Override
    protected void readChild(FreeColXMLReader xr) throws XMLStreamException {
        Game game = this.getGame();
        String tag = xr.getLocalName();
        if (Region.getXMLElementTagName().equals(tag)) {
            this.addRegion(xr.readFreeColGameObject(game, Region.class));
        } else if (Tile.getXMLElementTagName().equals(tag)) {
            Tile t = xr.readFreeColGameObject(game, Tile.class);
            this.setTile(t, t.getX(), t.getY());
            if (t.getType() != null && "model.tile.lake".equals(t.getType().getId()) && t.getRegion() == null) {
                this.missingRegions.add(t);
            }
            if (t.getHighSeasCount() == Integer.MAX_VALUE) {
                this.fixupHighSeas = true;
            }
        } else {
            super.readChild(xr);
        }
    }

    @Override
    public String getXMLTagName() {
        return Map.getXMLElementTagName();
    }

    public static String getXMLElementTagName() {
        return "map";
    }

    private class WholeMapIterator
    implements Iterator<Tile> {
        private int x = 0;
        private int y = 0;

        @Override
        public boolean hasNext() {
            return this.y < Map.this.getHeight();
        }

        @Override
        public Tile next() throws NoSuchElementException {
            if (!this.hasNext()) {
                throw new NoSuchElementException("WholeMapIterator exhausted");
            }
            Tile result = Map.this.getTile(this.x, this.y);
            ++this.x;
            if (this.x >= Map.this.getWidth()) {
                this.x = 0;
                ++this.y;
            }
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private final class CircleIterator
    implements Iterator<Tile> {
        private final int radius;
        private int currentRadius;
        private int n;
        private int x;
        private int y;

        public CircleIterator(Tile center, boolean isFilled, int radius) {
            if (center == null) {
                throw new IllegalArgumentException("center must not be null.");
            }
            this.radius = radius;
            this.n = 0;
            if (isFilled || radius == 1) {
                Position step = Direction.NE.step(center.getX(), center.getY());
                this.x = step.x;
                this.y = step.y;
                this.currentRadius = 1;
            } else {
                Position step;
                this.currentRadius = radius;
                this.x = center.getX();
                this.y = center.getY();
                for (int i = 1; i < radius; ++i) {
                    step = Direction.N.step(this.x, this.y);
                    this.x = step.x;
                    this.y = step.y;
                }
                step = Direction.NE.step(this.x, this.y);
                this.x = step.x;
                this.y = step.y;
            }
            if (!Map.this.isValid(this.x, this.y)) {
                this.nextTile();
            }
        }

        public int getCurrentRadius() {
            return this.currentRadius;
        }

        private void nextTile() {
            boolean started = this.n != 0;
            do {
                Direction direction;
                ++this.n;
                int width = this.currentRadius * 2;
                if (this.n >= width * 4) {
                    ++this.currentRadius;
                    if (this.currentRadius > this.radius) {
                        this.y = Integer.MIN_VALUE;
                        this.x = Integer.MIN_VALUE;
                        break;
                    }
                    if (!started) {
                        this.y = Integer.MIN_VALUE;
                        this.x = Integer.MIN_VALUE;
                        break;
                    }
                    this.n = 0;
                    started = false;
                    Position step = Direction.NE.step(this.x, this.y);
                    this.x = step.x;
                    this.y = step.y;
                    continue;
                }
                int i = this.n / width;
                switch (i) {
                    case 0: {
                        direction = Direction.SE;
                        break;
                    }
                    case 1: {
                        direction = Direction.SW;
                        break;
                    }
                    case 2: {
                        direction = Direction.NW;
                        break;
                    }
                    case 3: {
                        direction = Direction.NE;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("i=" + i + ", n=" + this.n + ", width=" + width);
                    }
                }
                Position step = direction.step(this.x, this.y);
                this.x = step.x;
                this.y = step.y;
            } while (!Map.this.isValid(this.x, this.y));
        }

        @Override
        public boolean hasNext() {
            return this.x != Integer.MIN_VALUE && this.y != Integer.MIN_VALUE;
        }

        @Override
        public Tile next() throws NoSuchElementException {
            if (!this.hasNext()) {
                throw new NoSuchElementException("CircleIterator exhausted");
            }
            Tile result = Map.this.getTile(this.x, this.y);
            this.nextTile();
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class MoveCandidate {
        private Unit unit;
        private final PathNode current;
        private final Location dst;
        private int movesLeft;
        private int turns;
        private final boolean onCarrier;
        private final CostDecider decider;
        private int cost;
        private PathNode path;

        public MoveCandidate(Unit unit, PathNode current, Location dst, int movesLeft, int turns, boolean onCarrier, CostDecider decider) {
            this.unit = unit;
            this.current = current;
            this.dst = dst;
            this.movesLeft = movesLeft;
            this.turns = turns;
            this.onCarrier = onCarrier;
            this.decider = decider;
            this.cost = decider.getCost(unit, current.getLocation(), dst, movesLeft);
            if (this.cost != -1) {
                this.turns += decider.getNewTurns();
                this.movesLeft = decider.getMovesLeft();
                this.cost = PathNode.getCost(this.turns, this.movesLeft);
            }
            this.path = null;
        }

        public int getCost() {
            return this.cost;
        }

        public void embarkUnit(Unit unit) {
            this.unit = unit;
            this.movesLeft = unit.getInitialMovesLeft();
            this.cost = PathNode.getCost(this.turns, this.movesLeft);
        }

        public void resetPath(boolean goal) {
            this.path = new PathNode(this.dst, this.movesLeft, this.turns, this.onCarrier, this.current, null);
            if (goal) {
                Settlement s;
                if (this.cost == -1 && this.unit != null && this.current.getTile() != null && this.dst.getTile() != null) {
                    this.movesLeft = this.unit.getInitialMovesLeft();
                    ++this.turns;
                    this.path = new PathNode(this.dst, this.movesLeft, this.turns, this.onCarrier, this.current, null);
                }
                if (this.unit != null && this.path.isOnCarrier() && (s = this.path.getLocation().getSettlement()) != null && this.unit.getOwner().owns(s)) {
                    this.movesLeft = 0;
                    if (this.path.embarkedThisTurn(this.turns)) {
                        ++this.turns;
                    }
                    this.path = new PathNode(s.getTile(), 0, this.turns, false, this.path, null);
                }
                this.cost = PathNode.getCost(this.turns, this.movesLeft);
            }
        }

        public boolean canImprove(PathNode best) {
            return this.cost != -1 && (best == null || this.cost < best.getCost() || this.cost == best.getCost() && best.getLength() < this.path.getLength());
        }

        public void improve(HashMap<String, PathNode> openMap, PriorityQueue<PathNode> openMapQueue, HashMap<String, Integer> f, SearchHeuristic sh) {
            PathNode best = openMap.get(this.dst.getId());
            if (best != null) {
                openMap.remove(this.dst.getId());
                openMapQueue.remove(best);
            }
            int fcost = this.cost;
            if (sh != null && this.dst.getTile() != null) {
                fcost += sh.getValue(this.dst.getTile());
            }
            f.put(this.dst.getId(), fcost);
            openMap.put(this.dst.getId(), this.path);
            openMapQueue.offer(this.path);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(128);
            sb.append("[candidate unit=").append(this.unit).append(" dst=").append(this.dst).append(" movesLeft=").append(this.movesLeft).append(" turns=").append(this.turns).append(" onCarrier=").append(this.onCarrier).append(" decider=").append(this.decider).append(" cost=").append(this.cost).append("]");
            return sb.toString();
        }
    }

    private static interface SearchHeuristic {
        public int getValue(Tile var1);
    }

    public static final class Position {
        public final int x;
        public final int y;

        public Position(int posX, int posY) {
            this.x = posX;
            this.y = posY;
        }

        public Position(Tile tile) {
            this(tile.getX(), tile.getY());
        }

        public Position(Position start, Direction direction) {
            Position step = direction == null ? start : direction.step(start.x, start.y);
            this.x = step.x;
            this.y = step.y;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public boolean isValid(int width, int height) {
            return Map.isValid(this.x, this.y, width, height);
        }

        public static int getDistance(int ax, int ay, int bx, int by) {
            int r = bx - ax - (ay - by) / 2;
            if (by > ay && ay % 2 == 0 && by % 2 != 0) {
                ++r;
            } else if (by < ay && ay % 2 != 0 && by % 2 == 0) {
                --r;
            }
            return Math.max(Math.abs(ay - by + r), Math.abs(r));
        }

        public int getDistance(Position position) {
            return Position.getDistance(this.getX(), this.getY(), position.getX(), position.getY());
        }

        public Direction getDirection(Position other) {
            return CollectionUtils.find(Direction.values(), d -> new Position(this, (Direction)d).equals(other), null);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof Position) {
                Position p = (Position)o;
                return this.x == p.x && this.y == p.y;
            }
            return false;
        }

        public int hashCode() {
            return this.x | this.y << 16;
        }

        public String toString() {
            return "(" + this.x + ", " + this.y + ")";
        }
    }

    public static enum Layer {
        NONE,
        LAND,
        TERRAIN,
        REGIONS,
        RIVERS,
        RESOURCES,
        NATIVES,
        ALL;

    }

    private static enum MoveStep {
        FAIL,
        BYLAND,
        BYWATER,
        EMBARK,
        DISEMBARK;

    }
}

