/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.logging.Logger;
import net.sf.freecol.common.debug.FreeColDebugger;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.BuildQueue;
import net.sf.freecol.common.model.BuildableType;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.BuildingType;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.ExportData;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsContainer;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Market;
import net.sf.freecol.common.model.ModelMessage;
import net.sf.freecol.common.model.Named;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.ProductionInfo;
import net.sf.freecol.common.model.Role;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TypeCountMap;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.UnitTypeChange;
import net.sf.freecol.common.model.WorkLocation;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.LogBuilder;
import net.sf.freecol.common.util.RandomUtils;
import net.sf.freecol.server.control.ChangeSet;
import net.sf.freecol.server.model.ServerBuilding;
import net.sf.freecol.server.model.ServerColonyTile;
import net.sf.freecol.server.model.ServerModelObject;
import net.sf.freecol.server.model.ServerPlayer;
import net.sf.freecol.server.model.ServerUnit;

public class ServerColony
extends Colony
implements ServerModelObject {
    private static final Logger logger = Logger.getLogger(ServerColony.class.getName());

    public ServerColony(Game game, String id) {
        super(game, id);
    }

    public ServerColony(Game game, Player owner, String name, Tile tile) {
        super(game, owner, name, tile);
        Specification spec = this.getSpecification();
        this.setGoodsContainer(new GoodsContainer(game, this));
        this.sonsOfLiberty = 0;
        this.oldSonsOfLiberty = 0;
        this.established = game.getTurn();
        ServerColonyTile colonyTile = new ServerColonyTile(game, this, tile);
        this.colonyTiles.add(colonyTile);
        for (Tile t : tile.getSurroundingTiles(this.getRadius())) {
            this.colonyTiles.add(new ServerColonyTile(game, this, t));
        }
        List<BuildingType> buildingTypes = spec.getBuildingTypeList();
        for (BuildingType buildingType : buildingTypes) {
            if (!buildingType.isAutomaticBuild() && !this.isAutomaticBuild(buildingType)) continue;
            ServerBuilding building = new ServerBuilding(this.getGame(), this, buildingType);
            this.addBuilding(building);
        }
        if (this.isLandLocked()) {
            this.buildQueue.add(spec.getBuildingType("model.building.warehouse"));
        } else {
            this.buildQueue.add(spec.getBuildingType("model.building.docks"));
            this.addPortAbility();
        }
        for (UnitType unitType : spec.getUnitTypesWithAbility("model.ability.bornInColony")) {
            if (!unitType.needsGoodsToBuild()) continue;
            this.populationQueue.add(unitType);
        }
    }

    @Override
    public void csNewTurn(Random random, LogBuilder lb, ChangeSet cs) {
        lb.add("COLONY ", this);
        Specification spec = this.getSpecification();
        ServerPlayer owner = (ServerPlayer)this.getOwner();
        BuildQueue[] queues = new BuildQueue[]{this.buildQueue, this.populationQueue};
        Tile tile = this.getTile();
        if (this.getUnitCount() <= 0) {
            lb.add(" 0-unit DISPOSING, ");
            owner.csDisposeSettlement(this, cs);
            return;
        }
        boolean tileDirty = false;
        boolean newUnitBorn = false;
        GoodsContainer container = this.getGoodsContainer();
        container.saveState();
        for (WorkLocation workLocation : this.getCurrentWorkLocations()) {
            ((ServerModelObject)((Object)workLocation)).csNewTurn(random, lb, cs);
            ProductionInfo productionInfo = this.getProductionInfo(workLocation);
            if (productionInfo == null) continue;
            if (!workLocation.isEmpty()) {
                for (AbstractGoods goods : productionInfo.getProduction()) {
                    UnitType expert = spec.getExpertForProducing(goods.getType());
                    int experience = goods.getAmount() / workLocation.getUnitCount();
                    for (Unit unit : workLocation.getUnitList()) {
                        if (goods.getType() != unit.getExperienceType() || !unit.getType().canBeUpgraded(expert, UnitTypeChange.ChangeType.EXPERIENCE)) continue;
                        unit.setExperience(unit.getExperience() + experience);
                        cs.addPartial(ChangeSet.See.only(owner), unit, "experience");
                    }
                }
            }
            if (!(workLocation instanceof ServerBuilding)) continue;
            ((ServerBuilding)workLocation).csCheckMissingInput(productionInfo, cs);
        }
        ArrayList<BuildQueue> built = new ArrayList<BuildQueue>();
        for (BuildQueue queue : queues) {
            ProductionInfo info = this.getProductionInfo(queue);
            if (info == null) continue;
            if (info.getConsumption().isEmpty()) {
                AbstractGoods abstractGoods;
                int complete;
                Object build = queue.getCurrentlyBuilding();
                if (build == null || (complete = this.getTurnsToComplete((BuildableType)build, abstractGoods = new AbstractGoods())) != -2 && complete != -1) continue;
                cs.addMessage(ChangeSet.See.only(owner), new ModelMessage(ModelMessage.MessageType.MISSING_GOODS, "model.colony.buildableNeedsGoods", this, (FreeColObject)build).addName("%colony%", this.getName()).addNamed("%buildable%", (Named)build).addAmount("%amount%", abstractGoods.getAmount()).addNamed("%goodsType%", abstractGoods.getType()));
                continue;
            }
            BuildableType buildable = this.csNextBuildable(queue, cs);
            if (buildable == null) continue;
            if (buildable instanceof UnitType) {
                Unit unit = this.csBuildUnit(queue, random, cs);
                if (unit.hasAbility("model.ability.bornInColony")) {
                    newUnitBorn = true;
                }
                built.add(queue);
                continue;
            }
            if (buildable instanceof BuildingType) {
                int n = this.getUnitCount();
                if (!this.csBuildBuilding(queue, cs)) continue;
                built.add(queue);
                tileDirty = ((BuildingType)buildable).isDefenceType() || n != this.getUnitCount();
                continue;
            }
            throw new IllegalStateException("Bogus buildable: " + buildable);
        }
        TypeCountMap<GoodsType> typeCountMap = this.getProductionMap();
        for (GoodsType goodsType : typeCountMap.keySet()) {
            int turns;
            int stored;
            int net = typeCountMap.getCount(goodsType);
            if (net + (stored = this.getGoodsCount(goodsType)) <= 0) {
                this.removeGoods(goodsType, stored);
            } else {
                this.addGoods(goodsType, net);
            }
            if (goodsType != spec.getPrimaryFoodType()) continue;
            if (net + stored < 0) {
                if (this.getUnitCount() > 1) {
                    Unit victim = RandomUtils.getRandomMember(logger, "Starver", this.getUnitList(), random);
                    cs.addRemove(ChangeSet.See.only(owner), null, victim);
                    victim.dispose();
                    cs.addMessage(ChangeSet.See.only(owner), new ModelMessage(ModelMessage.MessageType.UNIT_LOST, "model.colony.colonistStarved", this).addName("%colony%", this.getName()));
                    continue;
                }
                cs.addMessage(ChangeSet.See.only(owner), new ModelMessage(ModelMessage.MessageType.UNIT_LOST, "model.colony.colonyStarved", this).addName("%colony%", this.getName()));
                owner.csDisposeSettlement(this, cs);
                return;
            }
            if (net >= 0 || (turns = stored / -net) > 3 || newUnitBorn) continue;
            cs.addMessage(ChangeSet.See.only(owner), new ModelMessage(ModelMessage.MessageType.WARNING, "model.colony.famineFeared", this).addName("%colony%", this.getName()).addAmount("%number%", turns));
            lb.add(" famine in ", turns, " food=", stored, " production=", net);
        }
        this.invalidateCache();
        if (!built.isEmpty()) {
            for (BuildQueue queue : built) {
                switch (queue.getCompletionAction()) {
                    case SHUFFLE: {
                        if (queue.size() <= 1) break;
                        RandomUtils.randomShuffle(logger, "Build queue", queue.getValues(), random);
                        break;
                    }
                    case REMOVE_EXCEPT_LAST: {
                        if (queue.size() == 1 && queue.getCurrentlyBuilding() instanceof UnitType) break;
                    }
                    default: {
                        queue.remove(0);
                    }
                }
                this.csNextBuildable(queue, cs);
            }
            tileDirty = true;
        }
        if (this.hasAbility("model.ability.export")) {
            LogBuilder lb2 = new LogBuilder(64);
            lb2.add(" ");
            lb2.mark();
            for (Goods goods : this.getCompactGoods()) {
                int n;
                GoodsType type = goods.getType();
                ExportData data = this.getExportData(type);
                if (!data.getExported() || !owner.canTrade(goods.getType(), Market.Access.CUSTOM_HOUSE) || (n = goods.getAmount() - data.getExportLevel()) <= 0) continue;
                int oldGold = owner.getGold();
                int marketAmount = owner.sell(container, type, n);
                if (marketAmount > 0) {
                    owner.addExtraTrade(new AbstractGoods(type, marketAmount));
                }
                StringTemplate st = StringTemplate.template("model.colony.customs.saleData").addAmount("%amount%", n).addNamed("%goods%", type).addAmount("%gold%", owner.getGold() - oldGold);
                lb2.add(Messages.message(st), ", ");
            }
            if (lb2.grew(new Object[0])) {
                lb2.shrink(", ");
                cs.addMessage(ChangeSet.See.only(owner), new ModelMessage(ModelMessage.MessageType.GOODS_MOVEMENT, "model.colony.customs.sale", this).addName("%colony%", this.getName()).addName("%data%", lb2.toString()));
                cs.addPartial(ChangeSet.See.only(owner), owner, "gold");
                lb.add(lb2.toString());
            }
        }
        int limit = this.getWarehouseCapacity();
        int adjustment = limit / 100;
        for (Goods goods : this.getCompactGoods()) {
            int loss;
            GoodsType type = goods.getType();
            if (!type.isStorable()) continue;
            ExportData exportData = this.getExportData(type);
            int low = exportData.getLowLevel() * adjustment;
            int high = exportData.getHighLevel() * adjustment;
            int amount = goods.getAmount();
            int oldAmount = container.getOldGoodsCount(type);
            if (!(amount >= low || oldAmount < low || type == spec.getPrimaryFoodType() && newUnitBorn)) {
                cs.addMessage(ChangeSet.See.only(owner), new ModelMessage(ModelMessage.MessageType.WAREHOUSE_CAPACITY, "model.colony.warehouseEmpty", this, type).addNamed("%goods%", type).addAmount("%level%", low).addName("%colony%", this.getName()));
                continue;
            }
            if (type.limitIgnored()) continue;
            String messageId = null;
            int waste = 0;
            if (amount > limit) {
                waste = amount - limit;
                container.removeGoods(type, waste);
                messageId = "model.colony.warehouseWaste";
            } else if (amount == limit && oldAmount < limit) {
                messageId = "model.colony.warehouseOverfull";
            } else if (amount > high && oldAmount <= high) {
                messageId = "model.colony.warehouseFull";
            }
            if (messageId != null) {
                cs.addMessage(ChangeSet.See.only(owner), new ModelMessage(ModelMessage.MessageType.WAREHOUSE_CAPACITY, messageId, this, type).addNamed("%goods%", type).addAmount("%waste%", waste).addAmount("%level%", high).addName("%colony%", this.getName()));
            }
            if (exportData.getExported() && this.hasAbility("model.ability.export") && owner.canTrade(type, Market.Access.CUSTOM_HOUSE) || amount > limit || (loss = amount + this.getNetProductionOf(type) - limit) <= 0) continue;
            cs.addMessage(ChangeSet.See.only(owner), new ModelMessage(ModelMessage.MessageType.WAREHOUSE_CAPACITY, "model.colony.warehouseSoonFull", this, type).addNamed("%goods%", goods).addName("%colony%", this.getName()).addAmount("%amount%", loss));
        }
        for (BuildingType buildingType : spec.getBuildingTypeList()) {
            if (!this.isAutomaticBuild(buildingType)) continue;
            this.buildBuilding(new ServerBuilding(this.getGame(), this, buildingType));
        }
        this.checkBuildQueueIntegrity(true);
        block13: for (Iterator<FreeColObject> iterator : queues) {
            if (!((BuildQueue)((Object)iterator)).isEmpty()) continue;
            for (GoodsType g : spec.getGoodsTypeList()) {
                if (!g.isBuildingMaterial() || g.isRawMaterial() || g.isBreedable() || this.getAdjustedNetProductionOf(g) <= 0 || !this.neededForBuildableType(g)) continue;
                cs.addMessage(ChangeSet.See.only(owner), new ModelMessage(ModelMessage.MessageType.BUILDING_COMPLETED, "model.colony.notBuildingAnything", this).addName("%colony%", this.getName()));
                continue block13;
            }
        }
        this.updateSoL();
        if (this.sonsOfLiberty / 10 != this.oldSonsOfLiberty / 10) {
            cs.addMessage(ChangeSet.See.only(owner), new ModelMessage(ModelMessage.MessageType.SONS_OF_LIBERTY, this.sonsOfLiberty > this.oldSonsOfLiberty ? "model.colony.soLIncrease" : "model.colony.soLDecrease", this, spec.getGoodsType("model.goods.bells")).addAmount("%oldSoL%", this.oldSonsOfLiberty).addAmount("%newSoL%", this.sonsOfLiberty).addName("%colony%", this.getName()));
            ModelMessage govMgtMessage = this.checkForGovMgtChangeMessage();
            if (govMgtMessage != null) {
                cs.addMessage(ChangeSet.See.only(owner), govMgtMessage);
            }
        }
        this.updateProductionBonus();
        for (WorkLocation workLocation : this.getCurrentWorkLocations()) {
            if (!workLocation.canTeach()) continue;
            ServerBuilding building = (ServerBuilding)workLocation;
            for (Unit teacher : building.getUnitList()) {
                building.csCheckTeach(teacher, cs);
            }
        }
        if (tileDirty) {
            cs.add(ChangeSet.See.perhaps(), tile);
        } else {
            cs.add(ChangeSet.See.only(owner), this);
        }
        lb.add(", ");
    }

    private boolean neededForBuildableType(GoodsType goodsType) {
        Specification spec = this.getSpecification();
        ArrayList<BuildableType> buildables = new ArrayList<BuildableType>();
        buildables.addAll(spec.getBuildingTypeList());
        buildables.addAll(spec.getUnitTypesWithoutAbility("model.ability.person"));
        return CollectionUtils.any(buildables, bt -> this.canBuild((BuildableType)bt) && AbstractGoods.containsType(goodsType, bt.getRequiredGoods()));
    }

    private Unit csBuildUnit(BuildQueue<? extends BuildableType> buildQueue, Random random, ChangeSet cs) {
        UnitType type = (UnitType)buildQueue.getCurrentlyBuilding();
        ServerUnit unit = new ServerUnit(this.getGame(), this.getTile(), this.owner, type);
        if (unit.hasAbility("model.ability.bornInColony")) {
            cs.addMessage(ChangeSet.See.only((ServerPlayer)this.owner), new ModelMessage(ModelMessage.MessageType.UNIT_ADDED, "model.colony.newColonist", this, (FreeColObject)unit).addName("%colony%", this.getName()));
        } else {
            unit.setName(this.owner.getNameForUnit(type, random));
            cs.addMessage(ChangeSet.See.only((ServerPlayer)this.owner), new ModelMessage(ModelMessage.MessageType.UNIT_ADDED, "model.colony.unitReady", this, (FreeColObject)unit).addName("%colony%", this.getName()).addStringTemplate("%unit%", unit.getLabel()));
        }
        logger.info("New unit in " + this.getName() + ": " + type.getSuffix());
        return unit;
    }

    public boolean ejectUnits(WorkLocation workLocation, List<Unit> units) {
        if (units == null || units.isEmpty()) {
            return false;
        }
        block0: for (Unit u : units) {
            for (WorkLocation wl : this.getAvailableWorkLocations()) {
                if (wl == workLocation || !wl.canAdd(u)) continue;
                u.setLocation(wl);
                continue block0;
            }
            u.setLocation(this.getTile());
        }
        if (this.getOwner().isAI()) {
            this.firePropertyChange("rearrangeWorkers", true, false);
        }
        return true;
    }

    private boolean csBuildBuilding(BuildQueue<? extends BuildableType> buildQueue, ChangeSet cs) {
        boolean success;
        BuildingType type = (BuildingType)buildQueue.getCurrentlyBuilding();
        Tile copied = this.getTile().getTileToCache();
        BuildingType from = type.getUpgradesFrom();
        if (from == null) {
            success = this.buildBuilding(new ServerBuilding(this.getGame(), this, type));
        } else {
            Building building = this.getBuilding(from);
            List<Unit> eject = building.upgrade();
            boolean bl = success = eject != null;
            if (success) {
                this.ejectUnits(building, eject);
                if (!eject.isEmpty()) {
                    this.getTile().cacheUnseen(copied);
                }
            } else {
                cs.addMessage(ChangeSet.See.only((ServerPlayer)this.owner), this.getUnbuildableMessage(type));
            }
        }
        if (success) {
            cs.addMessage(ChangeSet.See.only((ServerPlayer)this.owner), new ModelMessage(ModelMessage.MessageType.BUILDING_COMPLETED, "model.colony.buildingReady", this).addName("%colony%", this.getName()).addNamed("%building%", type));
            if (this.owner.isAI()) {
                this.firePropertyChange("rearrangeWorkers", true, false);
            }
            logger.info("New building in " + this.getName() + ": " + type.getSuffix());
        }
        return success;
    }

    private BuildableType csNextBuildable(BuildQueue<? extends BuildableType> queue, ChangeSet cs) {
        BuildableType buildable;
        Specification spec = this.getSpecification();
        ServerPlayer owner = (ServerPlayer)this.getOwner();
        boolean invalidate = false;
        while ((buildable = queue.getCurrentlyBuilding()) != null) {
            switch (this.getNoBuildReason(buildable, null)) {
                case LIMIT_EXCEEDED: {
                    break;
                }
                case NONE: {
                    return buildable;
                }
                case NOT_BUILDING: {
                    for (GoodsType goodsType : spec.getGoodsTypeList()) {
                        if (!goodsType.isBuildingMaterial() || goodsType.isStorable() || this.getTotalProductionOf(goodsType) <= 0) continue;
                        cs.addMessage(ChangeSet.See.only(owner), new ModelMessage(ModelMessage.MessageType.WARNING, "model.colony.cannotBuild", this).addName("%colony%", this.getName()));
                    }
                    return null;
                }
                case POPULATION_TOO_SMALL: {
                    cs.addMessage(ChangeSet.See.only(owner), new ModelMessage(ModelMessage.MessageType.WARNING, "model.colony.buildNeedPop", this).addName("%colony%", this.getName()).addNamed("%building%", buildable));
                    break;
                }
                default: {
                    logger.warning("Unexpected build failure at " + this.getName() + " for " + buildable + ": " + (Object)((Object)this.getNoBuildReason(buildable, null)));
                    cs.addMessage(ChangeSet.See.only(owner), this.getUnbuildableMessage(buildable));
                }
            }
            queue.remove(0);
            invalidate = true;
        }
        if (invalidate) {
            this.invalidateCache();
        }
        return null;
    }

    public void csEvictUsers(Unit enemyUnit, ChangeSet cs) {
        ServerPlayer serverPlayer = (ServerPlayer)this.getOwner();
        Tile tile = enemyUnit.getTile();
        ServerColonyTile ct = (ServerColonyTile)this.getColonyTile(tile);
        if (ct == null) {
            return;
        }
        Tile colonyTile = ct.getColony().getTile();
        Tile copied = colonyTile.getTileToCache();
        if (!this.ejectUnits(ct, ct.getUnitList())) {
            return;
        }
        colonyTile.cacheUnseen(copied);
        cs.addMessage(ChangeSet.See.only(serverPlayer), new ModelMessage(ModelMessage.MessageType.WARNING, "model.colony.workersEvicted", this, (FreeColObject)this).addName("%colony%", this.getName()).addStringTemplate("%location%", tile.getLocationLabel()).addStringTemplate("%enemyUnit%", enemyUnit.getLabel()));
        cs.add(ChangeSet.See.only(serverPlayer), ct);
        cs.add(ChangeSet.See.perhaps(), this.getTile());
    }

    public Set<Tile> csChangeOwner(ServerPlayer newOwner, ChangeSet cs) {
        ServerPlayer owner = (ServerPlayer)this.getOwner();
        for (Tile t : this.getOwnedTiles()) {
            t.cacheUnseen(newOwner);
        }
        this.changeOwner(newOwner);
        UnitTypeChange.ChangeType change = newOwner.isUndead() ? UnitTypeChange.ChangeType.UNDEAD : UnitTypeChange.ChangeType.CAPTURE;
        List<Unit> units = this.getUnitList();
        units.addAll(this.getTile().getUnitList());
        for (Unit u : units) {
            owner.csChangeOwner(u, newOwner, change, null, cs);
        }
        cs.addRemoves(ChangeSet.See.only(owner), this, units);
        for (ExportData exportDatum : this.exportData.values()) {
            exportDatum.setExported(false);
        }
        this.buildQueue.clear();
        for (BuildingType bt : newOwner.getFreeBuildingTypes()) {
            this.csFreeBuilding(bt, cs);
        }
        this.updateSoL();
        this.updateProductionBonus();
        return newOwner.exploreForSettlement(this);
    }

    public void csFreeBuilding(BuildingType type, ChangeSet cs) {
        if (this.canBuild(type)) {
            ServerPlayer owner = (ServerPlayer)this.getOwner();
            this.buildBuilding(new ServerBuilding(this.getGame(), this, type));
            this.checkBuildQueueIntegrity(true);
            cs.add(ChangeSet.See.only(owner), this);
            if (owner.isAI()) {
                this.firePropertyChange("rearrangeWorkers", true, false);
            }
        }
    }

    public boolean buildBuilding(Building building) {
        Tile copied;
        FreeColDebugger.debugLog("BUILD " + building + "\n" + FreeColDebugger.stackTraceToString());
        Tile tile = copied = building.getType().isDefenceType() ? this.getTile().getTileToCache() : null;
        if (!this.addBuilding(building)) {
            return false;
        }
        this.getTile().cacheUnseen(copied);
        this.invalidateCache();
        return true;
    }

    public boolean csEquipForRole(Unit unit, Role role, int roleCount, Random random, ChangeSet cs) {
        boolean ret = this.equipForRole(unit, role, roleCount);
        if (ret) {
            if (unit.isOnCarrier()) {
                unit.setMovesLeft(0);
            }
            Tile tile = this.getTile();
            tile.cacheUnseen();
            unit.setLocation(tile);
            cs.add(ChangeSet.See.perhaps(), tile);
        }
        return ret;
    }

    public void csAddConvert(Unit brave, ChangeSet cs) {
        if (brave == null) {
            return;
        }
        ServerPlayer newOwner = (ServerPlayer)this.getOwner();
        ServerPlayer oldOwner = (ServerPlayer)brave.getOwner();
        if (oldOwner.csChangeOwner(brave, newOwner, UnitTypeChange.ChangeType.CONVERSION, this.getTile(), cs)) {
            brave.changeRole(this.getSpecification().getDefaultRole(), 0);
            brave.setMovesLeft(0);
            brave.setState(Unit.UnitState.ACTIVE);
            cs.addDisappear(newOwner, this.tile, brave);
            cs.add(ChangeSet.See.only(newOwner), this.getTile());
            StringTemplate nation = oldOwner.getNationLabel();
            cs.addMessage(ChangeSet.See.only(newOwner), new ModelMessage(ModelMessage.MessageType.UNIT_ADDED, "model.colony.newConvert", brave).addStringTemplate("%nation%", nation).addName("%colony%", this.getName()));
            newOwner.invalidateCanSeeTiles();
            logger.fine("Convert at " + this.getName() + " for " + this.getName());
        }
    }

    public boolean destroyBuilding(Building building) {
        Tile copied;
        Tile tile = copied = building.getType().isDefenceType() ? this.getTile().getTileToCache() : null;
        if (!this.removeBuilding(building)) {
            return false;
        }
        this.getTile().cacheUnseen(copied);
        this.invalidateCache();
        this.checkBuildQueueIntegrity(true);
        return true;
    }

    @Override
    public String getServerXMLElementTagName() {
        return "serverColony";
    }
}

