/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.mindmapmode.listeners;

import freemind.controller.MapMouseMotionListener;
import freemind.modes.MindMapArrowLink;
import freemind.modes.mindmapmode.MindMapController;
import freemind.view.mindmapview.MapView;
import java.awt.Point;
import java.awt.event.MouseEvent;

public class MindMapMouseMotionManager
implements MapMouseMotionListener.MapMouseMotionReceiver {
    int originX = -1;
    int originY = -1;
    MindMapArrowLink draggedLink = null;
    private Point draggedLinkOldStartPoint;
    private Point draggedLinkOldEndPoint;
    private final MindMapController mController;

    public MindMapMouseMotionManager(MindMapController controller) {
        this.mController = controller;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        MapView mapView = (MapView)e.getComponent();
        if (this.originX >= 0) {
            if (this.draggedLink != null) {
                int deltaX = (int)((float)(e.getX() - this.originX) / this.mController.getView().getZoom());
                int deltaY = (int)((float)(e.getY() - this.originY) / this.mController.getView().getZoom());
                this.draggedLink.changeInclination(mapView, this.originX, this.originY, deltaX, deltaY);
                this.originX = e.getX();
                this.originY = e.getY();
                this.mController.getView().repaint();
            } else {
                mapView.scrollBy(this.originX - e.getX(), this.originY - e.getY());
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (!this.mController.isBlocked() && e.getButton() == 1) {
            this.mController.getView().setMoveCursor(true);
            this.originX = e.getX();
            this.originY = e.getY();
            this.draggedLink = this.mController.getView().detectCollision(new Point(this.originX, this.originY));
            if (this.draggedLink != null) {
                this.draggedLinkOldStartPoint = this.draggedLink.getStartInclination();
                this.draggedLinkOldEndPoint = this.draggedLink.getEndInclination();
                this.draggedLink.showControlPoints(true);
                this.mController.getView().repaint();
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.originX = -1;
        this.originY = -1;
        if (this.draggedLink != null) {
            this.draggedLink.showControlPoints(false);
            Point draggedLinkNewStartPoint = this.draggedLink.getStartInclination();
            Point draggedLinkNewEndPoint = this.draggedLink.getEndInclination();
            this.draggedLink.setStartInclination(this.draggedLinkOldStartPoint);
            this.draggedLink.setEndInclination(this.draggedLinkOldEndPoint);
            this.mController.setArrowLinkEndPoints(this.draggedLink, draggedLinkNewStartPoint, draggedLinkNewEndPoint);
            this.mController.getView().repaint();
            this.draggedLink = null;
        }
    }
}

