/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.fop.pdf.PDFObject;
import org.apache.fop.pdf.PDFStream;
import org.apache.fop.pdf.PDFXObject;
import org.apache.fop.pdf.StreamCache;

public class PDFFormXObject
extends PDFXObject {
    private PDFStream contents;
    private String resRef;

    public PDFFormXObject(int xnumber, PDFStream cont, String ref) {
        super(xnumber, null);
        this.contents = cont;
        this.resRef = ref;
    }

    protected int output(OutputStream stream) throws IOException {
        int length = 0;
        String dictEntries = this.getFilterList().buildFilterDictEntries();
        StreamCache encodedStream = this.encodeStream();
        StringBuffer sb = new StringBuffer(128);
        sb.append(this.getObjectID());
        sb.append("<</Type /XObject\n");
        sb.append("/Subtype /Form\n");
        sb.append("/FormType 1\n");
        sb.append("/BBox [0 0 1000 1000]\n");
        sb.append("/Matrix [1 0 0 1 0 0]\n");
        sb.append("/Resources " + this.resRef + "\n");
        sb.append("/Length " + (encodedStream.getSize() + 1) + "\n");
        sb.append(dictEntries);
        sb.append(">>\n");
        byte[] pdfBytes = PDFObject.encode(sb.toString());
        stream.write(pdfBytes);
        length += pdfBytes.length;
        length += this.outputStreamData(encodedStream, stream);
        encodedStream.clear();
        pdfBytes = PDFObject.encode("endobj\n");
        stream.write(pdfBytes);
        this.contents = null;
        return length += pdfBytes.length;
    }

    protected void outputRawStreamData(OutputStream out) throws IOException {
        this.contents.outputRawStreamData(out);
    }
}

