/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.ast;

import java.util.ArrayList;
import java.util.List;
import org.mozilla.javascript.ast.AstNode;
import org.mozilla.javascript.ast.NodeVisitor;
import org.mozilla.javascript.ast.XmlFragment;

public class XmlLiteral
extends AstNode {
    private List<XmlFragment> fragments = new ArrayList<XmlFragment>();

    public XmlLiteral() {
        this.type = 145;
    }

    public XmlLiteral(int n) {
        super(n);
        this.type = 145;
    }

    public XmlLiteral(int n, int n2) {
        super(n, n2);
        this.type = 145;
    }

    public List<XmlFragment> getFragments() {
        return this.fragments;
    }

    public void setFragments(List<XmlFragment> list) {
        this.assertNotNull(list);
        this.fragments.clear();
        for (XmlFragment xmlFragment : list) {
            this.addFragment(xmlFragment);
        }
    }

    public void addFragment(XmlFragment xmlFragment) {
        this.assertNotNull(xmlFragment);
        this.fragments.add(xmlFragment);
        xmlFragment.setParent(this);
    }

    @Override
    public String toSource(int n) {
        StringBuilder stringBuilder = new StringBuilder(250);
        for (XmlFragment xmlFragment : this.fragments) {
            stringBuilder.append(xmlFragment.toSource(0));
        }
        return stringBuilder.toString();
    }

    @Override
    public void visit(NodeVisitor nodeVisitor) {
        if (nodeVisitor.visit(this)) {
            for (XmlFragment xmlFragment : this.fragments) {
                xmlFragment.visit(nodeVisitor);
            }
        }
    }
}

