/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl;

import com.jogamp.opengl.GLRendererQuirks;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.AbstractGraphicsScreen;
import jogamp.opengl.GLContextImpl;
import jogamp.opengl.GLDrawableImpl;

public class SharedResourceRunner
implements Runnable {
    protected static final boolean DEBUG = GLDrawableImpl.DEBUG;
    final HashSet<String> devicesTried = new HashSet();
    final Implementation impl;
    Thread thread;
    boolean running;
    boolean ready;
    boolean shouldRelease;
    String initConnection;
    String releaseConnection;

    private boolean getDeviceTried(String string) {
        return this.devicesTried.contains(string);
    }

    private void addDeviceTried(String string) {
        this.devicesTried.add(string);
    }

    private void removeDeviceTried(String string) {
        this.devicesTried.remove(string);
    }

    public SharedResourceRunner(Implementation implementation) {
        this.impl = implementation;
        this.resetState();
    }

    private void resetState() {
        this.devicesTried.clear();
        this.thread = null;
        this.ready = false;
        this.running = false;
        this.shouldRelease = false;
        this.initConnection = null;
        this.releaseConnection = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Thread start() {
        SharedResourceRunner sharedResourceRunner = this;
        synchronized (sharedResourceRunner) {
            if (null != this.thread && !this.thread.isAlive()) {
                if (DEBUG) {
                    System.err.println("SharedResourceRunner.start() - dead-old-thread cleanup - " + SharedResourceRunner.getThreadName());
                }
                this.releaseSharedResources();
                this.thread = null;
                this.running = false;
            }
            if (null == this.thread) {
                if (DEBUG) {
                    System.err.println("SharedResourceRunner.start() - start new Thread - " + SharedResourceRunner.getThreadName());
                }
                this.resetState();
                this.thread = new Thread((Runnable)this, SharedResourceRunner.getThreadName() + "-SharedResourceRunner");
                this.thread.setDaemon(true);
                this.thread.start();
                while (!this.running) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
        return this.thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        SharedResourceRunner sharedResourceRunner = this;
        synchronized (sharedResourceRunner) {
            if (null != this.thread) {
                if (DEBUG) {
                    System.err.println("SharedResourceRunner.stop() - " + SharedResourceRunner.getThreadName());
                }
                SharedResourceRunner sharedResourceRunner2 = this;
                synchronized (sharedResourceRunner2) {
                    this.shouldRelease = true;
                    this.notifyAll();
                    while (this.running) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource getOrCreateShared(AbstractGraphicsDevice abstractGraphicsDevice) {
        Resource resource = null;
        if (null != abstractGraphicsDevice) {
            SharedResourceRunner sharedResourceRunner = this;
            synchronized (sharedResourceRunner) {
                this.start();
                String string = abstractGraphicsDevice.getConnection();
                resource = this.impl.mapGet(string);
                if (null == resource && !this.getDeviceTried(string)) {
                    this.addDeviceTried(string);
                    if (DEBUG) {
                        System.err.println("SharedResourceRunner.getOrCreateShared() " + string + ": trying - " + SharedResourceRunner.getThreadName());
                    }
                    if (this.impl.isDeviceSupported(string)) {
                        this.doAndWait(string, null);
                        resource = this.impl.mapGet(string);
                    }
                    if (DEBUG) {
                        System.err.println("SharedResourceRunner.getOrCreateShared() " + string + ": " + (null != resource ? "success" : "failed") + " - " + SharedResourceRunner.getThreadName());
                    }
                }
            }
        }
        return resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource releaseShared(AbstractGraphicsDevice abstractGraphicsDevice) {
        Resource resource = null;
        if (null != abstractGraphicsDevice) {
            SharedResourceRunner sharedResourceRunner = this;
            synchronized (sharedResourceRunner) {
                String string = abstractGraphicsDevice.getConnection();
                resource = this.impl.mapGet(string);
                if (null != resource) {
                    this.removeDeviceTried(string);
                    if (DEBUG) {
                        System.err.println("SharedResourceRunner.releaseShared() " + string + ": trying - " + SharedResourceRunner.getThreadName());
                    }
                    this.doAndWait(null, string);
                    if (DEBUG) {
                        System.err.println("SharedResourceRunner.releaseShared() " + string + ": done - " + SharedResourceRunner.getThreadName());
                    }
                }
            }
        }
        return resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void doAndWait(String string, String string2) {
        SharedResourceRunner sharedResourceRunner = this;
        synchronized (sharedResourceRunner) {
            String string3 = SharedResourceRunner.getThreadName();
            if (DEBUG) {
                System.err.println("SharedResourceRunner.doAndWait() START init: " + string + ", release: " + string2 + " - " + string3);
            }
            while (!this.ready && this.running) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (DEBUG) {
                System.err.println("SharedResourceRunner.doAndWait() set command: " + string + ", release: " + string2 + " - " + string3);
            }
            this.initConnection = string;
            this.releaseConnection = string2;
            this.notifyAll();
            while (this.running && (!this.ready || null != this.initConnection || null != this.releaseConnection)) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (DEBUG) {
                System.err.println("SharedResourceRunner.initializeAndWait END init: " + string + ", release: " + string2 + " - " + string3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        String string = SharedResourceRunner.getThreadName();
        if (DEBUG) {
            System.err.println("SharedResourceRunner.run(): STARTED - " + string);
        }
        SharedResourceRunner sharedResourceRunner = this;
        synchronized (sharedResourceRunner) {
            this.running = true;
            while (!this.shouldRelease) {
                block22: {
                    try {
                        this.ready = true;
                        if (DEBUG) {
                            System.err.println("SharedResourceRunner.run(): READY - " + string);
                        }
                        this.notifyAll();
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        this.shouldRelease = true;
                        if (!DEBUG) break block22;
                        System.err.println("SharedResourceRunner.run(): INTERRUPTED - " + string);
                        interruptedException.printStackTrace();
                    }
                }
                this.ready = false;
                if (!this.shouldRelease) {
                    Resource resource;
                    if (DEBUG) {
                        System.err.println("SharedResourceRunner.run(): WOKE UP for device connection init: " + this.initConnection + ", release: " + this.releaseConnection + " - " + string);
                    }
                    if (null != this.initConnection) {
                        if (DEBUG) {
                            System.err.println("SharedResourceRunner.run(): create Shared for: " + this.initConnection + " - " + string);
                        }
                        resource = null;
                        try {
                            resource = this.impl.createSharedResource(this.initConnection);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        if (null != resource) {
                            this.impl.mapPut(this.initConnection, resource);
                        }
                    }
                    if (null != this.releaseConnection) {
                        if (DEBUG) {
                            System.err.println("SharedResourceRunner.run(): release Shared for: " + this.releaseConnection + " - " + string);
                        }
                        if (null != (resource = this.impl.mapGet(this.releaseConnection))) {
                            try {
                                this.impl.releaseSharedResource(resource);
                                this.impl.mapPut(this.releaseConnection, null);
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                    }
                }
                this.initConnection = null;
                this.releaseConnection = null;
            }
            if (DEBUG) {
                System.err.println("SharedResourceRunner.run(): RELEASE START - " + string);
            }
            this.releaseSharedResources();
            if (DEBUG) {
                System.err.println("SharedResourceRunner.run(): RELEASE END - " + string);
            }
            this.shouldRelease = false;
            this.running = false;
            this.thread = null;
            this.notifyAll();
        }
    }

    private void releaseSharedResources() {
        this.devicesTried.clear();
        Collection<Resource> collection = this.impl.mapValues();
        Iterator<Resource> iterator = collection.iterator();
        while (iterator.hasNext()) {
            try {
                this.impl.releaseSharedResource(iterator.next());
            }
            catch (Throwable throwable) {
                System.err.println("Catched Exception on thread " + SharedResourceRunner.getThreadName());
                throwable.printStackTrace();
            }
        }
        this.impl.clear();
    }

    protected static String getThreadName() {
        return Thread.currentThread().getName();
    }

    public static interface Implementation {
        public boolean isDeviceSupported(String var1);

        public Resource createSharedResource(String var1);

        public void releaseSharedResource(Resource var1);

        public void clear();

        public Resource mapPut(String var1, Resource var2);

        public Resource mapGet(String var1);

        public Collection<Resource> mapValues();
    }

    public static interface Resource {
        public boolean isValid();

        public AbstractGraphicsDevice getDevice();

        public AbstractGraphicsScreen getScreen();

        public GLDrawableImpl getDrawable();

        public GLContextImpl getContext();

        public GLRendererQuirks getRendererQuirks();
    }
}

