/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.tasks;

import java.util.IllegalFormatException;
import java.util.List;
import org.fibs.geotag.data.ImageInfo;
import org.fibs.geotag.data.UpdateCityName;
import org.fibs.geotag.data.UpdateCountryName;
import org.fibs.geotag.data.UpdateLocationName;
import org.fibs.geotag.data.UpdateProvinceName;
import org.fibs.geotag.table.ImagesTableModel;
import org.fibs.geotag.tasks.UndoableBackgroundTask;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class CopyLocationNameTask
extends UndoableBackgroundTask<ImageInfo> {
    private static final I18n i18n = I18nFactory.getI18n(CopyLocationNameTask.class);
    private int currentProgress = 0;
    private ImagesTableModel imagesTableModel;
    private ImageInfo source;
    private List<ImageInfo> targets;

    public CopyLocationNameTask(String group, String name, ImagesTableModel imagesTableModel, ImageInfo source, List<ImageInfo> targets) {
        super(group, name);
        this.source = source;
        this.targets = targets;
        this.imagesTableModel = imagesTableModel;
    }

    @Override
    public int getCurrentProgress() {
        return this.currentProgress;
    }

    @Override
    public int getMaxProgress() {
        return this.targets.size();
    }

    @Override
    public int getMinProgress() {
        return 1;
    }

    @Override
    protected String doInBackground() throws Exception {
        for (ImageInfo target : this.targets) {
            if (this.interruptRequested()) break;
            ++this.currentProgress;
            try {
                this.setProgressMessage();
                new UpdateLocationName(target, this.source.getLocationName(), ImageInfo.DATA_SOURCE.COPIED);
                new UpdateProvinceName(target, this.source.getProvinceName(), ImageInfo.DATA_SOURCE.COPIED);
                new UpdateCountryName(target, this.source.getCountryName(), ImageInfo.DATA_SOURCE.COPIED);
                new UpdateCityName(target, this.source.getCityName(), ImageInfo.DATA_SOURCE.COPIED);
                this.publish(target);
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
        }
        String result = null;
        if (this.currentProgress == 1) {
            result = i18n.tr("Location name copied to one image.");
        } else {
            try {
                result = String.format(i18n.tr("Location name copied to %d images."), this.currentProgress);
            }
            catch (IllegalFormatException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    @Override
    protected void process(List<ImageInfo> images) {
        for (ImageInfo imageInfo : images) {
            int imageRow = this.imagesTableModel.getRow(imageInfo);
            this.imagesTableModel.fireTableRowsUpdated(imageRow, imageRow);
        }
    }
}

