/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.branding.desktop.reporter;

import com.getsentry.raven.Raven;
import com.getsentry.raven.RavenFactory;
import com.getsentry.raven.event.Event;
import com.getsentry.raven.event.EventBuilder;
import com.getsentry.raven.event.interfaces.ExceptionInterface;
import com.getsentry.raven.event.interfaces.SentryInterface;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.OperatingSystemMXBean;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.logging.Handler;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.gephi.branding.desktop.reporter.Report;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.modules.ModuleInfo;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.w3c.dom.Document;

public class ReportController {
    private static final String POST_URL = "https://d007fbbdeb6241b5b2c542a6bc548cf3:4a1af110df484e838da9243c1496ebe9@app.getsentry.com/85815";
    private final Raven raven = RavenFactory.ravenInstance((String)"https://d007fbbdeb6241b5b2c542a6bc548cf3:4a1af110df484e838da9243c1496ebe9@app.getsentry.com/85815");

    public void sendReport(final Report report) {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                ProgressHandle handle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(ReportController.class, (String)"ReportController.status.sending"));
                try {
                    handle.start();
                    ReportController.this.sendSentryReport(report);
                    handle.finish();
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(ReportController.class, (String)"ReportController.status.sent"), 1));
                    return;
                }
                catch (Exception e) {
                    Exceptions.printStackTrace((Throwable)e);
                    handle.finish();
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(ReportController.class, (String)"ReportController.status.failed"), 2));
                    return;
                }
            }
        }, "Exception Reporter");
        thread.start();
    }

    private void sendSentryReport(Report report) {
        EventBuilder eventBuilder = new EventBuilder().withMessage(report.getThrowable().getMessage()).withLevel(Event.Level.ERROR).withSentryInterface((SentryInterface)new ExceptionInterface(report.getThrowable())).withRelease(report.getVersion()).withServerName("Gephi Desktop").withExtra("OS", (Object)report.getOs()).withExtra("Heap memory usage", (Object)report.getHeapMemoryUsage()).withExtra("Non heap memory usage", (Object)report.getNonHeapMemoryUsage()).withExtra("Processors", (Object)report.getNumberOfProcessors()).withExtra("Screen devices", (Object)report.getScreenDevices()).withExtra("Screen size", (Object)report.getScreenSize()).withExtra("User description", (Object)report.getUserDescription()).withExtra("User email", (Object)report.getUserEmail()).withExtra("VM", (Object)report.getVm()).withExtra("OpenGL Vendor", (Object)report.getGlVendor()).withExtra("OpenGL Renderer", (Object)report.getGlRenderer()).withExtra("OpenGL Version", (Object)report.getGlVersion()).withExtra("Log", (Object)report.getLog());
        this.raven.sendEvent(eventBuilder);
    }

    public Document buildReportDocument(Report report) {
        this.logMessageLog(report);
        this.logVersion(report);
        this.logScreenSize(report);
        this.logCPU(report);
        this.logMemoryInfo(report);
        this.logJavaInfo(report);
        this.logGLInfo(report);
        return this.buildXMLDocument(report);
    }

    private Document buildXMLDocument(Report report) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            document.setXmlVersion("1.0");
            document.setXmlStandalone(true);
            report.writeXml(document);
            return document;
        }
        catch (Exception e) {
            Exceptions.printStackTrace((Throwable)e);
            return null;
        }
    }

    private void logScreenSize(Report report) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        report.setScreenSize(screenSize);
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        report.setScreenDevices(ge.getScreenDevices().length);
    }

    private void logCPU(Report report) {
        OperatingSystemMXBean bean = ManagementFactory.getOperatingSystemMXBean();
        report.setNumberOfProcessors(bean.getAvailableProcessors());
        String unknown = "unknown";
        String str = System.getProperty("os.name", unknown) + ", " + System.getProperty("os.version", unknown) + ", " + System.getProperty("os.arch", unknown);
        report.setOs(str);
    }

    private void logMemoryInfo(Report report) {
        MemoryMXBean bean = ManagementFactory.getMemoryMXBean();
        report.setHeapMemoryUsage(bean.getHeapMemoryUsage().toString());
        report.setNonHeapMemoryUsage(bean.getNonHeapMemoryUsage().toString());
    }

    private void logJavaInfo(Report report) {
        String str = System.getProperty("java.vm.name", "unknown") + ", " + System.getProperty("java.vm.version", "") + ", " + System.getProperty("java.runtime.name", "unknown") + ", " + System.getProperty("java.runtime.version", "");
        report.setVm(str);
    }

    private void logVersion(Report report) {
        String str = "";
        try {
            str = MessageFormat.format(NbBundle.getBundle((String)"org.netbeans.core.startup.Bundle").getString("currentVersion"), System.getProperty("netbeans.buildnumber"));
            report.setVersion(str);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
    }

    private void logGLInfo(Report report) {
        String output = report.getLog();
        try {
            String line;
            LineNumberReader lineNumberReader = new LineNumberReader(new StringReader(output));
            while ((line = lineNumberReader.readLine()) != null) {
                if (line.contains("GL_VENDOR:")) {
                    report.setGlVendor(line.replaceFirst(".*GL_VENDOR:", ""));
                    continue;
                }
                if (line.contains("GL_RENDERER:")) {
                    report.setGlRenderer(line.replaceFirst(".*GL_RENDERER:", ""));
                    continue;
                }
                if (!line.contains("GL_VERSION:")) continue;
                report.setGlVersion(line.replaceFirst(".*GL_VERSION:", ""));
                break;
            }
            lineNumberReader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void logModules(Report report) {
        for (ModuleInfo m : Lookup.getDefault().lookupAll(ModuleInfo.class)) {
            String moduleStr = "";
            SpecificationVersion specVersion = m.getSpecificationVersion();
            moduleStr = specVersion != null ? m.getCodeName() + " [" + specVersion.toString() + "]" : m.getCodeName();
            if (m.isEnabled()) {
                report.addEnabledModule(moduleStr);
                continue;
            }
            report.addDisabledModule(moduleStr);
        }
    }

    private void logMessageLog(Report report) {
        System.out.flush();
        String ud = System.getProperty("netbeans.user");
        if (ud == null || "memory".equals(ud)) {
            return;
        }
        Handler[] handlers = Logger.getLogger("").getHandlers();
        handlers[0].flush();
        File userDir = new File(ud);
        File directory = new File(new File(userDir, "var"), "log");
        File messagesLog = new File(directory, "messages.log");
        String log = "";
        try {
            byte[] buffer = new byte[(int)messagesLog.length()];
            BufferedInputStream f = new BufferedInputStream(new FileInputStream(messagesLog));
            f.read(buffer);
            log = new String(buffer);
        }
        catch (Exception exception) {
            // empty catch block
        }
        report.setLog(log);
    }
}

