/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.util;

import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;

public final class StaxHelper {
    private static final POILogger logger = POILogFactory.getLogger(StaxHelper.class);

    private StaxHelper() {
    }

    public static XMLInputFactory newXMLInputFactory() {
        XMLInputFactory factory = XMLInputFactory.newFactory();
        StaxHelper.trySetProperty(factory, "javax.xml.stream.isNamespaceAware", true);
        StaxHelper.trySetProperty(factory, "javax.xml.stream.isValidating", false);
        StaxHelper.trySetProperty(factory, "javax.xml.stream.supportDTD", false);
        StaxHelper.trySetProperty(factory, "javax.xml.stream.isSupportingExternalEntities", false);
        return factory;
    }

    public static XMLOutputFactory newXMLOutputFactory() {
        XMLOutputFactory factory = XMLOutputFactory.newFactory();
        StaxHelper.trySetProperty(factory, "javax.xml.stream.isRepairingNamespaces", true);
        return factory;
    }

    public static XMLEventFactory newXMLEventFactory() {
        return XMLEventFactory.newFactory();
    }

    private static void trySetProperty(XMLInputFactory factory, String feature, boolean flag) {
        try {
            factory.setProperty(feature, flag);
        }
        catch (Exception e) {
            logger.log(5, "StAX Property unsupported", feature, e);
        }
        catch (AbstractMethodError ame) {
            logger.log(5, "Cannot set StAX property because outdated StAX parser in classpath", feature, ame);
        }
    }

    private static void trySetProperty(XMLOutputFactory factory, String feature, boolean flag) {
        try {
            factory.setProperty(feature, flag);
        }
        catch (Exception e) {
            logger.log(5, "StAX Property unsupported", feature, e);
        }
        catch (AbstractMethodError ame) {
            logger.log(5, "Cannot set StAX property because outdated StAX parser in classpath", feature, ame);
        }
    }
}

