/*
 * Decompiled with CFR 0.152.
 */
package jogamp.nativewindow;

import com.jogamp.common.util.locks.LockFactory;
import com.jogamp.common.util.locks.RecursiveLock;
import com.jogamp.nativewindow.ToolkitLock;

public class GlobalToolkitLock
implements ToolkitLock {
    private static final RecursiveLock globalLock = LockFactory.createRecursiveLock();
    private static GlobalToolkitLock singleton = new GlobalToolkitLock();

    public static final GlobalToolkitLock getSingleton() {
        return singleton;
    }

    private GlobalToolkitLock() {
    }

    @Override
    public final void lock() {
        globalLock.lock();
        if (TRACE_LOCK) {
            System.err.println(Thread.currentThread() + " GlobalToolkitLock: lock() " + this.toStringImpl());
        }
    }

    @Override
    public final void unlock() {
        if (TRACE_LOCK) {
            System.err.println(Thread.currentThread() + " GlobalToolkitLock: unlock() " + this.toStringImpl());
        }
        globalLock.unlock();
    }

    @Override
    public final void validateLocked() throws RuntimeException {
        globalLock.validateLocked();
    }

    @Override
    public final void dispose() {
    }

    public String toString() {
        return "GlobalToolkitLock[" + this.toStringImpl() + "]";
    }

    private String toStringImpl() {
        return "obj 0x" + Integer.toHexString(this.hashCode()) + ", isOwner " + globalLock.isOwner(Thread.currentThread()) + ", " + globalLock.toString();
    }
}

