/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.timeline;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import org.gephi.timeline.api.TimelineChart;
import org.gephi.timeline.api.TimelineModel;
import org.gephi.utils.sparklines.SparklineGraph;
import org.gephi.utils.sparklines.SparklineParameters;

public class Sparkline {
    private double min;
    private double max;
    private SparklineParameters parameters;
    private TimelineChart chart;
    private BufferedImage image;

    public BufferedImage getImage(TimelineModel model, int width, int height) {
        double newMin = model.getCustomMin();
        double newMax = model.getCustomMax();
        TimelineChart newChart = model.getChart();
        if (this.chart == null || newMax != this.max || newMin != this.min || this.image.getWidth() != width || this.image.getHeight() != height || newChart != this.chart) {
            this.min = newMin;
            this.max = newMax;
            this.chart = newChart;
            if (this.chart != null) {
                double minX = this.chart.getMinX().doubleValue();
                double maxX = this.chart.getMaxX().doubleValue();
                int sparklineWidth = (int)((maxX - minX) / (this.max - this.min) * (double)width);
                this.parameters = new SparklineParameters(sparklineWidth, height);
                this.parameters.setTransparentBackground(true);
                this.parameters.setDrawArea(true);
                this.image = new BufferedImage(width, height, 2);
                int sparklineX = (int)((minX - this.min) / (this.max - this.min) * (double)width);
                BufferedImage sparklineImage = this.draw();
                Graphics g = this.image.getGraphics();
                g.drawImage(sparklineImage, sparklineX, 0, null);
                g.dispose();
            } else {
                return null;
            }
        }
        return this.image;
    }

    private BufferedImage draw() {
        BufferedImage img = SparklineGraph.draw((Number[])this.chart.getX(), (Number[])this.chart.getY(), (Number)this.chart.getMinY(), (Number)this.chart.getMaxY(), (SparklineParameters)this.parameters);
        return img;
    }
}

