/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.layout.plugin.openord;

import java.util.logging.Logger;
import org.gephi.layout.plugin.openord.Params;
import org.gephi.layout.plugin.openord.Worker;
import org.gephi.utils.progress.Progress;
import org.gephi.utils.progress.ProgressTicket;

public class Control {
    private int STAGE;
    private int iterations;
    private float temperature;
    private float attraction;
    private float dampingMult;
    private float minEdges;
    private float cutEnd;
    private float cutLengthEnd;
    private float cutOffLength;
    private float cutRate;
    private boolean fineDensity;
    private float edgeCut;
    private float realParm;
    private long startTime;
    private long stopTime;
    private int numNodes;
    private float highestSimilarity;
    private int realIterations;
    private boolean realFixed;
    private int totIterations;
    private int totExpectedIterations;
    private long totalTime;
    private Params params;
    private ProgressTicket progressTicket;

    public void initParams(Params params, int totalIterations) {
        float cutLengthStart;
        this.params = params;
        this.STAGE = 0;
        this.iterations = 0;
        this.initStage(params.getInitial());
        this.minEdges = 20.0f;
        this.fineDensity = false;
        this.cutEnd = this.cutLengthEnd = 40000.0f * (1.0f - this.edgeCut);
        if (this.cutLengthEnd <= 1.0f) {
            this.cutLengthEnd = 1.0f;
        }
        this.cutOffLength = cutLengthStart = 4.0f * this.cutLengthEnd;
        this.cutRate = (cutLengthStart - this.cutLengthEnd) / 400.0f;
        this.totExpectedIterations = totalIterations;
        int fullCompIters = this.totExpectedIterations + 3;
        this.realIterations = this.realParm < 0.0f ? (int)this.realParm : (this.realParm == 1.0f ? fullCompIters + params.getSimmer().getIterationsTotal(totalIterations) + 100 : (int)(this.realParm * (float)fullCompIters));
        Logger.getLogger("").info("Real iterations " + this.realIterations);
        this.realFixed = this.realIterations > 0;
        Progress.switchToDeterminate((ProgressTicket)this.progressTicket, (int)this.totExpectedIterations);
    }

    private void initStage(Params.Stage stage) {
        this.temperature = stage.getTemperature();
        this.attraction = stage.getAttraction();
        this.dampingMult = stage.getDampingMult();
    }

    public void initWorker(Worker worker) {
        worker.setAttraction(this.attraction);
        worker.setCutOffLength(this.cutOffLength);
        worker.setDampingMult(this.dampingMult);
        worker.setMinEdges(this.minEdges);
        worker.setSTAGE(this.STAGE);
        worker.setTemperature(this.temperature);
        worker.setFineDensity(this.fineDensity);
    }

    public boolean udpateStage(float totEnergy) {
        long timeElapsed;
        boolean MIN = true;
        ++this.totIterations;
        if (this.totIterations >= this.realIterations) {
            this.realFixed = false;
        }
        Progress.progress((ProgressTicket)this.progressTicket, (int)this.totIterations);
        if (this.STAGE == 0) {
            if (this.iterations == 0) {
                this.startTime = System.currentTimeMillis() / 1000L;
                Logger.getLogger("").info("Entering liquid stage...");
            }
            if (this.iterations < this.params.getLiquid().getIterationsTotal(this.totExpectedIterations)) {
                this.initStage(this.params.getLiquid());
                ++this.iterations;
            } else {
                this.stopTime = System.currentTimeMillis() / 1000L;
                timeElapsed = this.stopTime - this.startTime;
                this.totalTime += timeElapsed;
                this.initStage(this.params.getExpansion());
                this.iterations = 0;
                Logger.getLogger("").info(String.format("Liquid stage completed in %d seconds, total energy = %f", timeElapsed, Float.valueOf(totEnergy)));
                this.STAGE = 1;
                this.startTime = System.currentTimeMillis() / 1000L;
                Logger.getLogger("").info("Entering expansion stage...");
            }
        }
        if (this.STAGE == 1) {
            if (this.iterations < this.params.getExpansion().getIterationsTotal(this.totExpectedIterations)) {
                if (this.attraction > 1.0f) {
                    this.attraction = (float)((double)this.attraction - 0.05);
                }
                if (this.minEdges > 12.0f) {
                    this.minEdges = (float)((double)this.minEdges - 0.05);
                }
                this.cutOffLength -= this.cutRate;
                if ((double)this.dampingMult > 0.1) {
                    this.dampingMult = (float)((double)this.dampingMult - 0.005);
                }
                ++this.iterations;
            } else {
                this.stopTime = System.currentTimeMillis() / 1000L;
                timeElapsed = this.stopTime - this.startTime;
                this.totalTime += timeElapsed;
                Logger.getLogger("").info(String.format("Expansion stage completed in %d seconds, total energy = %f", timeElapsed, Float.valueOf(totEnergy)));
                this.STAGE = 2;
                this.minEdges = 12.0f;
                this.initStage(this.params.getCooldown());
                this.iterations = 0;
                this.startTime = System.currentTimeMillis() / 1000L;
                Logger.getLogger("").info("Entering cool-down stage...");
            }
        } else if (this.STAGE == 2) {
            if (this.iterations < this.params.getCooldown().getIterationsTotal(this.totExpectedIterations)) {
                if (this.temperature > 50.0f) {
                    this.temperature -= 10.0f;
                }
                if (this.cutOffLength > this.cutLengthEnd) {
                    this.cutLengthEnd -= this.cutRate * 2.0f;
                }
                if (this.minEdges > (float)MIN) {
                    this.minEdges = (float)((double)this.minEdges - 0.2);
                }
                ++this.iterations;
            } else {
                this.stopTime = System.currentTimeMillis() / 1000L;
                timeElapsed = this.stopTime - this.startTime;
                this.totalTime += timeElapsed;
                this.cutOffLength = this.cutLengthEnd;
                this.minEdges = (float)MIN;
                Logger.getLogger("").info(String.format("Cool-down stage completed in %d seconds, total energy = %f", timeElapsed, Float.valueOf(totEnergy)));
                this.STAGE = 3;
                this.iterations = 0;
                this.initStage(this.params.getCrunch());
                this.startTime = System.currentTimeMillis() / 1000L;
                Logger.getLogger("").info("Entering crunch stage...");
            }
        } else if (this.STAGE == 3) {
            if (this.iterations < this.params.getCrunch().getIterationsTotal(this.totExpectedIterations)) {
                ++this.iterations;
            } else {
                this.stopTime = System.currentTimeMillis() / 1000L;
                timeElapsed = this.stopTime - this.startTime;
                this.totalTime += timeElapsed;
                this.iterations = 0;
                this.initStage(this.params.getSimmer());
                this.minEdges = 99.0f;
                this.fineDensity = true;
                Logger.getLogger("").info(String.format("Crunch stage completed in %d seconds, total energy = %f", timeElapsed, Float.valueOf(totEnergy)));
                this.STAGE = 5;
                this.startTime = System.currentTimeMillis() / 1000L;
                Logger.getLogger("").info("Entering simmer stage...");
            }
        } else if (this.STAGE == 5) {
            if (this.iterations < this.params.getSimmer().getIterationsTotal(this.totExpectedIterations)) {
                if (this.temperature > 50.0f) {
                    this.temperature -= 2.0f;
                }
                ++this.iterations;
            } else {
                this.stopTime = System.currentTimeMillis() / 1000L;
                timeElapsed = this.stopTime - this.startTime;
                this.totalTime += timeElapsed;
                Logger.getLogger("").info(String.format("Simmer stage completed in %d seconds, total energy = %f", timeElapsed, Float.valueOf(totEnergy)));
                this.STAGE = 6;
                Logger.getLogger("").info(String.format("Layout completed in %d seconds with %d iterations", this.totalTime, this.totIterations));
            }
        } else if (this.STAGE == 6) {
            return false;
        }
        return true;
    }

    public boolean isRealFixed() {
        return this.realFixed;
    }

    public float getHighestSimilarity() {
        return this.highestSimilarity;
    }

    public void setHighestSimilarity(float highestSimilarity) {
        this.highestSimilarity = highestSimilarity;
    }

    public void setNumNodes(int numNodes) {
        this.numNodes = numNodes;
    }

    public void setEdgeCut(float edgeCut) {
        this.edgeCut = edgeCut;
    }

    public void setRealParm(float realParm) {
        this.realParm = realParm;
    }

    public void setProgressTicket(ProgressTicket progressTicket) {
        this.progressTicket = progressTicket;
    }
}

