/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer;

import org.gradle.api.Transformer;
import org.gradle.internal.event.ListenerNotificationException;
import org.gradle.tooling.BuildCancelledException;
import org.gradle.tooling.BuildException;
import org.gradle.tooling.GradleConnectionException;
import org.gradle.tooling.ListenerFailedException;
import org.gradle.tooling.TestExecutionException;
import org.gradle.tooling.exceptions.UnsupportedBuildArgumentException;
import org.gradle.tooling.exceptions.UnsupportedOperationConfigurationException;
import org.gradle.tooling.internal.protocol.BuildExceptionVersion1;
import org.gradle.tooling.internal.protocol.InternalBuildCancelledException;
import org.gradle.tooling.internal.protocol.exceptions.InternalUnsupportedBuildArgumentException;
import org.gradle.tooling.internal.protocol.test.InternalTestExecutionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExceptionTransformer
implements Transformer<GradleConnectionException, Throwable> {
    private final Transformer<String, Throwable> connectionFailureProvider;

    public ExceptionTransformer(Transformer<String, Throwable> connectionFailureProvider) {
        this.connectionFailureProvider = connectionFailureProvider;
    }

    public GradleConnectionException transform(Throwable failure) {
        if (failure instanceof InternalUnsupportedBuildArgumentException) {
            return new UnsupportedBuildArgumentException(this.connectionFailureMessage(failure) + "\n" + failure.getMessage(), failure);
        }
        if (failure instanceof UnsupportedOperationConfigurationException) {
            return new UnsupportedOperationConfigurationException(this.connectionFailureMessage(failure) + "\n" + failure.getMessage(), failure.getCause());
        }
        if (failure instanceof GradleConnectionException) {
            return (GradleConnectionException)failure;
        }
        if (failure instanceof InternalBuildCancelledException) {
            return new BuildCancelledException(this.connectionFailureMessage(failure), failure.getCause());
        }
        if (failure instanceof InternalTestExecutionException) {
            return new TestExecutionException(this.connectionFailureMessage(failure), failure.getCause());
        }
        if (failure instanceof BuildExceptionVersion1) {
            return new BuildException(this.connectionFailureMessage(failure), failure.getCause());
        }
        if (failure instanceof ListenerNotificationException) {
            return new ListenerFailedException(this.connectionFailureMessage(failure), ((ListenerNotificationException)failure).getCauses());
        }
        return new GradleConnectionException(this.connectionFailureMessage(failure), failure);
    }

    private String connectionFailureMessage(Throwable failure) {
        return (String)this.connectionFailureProvider.transform((Object)failure);
    }
}

