/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.gradle.api.internal.WithEstimatedSize;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetIterator<T>
implements Iterator<T> {
    private final Set<T> seen;
    private final Iterator<T> delegate;
    private T next;

    public static <T> Iterator<T> of(Collection<T> collection) {
        if (collection instanceof Set) {
            return collection.iterator();
        }
        return SetIterator.wrap(collection.iterator());
    }

    public static <T> Iterator<T> wrap(Iterator<T> delegate) {
        if (delegate instanceof SetIterator) {
            return delegate;
        }
        return new SetIterator<T>(delegate);
    }

    private SetIterator(Iterator<T> delegate) {
        this.delegate = delegate;
        this.seen = delegate instanceof WithEstimatedSize ? Sets.newHashSetWithExpectedSize((int)((WithEstimatedSize)((Object)delegate)).estimatedSize()) : Sets.newHashSet();
        this.fetchNext();
    }

    private void fetchNext() {
        while (this.delegate.hasNext()) {
            this.next = this.delegate.next();
            if (!this.seen.add(this.next)) continue;
            return;
        }
        this.next = null;
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T next() {
        try {
            T t = this.next;
            return t;
        }
        finally {
            this.fetchNext();
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

