/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.rules;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.annotation.Nullable;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.changedetection.rules.DescriptiveChange;
import org.gradle.api.internal.changedetection.rules.TaskStateChange;
import org.gradle.api.internal.changedetection.rules.TaskStateChanges;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshot;
import org.gradle.api.internal.changedetection.state.TaskExecution;
import org.gradle.util.ChangeListener;
import org.gradle.util.DiffUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractNamedFileSnapshotTaskStateChanges
implements TaskStateChanges {
    protected final TaskExecution previous;
    protected final TaskExecution current;
    private final TaskInternal task;
    private final String title;

    protected AbstractNamedFileSnapshotTaskStateChanges(TaskExecution previous, TaskExecution current, TaskInternal task, String title) {
        this.previous = previous;
        this.current = current;
        this.task = task;
        this.title = title;
    }

    @Nullable
    private ImmutableSortedMap<String, FileCollectionSnapshot> getPrevious() {
        return this.previous == null ? null : this.getSnapshot(this.previous);
    }

    private ImmutableSortedMap<String, FileCollectionSnapshot> getCurrent() {
        return this.getSnapshot(this.current);
    }

    protected abstract ImmutableSortedMap<String, FileCollectionSnapshot> getSnapshot(TaskExecution var1);

    protected Iterator<TaskStateChange> getFileChanges(final boolean includeAdded) {
        if (this.getPrevious() == null) {
            return Iterators.singletonIterator((Object)new DescriptiveChange(this.title + " file history is not available.", new Object[0]));
        }
        final LinkedList propertyChanges = Lists.newLinkedList();
        DiffUtil.diff(this.getCurrent().keySet(), this.getPrevious().keySet(), new ChangeListener<String>(){

            @Override
            public void added(String element) {
                propertyChanges.add(new DescriptiveChange("%s property '%s' has been added for %s", AbstractNamedFileSnapshotTaskStateChanges.this.title, element, AbstractNamedFileSnapshotTaskStateChanges.this.task));
            }

            @Override
            public void removed(String element) {
                propertyChanges.add(new DescriptiveChange("%s property '%s' has been removed for %s", AbstractNamedFileSnapshotTaskStateChanges.this.title, element, AbstractNamedFileSnapshotTaskStateChanges.this.task));
            }

            @Override
            public void changed(String element) {
                throw new AssertionError();
            }
        });
        if (!propertyChanges.isEmpty()) {
            return propertyChanges.iterator();
        }
        return Iterators.concat(Iterables.transform((Iterable)this.getCurrent().entrySet(), (Function)new Function<Map.Entry<String, FileCollectionSnapshot>, Iterator<TaskStateChange>>(){

            public Iterator<TaskStateChange> apply(Map.Entry<String, FileCollectionSnapshot> entry) {
                String propertyName = entry.getKey();
                FileCollectionSnapshot currentSnapshot = entry.getValue();
                FileCollectionSnapshot previousSnapshot = (FileCollectionSnapshot)AbstractNamedFileSnapshotTaskStateChanges.this.getPrevious().get((Object)propertyName);
                String propertyTitle = AbstractNamedFileSnapshotTaskStateChanges.this.title + " property '" + propertyName + "'";
                return currentSnapshot.iterateContentChangesSince(previousSnapshot, propertyTitle, includeAdded);
            }
        }).iterator());
    }
}

