/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.resources;

import com.google.common.io.CharSource;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.Set;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.resources.internal.TextResourceInternal;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.internal.resource.ResourceExceptions;

public class CharSourceBackedTextResource
implements TextResourceInternal {
    private final String displayName;
    private final CharSource charSource;

    public CharSourceBackedTextResource(String displayName, CharSource charSource) {
        this.displayName = displayName;
        this.charSource = charSource;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String toString() {
        return this.getDisplayName();
    }

    public String asString() {
        try {
            return this.charSource.read();
        }
        catch (IOException e) {
            throw ResourceExceptions.readFailed((String)this.displayName, (Throwable)e);
        }
    }

    public Reader asReader() {
        try {
            return this.charSource.openStream();
        }
        catch (IOException e) {
            throw ResourceExceptions.readFailed((String)this.displayName, (Throwable)e);
        }
    }

    public File asFile(String charset) {
        throw new UnsupportedOperationException("Cannot create file for char source " + this.charSource);
    }

    public File asFile() {
        throw new UnsupportedOperationException("Cannot create file for char source " + this.charSource);
    }

    public Object getInputProperties() {
        return null;
    }

    public FileCollection getInputFiles() {
        return null;
    }

    public TaskDependency getBuildDependencies() {
        return new TaskDependency(){

            public Set<? extends Task> getDependencies(Task task) {
                return Collections.emptySet();
            }
        };
    }
}

