/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider;

import org.gradle.StartParameter;
import org.gradle.api.internal.StartParameterInternal;
import org.gradle.initialization.BuildRequestContext;
import org.gradle.internal.invocation.BuildAction;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.launcher.exec.BuildActionParameters;
import org.gradle.launcher.exec.BuildExecuter;

public class StartParamsValidatingActionExecuter
implements BuildExecuter {
    private final BuildExecuter delegate;

    public StartParamsValidatingActionExecuter(BuildExecuter delegate) {
        this.delegate = delegate;
    }

    public Object execute(BuildAction action, BuildRequestContext requestContext, BuildActionParameters actionParameters, ServiceRegistry contextServices) {
        StartParameter startParameter = action.getStartParameter();
        if (startParameter.getBuildFile() != null && !startParameter.getBuildFile().isFile()) {
            if (!startParameter.getBuildFile().exists()) {
                throw new IllegalArgumentException(String.format("The specified build file '%s' does not exist.", startParameter.getBuildFile()));
            }
            throw new IllegalArgumentException(String.format("The specified build file '%s' is not a file.", startParameter.getBuildFile()));
        }
        if (startParameter.getProjectDir() != null && !startParameter.getProjectDir().isDirectory()) {
            if (!startParameter.getProjectDir().exists()) {
                throw new IllegalArgumentException(String.format("The specified project directory '%s' does not exist.", startParameter.getProjectDir()));
            }
            throw new IllegalArgumentException(String.format("The specified project directory '%s' is not a directory.", startParameter.getProjectDir()));
        }
        if (startParameter.getSettingsFile() != null && !startParameter.getSettingsFile().isFile()) {
            if (!startParameter.getSettingsFile().exists()) {
                throw new IllegalArgumentException(String.format("The specified settings file '%s' does not exist.", startParameter.getSettingsFile()));
            }
            throw new IllegalArgumentException(String.format("The specified settings file '%s' is not a file.", startParameter.getSettingsFile()));
        }
        if (startParameter instanceof StartParameterInternal) {
            ((StartParameterInternal)StartParameterInternal.class.cast(startParameter)).checkDeprecation();
        }
        return this.delegate.execute(action, requestContext, actionParameters, contextServices);
    }
}

