/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal.filelock;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.gradle.cache.internal.filelock.LockInfo;

public class LockInfoSerializer {
    public static final int INFORMATION_REGION_DESCR_CHUNK_LIMIT = 340;

    public byte getVersion() {
        return 3;
    }

    public void write(DataOutput dataOutput, LockInfo lockInfo) throws IOException {
        dataOutput.writeInt(lockInfo.port);
        dataOutput.writeLong(lockInfo.lockId);
        dataOutput.writeUTF(this.trimIfNecessary(lockInfo.pid));
        dataOutput.writeUTF(this.trimIfNecessary(lockInfo.operation));
    }

    public LockInfo read(DataInput dataInput) throws IOException {
        LockInfo out = new LockInfo();
        out.port = dataInput.readInt();
        out.lockId = dataInput.readLong();
        out.pid = dataInput.readUTF();
        out.operation = dataInput.readUTF();
        return out;
    }

    private String trimIfNecessary(String inputString) {
        if (inputString.length() > 340) {
            return inputString.substring(0, 340);
        }
        return inputString;
    }
}

