/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.ivy.tasks;

import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.Incubating;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.repositories.IvyArtifactRepository;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.artifacts.repositories.PublicationAwareRepository;
import org.gradle.api.publish.internal.PublishOperation;
import org.gradle.api.publish.ivy.IvyPublication;
import org.gradle.api.publish.ivy.internal.publication.IvyPublicationInternal;
import org.gradle.api.publish.ivy.internal.publisher.IvyNormalizedPublication;
import org.gradle.api.publish.ivy.internal.publisher.IvyPublisher;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskAction;
import org.gradle.internal.Cast;

@Incubating
public class PublishToIvyRepository
extends DefaultTask {
    private IvyPublicationInternal publication;
    private IvyArtifactRepository repository;

    public PublishToIvyRepository() {
        this.getInputs().files(new Object[]{new Callable<FileCollection>(){

            @Override
            public FileCollection call() throws Exception {
                IvyPublicationInternal publicationInternal = PublishToIvyRepository.this.getPublicationInternal();
                return publicationInternal == null ? null : publicationInternal.getPublishableFiles();
            }
        }}).withPropertyName("publication.publishableFiles");
    }

    @Internal
    public IvyPublication getPublication() {
        return this.publication;
    }

    public void setPublication(IvyPublication publication) {
        this.publication = PublishToIvyRepository.toPublicationInternal(publication);
    }

    private IvyPublicationInternal getPublicationInternal() {
        return PublishToIvyRepository.toPublicationInternal(this.getPublication());
    }

    private static IvyPublicationInternal toPublicationInternal(IvyPublication publication) {
        if (publication == null) {
            return null;
        }
        if (publication instanceof IvyPublicationInternal) {
            return (IvyPublicationInternal)publication;
        }
        throw new InvalidUserDataException(String.format("publication objects must implement the '%s' interface, implementation '%s' does not", IvyPublicationInternal.class.getName(), publication.getClass().getName()));
    }

    @Internal
    public IvyArtifactRepository getRepository() {
        return this.repository;
    }

    public void setRepository(IvyArtifactRepository repository) {
        this.repository = repository;
    }

    @TaskAction
    public void publish() {
        IvyPublicationInternal publicationInternal = this.getPublicationInternal();
        if (publicationInternal == null) {
            throw new InvalidUserDataException("The 'publication' property is required");
        }
        IvyArtifactRepository repository = this.getRepository();
        if (repository == null) {
            throw new InvalidUserDataException("The 'repository' property is required");
        }
        this.doPublish(publicationInternal, repository);
    }

    @Inject
    protected IvyPublisher getIvyPublisher() {
        throw new UnsupportedOperationException();
    }

    private void doPublish(final IvyPublicationInternal publication, final IvyArtifactRepository repository) {
        new PublishOperation(publication, repository.getName()){

            protected void publish() throws Exception {
                IvyNormalizedPublication normalizedPublication = publication.asNormalisedPublication();
                IvyPublisher publisher = PublishToIvyRepository.this.getIvyPublisher();
                publisher.publish(normalizedPublication, (PublicationAwareRepository)Cast.cast(PublicationAwareRepository.class, (Object)repository));
            }
        }.run();
    }
}

