/*
 * Decompiled with CFR 0.152.
 */
package net.rubygrapefruit.platform.internal;

import java.io.File;
import java.util.List;
import net.rubygrapefruit.platform.DirEntry;
import net.rubygrapefruit.platform.FileInfo;
import net.rubygrapefruit.platform.NativeException;
import net.rubygrapefruit.platform.WindowsFileInfo;
import net.rubygrapefruit.platform.WindowsFiles;
import net.rubygrapefruit.platform.internal.AbstractFiles;
import net.rubygrapefruit.platform.internal.FunctionResult;
import net.rubygrapefruit.platform.internal.WindowsDirList;
import net.rubygrapefruit.platform.internal.WindowsFileStat;
import net.rubygrapefruit.platform.internal.jni.WindowsFileFunctions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultWindowsFiles
extends AbstractFiles
implements WindowsFiles {
    @Override
    public WindowsFileInfo stat(File file) throws NativeException {
        FunctionResult result2 = new FunctionResult();
        WindowsFileStat stat = new WindowsFileStat(file.getPath());
        WindowsFileFunctions.stat(file.getPath(), stat, result2);
        if (result2.isFailed()) {
            throw new NativeException(String.format("Could not get file details of %s: %s", file, result2.getMessage()));
        }
        return stat;
    }

    @Override
    public FileInfo stat(File file, boolean linkTarget) throws NativeException {
        return this.stat(file);
    }

    @Override
    public List<? extends DirEntry> listDir(File dir) throws NativeException {
        FunctionResult result2 = new FunctionResult();
        WindowsDirList dirList = new WindowsDirList();
        WindowsFileFunctions.readdir(dir.getPath() + "\\*", dirList, result2);
        if (result2.isFailed()) {
            throw this.listDirFailure(dir, result2);
        }
        return dirList.files;
    }

    @Override
    public List<? extends DirEntry> listDir(File dir, boolean linkTarget) throws NativeException {
        return this.listDir(dir);
    }
}

