/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.Language;
import org.jetbrains.kotlin.com.intellij.openapi.editor.Document;
import org.jetbrains.kotlin.com.intellij.openapi.fileEditor.FileDocumentManager;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.FileType;
import org.jetbrains.kotlin.com.intellij.openapi.util.UserDataHolderBase;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.FileViewProvider;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiReference;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiManagerEx;
import org.jetbrains.kotlin.com.intellij.psi.impl.SharedPsiElementImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.DummyHolder;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.PsiFileImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafElement;
import org.jetbrains.kotlin.com.intellij.testFramework.LightVirtualFile;
import org.jetbrains.kotlin.com.intellij.util.LocalTimeCounter;

public class DummyHolderViewProvider
extends UserDataHolderBase
implements FileViewProvider {
    private DummyHolder myHolder;
    private final PsiManager myManager;
    private final long myModificationStamp;
    private final LightVirtualFile myLightVirtualFile;

    public DummyHolderViewProvider(@NotNull PsiManager manager) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/kotlin/com/intellij/psi/DummyHolderViewProvider", "<init>"));
        }
        this.myLightVirtualFile = new LightVirtualFile("DummyHolder");
        this.myManager = manager;
        this.myModificationStamp = LocalTimeCounter.currentTime();
    }

    @Override
    @NotNull
    public PsiManager getManager() {
        PsiManager psiManager = this.myManager;
        if (psiManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/DummyHolderViewProvider", "getManager"));
        }
        return psiManager;
    }

    @Override
    @Nullable
    public Document getDocument() {
        return FileDocumentManager.getInstance().getDocument(this.getVirtualFile());
    }

    @Override
    @NotNull
    public CharSequence getContents() {
        String string = this.myHolder != null ? this.myHolder.getNode().getText() : "";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/DummyHolderViewProvider", "getContents"));
        }
        return string;
    }

    @Override
    @NotNull
    public VirtualFile getVirtualFile() {
        LightVirtualFile lightVirtualFile = this.myLightVirtualFile;
        if (lightVirtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/DummyHolderViewProvider", "getVirtualFile"));
        }
        return lightVirtualFile;
    }

    @Override
    @NotNull
    public Language getBaseLanguage() {
        Language language = this.myHolder.getLanguage();
        if (language == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/DummyHolderViewProvider", "getBaseLanguage"));
        }
        return language;
    }

    @Override
    @NotNull
    public Set<Language> getLanguages() {
        Set<Language> set = Collections.singleton(this.getBaseLanguage());
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/DummyHolderViewProvider", "getLanguages"));
        }
        return set;
    }

    @Override
    public PsiFile getPsi(@NotNull Language target) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/kotlin/com/intellij/psi/DummyHolderViewProvider", "getPsi"));
        }
        ((PsiManagerEx)this.myManager).getFileManager().setViewProvider(this.getVirtualFile(), this);
        return target == this.getBaseLanguage() ? this.myHolder : null;
    }

    @Override
    @NotNull
    public List<PsiFile> getAllFiles() {
        List<PsiFile> list2 = Collections.singletonList(this.getPsi(this.getBaseLanguage()));
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/DummyHolderViewProvider", "getAllFiles"));
        }
        return list2;
    }

    @Override
    public void beforeContentsSynchronized() {
    }

    @Override
    public void contentsSynchronized() {
    }

    @Override
    public boolean isEventSystemEnabled() {
        return false;
    }

    @Override
    public boolean isPhysical() {
        return false;
    }

    @Override
    public long getModificationStamp() {
        return this.myModificationStamp;
    }

    @Override
    public boolean supportsIncrementalReparse(@NotNull Language rootLanguage) {
        if (rootLanguage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootLanguage", "org/jetbrains/kotlin/com/intellij/psi/DummyHolderViewProvider", "supportsIncrementalReparse"));
        }
        return true;
    }

    @Override
    public void rootChanged(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "org/jetbrains/kotlin/com/intellij/psi/DummyHolderViewProvider", "rootChanged"));
        }
    }

    public void setDummyHolder(@NotNull DummyHolder dummyHolder) {
        if (dummyHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dummyHolder", "org/jetbrains/kotlin/com/intellij/psi/DummyHolderViewProvider", "setDummyHolder"));
        }
        this.myHolder = dummyHolder;
        this.myLightVirtualFile.setFileType(dummyHolder.getFileType());
    }

    @Override
    public FileViewProvider clone() {
        throw new RuntimeException("Clone is not supported for DummyHolderProviders. Use DummyHolder clone directly.");
    }

    @Override
    public PsiReference findReferenceAt(int offset2) {
        return SharedPsiElementImplUtil.findReferenceAt(this.getPsi(this.getBaseLanguage()), offset2);
    }

    @Override
    @Nullable
    public PsiElement findElementAt(int offset2, @NotNull Language language) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "org/jetbrains/kotlin/com/intellij/psi/DummyHolderViewProvider", "findElementAt"));
        }
        return language == this.getBaseLanguage() ? this.findElementAt(offset2) : null;
    }

    @Override
    public PsiElement findElementAt(int offset2, @NotNull Class<? extends Language> lang) {
        if (lang == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lang", "org/jetbrains/kotlin/com/intellij/psi/DummyHolderViewProvider", "findElementAt"));
        }
        if (!lang.isAssignableFrom(this.getBaseLanguage().getClass())) {
            return null;
        }
        return this.findElementAt(offset2);
    }

    @Override
    public PsiReference findReferenceAt(int offsetInElement, @NotNull Language language) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "org/jetbrains/kotlin/com/intellij/psi/DummyHolderViewProvider", "findReferenceAt"));
        }
        return language == this.getBaseLanguage() ? this.findReferenceAt(offsetInElement) : null;
    }

    @Override
    @NotNull
    public FileViewProvider createCopy(@NotNull VirtualFile copy) {
        if (copy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "copy", "org/jetbrains/kotlin/com/intellij/psi/DummyHolderViewProvider", "createCopy"));
        }
        throw new RuntimeException("Clone is not supported for DummyHolderProviders. Use DummyHolder clone directly.");
    }

    @Override
    @NotNull
    public PsiFile getStubBindingRoot() {
        PsiFile psiFile = this.getPsi(this.getBaseLanguage());
        if (psiFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/DummyHolderViewProvider", "getStubBindingRoot"));
        }
        return psiFile;
    }

    @Override
    @NotNull
    public FileType getFileType() {
        FileType fileType = this.myLightVirtualFile.getFileType();
        if (fileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/DummyHolderViewProvider", "getFileType"));
        }
        return fileType;
    }

    @Override
    public PsiElement findElementAt(int offset2) {
        LeafElement element = ((PsiFileImpl)this.getPsi(this.getBaseLanguage())).calcTreeElement().findLeafElementAt(offset2);
        return element != null ? element.getPsi() : null;
    }
}

