/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.jdom;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import org.xml.sax.SAXException;

public class JDOMException
extends Exception {
    private Throwable cause;

    public JDOMException() {
        super("Error occurred in JDOM application.");
    }

    public JDOMException(String message) {
        super(message);
    }

    public JDOMException(String message, Throwable cause) {
        super(message);
        this.cause = cause;
    }

    @Override
    public Throwable initCause(Throwable cause) {
        this.cause = cause;
        return this;
    }

    @Override
    public String getMessage() {
        Throwable child;
        String msg = super.getMessage();
        Throwable parent2 = this;
        while ((child = JDOMException.getNestedException(parent2)) != null) {
            Exception grandchild;
            String msg2 = child.getMessage();
            if (child instanceof SAXException && (grandchild = ((SAXException)child).getException()) != null && msg2 != null && msg2.equals(grandchild.getMessage())) {
                msg2 = null;
            }
            if (msg2 != null) {
                msg = msg != null ? msg + ": " + msg2 : msg2;
            }
            if (child instanceof JDOMException) break;
            parent2 = child;
        }
        return msg;
    }

    @Override
    public void printStackTrace() {
        Throwable child;
        super.printStackTrace();
        Throwable parent2 = this;
        while ((child = JDOMException.getNestedException(parent2)) != null) {
            System.err.print("Caused by: ");
            child.printStackTrace();
            if (child instanceof JDOMException) break;
            parent2 = child;
        }
    }

    @Override
    public void printStackTrace(PrintStream s) {
        Throwable child;
        super.printStackTrace(s);
        Throwable parent2 = this;
        while ((child = JDOMException.getNestedException(parent2)) != null) {
            s.print("Caused by: ");
            child.printStackTrace(s);
            if (child instanceof JDOMException) break;
            parent2 = child;
        }
    }

    @Override
    public void printStackTrace(PrintWriter w) {
        Throwable child;
        super.printStackTrace(w);
        Throwable parent2 = this;
        while ((child = JDOMException.getNestedException(parent2)) != null) {
            w.print("Caused by: ");
            child.printStackTrace(w);
            if (child instanceof JDOMException) break;
            parent2 = child;
        }
    }

    @Override
    public Throwable getCause() {
        return this.cause;
    }

    private static Throwable getNestedException(Throwable parent2) {
        if (parent2 instanceof JDOMException) {
            return ((JDOMException)parent2).getCause();
        }
        if (parent2 instanceof SAXException) {
            return ((SAXException)parent2).getException();
        }
        if (parent2 instanceof SQLException) {
            return ((SQLException)parent2).getNextException();
        }
        if (parent2 instanceof InvocationTargetException) {
            return ((InvocationTargetException)parent2).getTargetException();
        }
        if (parent2 instanceof ExceptionInInitializerError) {
            return ((ExceptionInInitializerError)parent2).getException();
        }
        Throwable nestedException = JDOMException.getNestedExceptionFromField(parent2, "java.rmi.RemoteException", "detail");
        if (nestedException != null) {
            return nestedException;
        }
        nestedException = JDOMException.getNestedException(parent2, "javax.naming.NamingException", "getRootCause");
        if (nestedException != null) {
            return nestedException;
        }
        nestedException = JDOMException.getNestedException(parent2, "javax.servlet.ServletException", "getRootCause");
        if (nestedException != null) {
            return nestedException;
        }
        return null;
    }

    private static Throwable getNestedException(Throwable parent2, String className2, String methodName) {
        try {
            Class<?> testClass = Class.forName(className2);
            Class<?> objectClass = parent2.getClass();
            if (testClass.isAssignableFrom(objectClass)) {
                Class[] argClasses = new Class[]{};
                Method method = testClass.getMethod(methodName, argClasses);
                Object[] args = new Object[]{};
                return (Throwable)method.invoke((Object)parent2, args);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static Throwable getNestedExceptionFromField(Throwable parent2, String className2, String fieldName) {
        try {
            Class<?> testClass = Class.forName(className2);
            Class<?> objectClass = parent2.getClass();
            if (testClass.isAssignableFrom(objectClass)) {
                Class[] argClasses = new Class[]{};
                Field field = testClass.getField(fieldName);
                return (Throwable)field.get(parent2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

