/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.jar;

import java.io.File;
import org.gradle.api.internal.tasks.compile.incremental.jar.ClasspathJarFinder;
import org.gradle.api.internal.tasks.compile.incremental.jar.JarArchive;
import org.gradle.api.internal.tasks.compile.incremental.jar.JarClasspathSnapshot;
import org.gradle.api.internal.tasks.compile.incremental.jar.JarClasspathSnapshotFactory;
import org.gradle.api.internal.tasks.compile.incremental.jar.JarClasspathSnapshotProvider;
import org.gradle.api.internal.tasks.compile.incremental.jar.JarClasspathSnapshotWriter;
import org.gradle.api.internal.tasks.compile.incremental.jar.LocalJarClasspathSnapshotStore;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.time.Time;
import org.gradle.internal.time.Timer;

public class JarClasspathSnapshotMaker
implements JarClasspathSnapshotProvider,
JarClasspathSnapshotWriter {
    private static final Logger LOG = Logging.getLogger(JarClasspathSnapshotMaker.class);
    private final LocalJarClasspathSnapshotStore classpathSnapshotStore;
    private final ClasspathJarFinder classpathJarFinder;
    private final JarClasspathSnapshotFactory classpathSnapshotFactory;
    private JarClasspathSnapshot jarClasspathSnapshot;

    public JarClasspathSnapshotMaker(LocalJarClasspathSnapshotStore classpathSnapshotStore, JarClasspathSnapshotFactory classpathSnapshotFactory, ClasspathJarFinder classpathJarFinder) {
        this.classpathSnapshotStore = classpathSnapshotStore;
        this.classpathSnapshotFactory = classpathSnapshotFactory;
        this.classpathJarFinder = classpathJarFinder;
    }

    @Override
    public void storeJarSnapshots(Iterable<File> classpath) {
        this.maybeInitialize(classpath);
        Timer clock = Time.startTimer();
        this.classpathSnapshotStore.put(this.jarClasspathSnapshot.getData());
        LOG.info("Written jar classpath snapshot for incremental compilation in {}.", (Object)clock.getElapsed());
    }

    @Override
    public JarClasspathSnapshot getJarClasspathSnapshot(Iterable<File> classpath) {
        this.maybeInitialize(classpath);
        return this.jarClasspathSnapshot;
    }

    private void maybeInitialize(Iterable<File> classpath) {
        if (this.jarClasspathSnapshot != null) {
            return;
        }
        Timer clock = Time.startTimer();
        Iterable<JarArchive> jarArchives = this.classpathJarFinder.findJarArchives(classpath);
        this.jarClasspathSnapshot = this.classpathSnapshotFactory.createSnapshot(jarArchives);
        int duplicatesCount = this.jarClasspathSnapshot.getData().getDuplicateClasses().size();
        String duplicateClassesMessage = duplicatesCount == 0 ? "" : ". " + duplicatesCount + " duplicate classes found in classpath (see all with --debug)";
        LOG.info("Created jar classpath snapshot for incremental compilation in {}{}.", (Object)clock.getElapsed(), (Object)duplicateClassesMessage);
        LOG.debug("While calculating jar classpath snapshot {} duplicate classes were found: {}.", (Object)duplicatesCount, this.jarClasspathSnapshot.getData().getDuplicateClasses());
    }
}

