/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.nativeplatform.internal.incremental;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gradle.internal.FileUtils;
import org.gradle.language.nativeplatform.internal.Directive;
import org.gradle.language.nativeplatform.internal.Include;
import org.gradle.language.nativeplatform.internal.IncludeDirectives;
import org.gradle.language.nativeplatform.internal.IncludeType;
import org.gradle.language.nativeplatform.internal.Macro;
import org.gradle.language.nativeplatform.internal.MacroFunction;
import org.gradle.language.nativeplatform.internal.incremental.SourceIncludesResolver;

public class DefaultSourceIncludesResolver
implements SourceIncludesResolver {
    private final List<File> includePaths;
    private final Map<File, Map<String, Boolean>> includeRoots;

    public DefaultSourceIncludesResolver(List<File> includePaths) {
        this.includePaths = includePaths;
        this.includeRoots = new HashMap<File, Map<String, Boolean>>();
    }

    @Override
    public SourceIncludesResolver.IncludeResolutionResult resolveInclude(File sourceFile, Include include, List<IncludeDirectives> visibleIncludeDirectives) {
        BuildableResult resolvedSourceIncludes = new BuildableResult(include.getValue());
        this.resolveDirective(sourceFile, include, visibleIncludeDirectives, (Directive)include, resolvedSourceIncludes, this.includePaths);
        return resolvedSourceIncludes;
    }

    private void resolveDirective(File sourceFile, Include include, List<IncludeDirectives> visibleIncludeDirectives, Directive directive, BuildableResult resolvedSourceIncludes, List<File> includePaths) {
        if (directive.getType() == IncludeType.SYSTEM) {
            this.searchForDependency(includePaths, directive.getValue(), resolvedSourceIncludes);
        } else if (directive.getType() == IncludeType.QUOTED) {
            List<File> quotedSearchPath = this.prependSourceDir(sourceFile, includePaths);
            this.searchForDependency(quotedSearchPath, directive.getValue(), resolvedSourceIncludes);
        } else if (directive.getType() == IncludeType.MACRO) {
            this.resolveMacroToIncludes(sourceFile, include, visibleIncludeDirectives, directive, resolvedSourceIncludes);
        } else if (directive.getType() == IncludeType.MACRO_FUNCTION) {
            this.resolveMacroFunctionToIncludes(sourceFile, include, visibleIncludeDirectives, directive, resolvedSourceIncludes);
        } else {
            resolvedSourceIncludes.unresolved();
        }
    }

    private void resolveMacroToIncludes(File sourceFile, Include include, List<IncludeDirectives> visibleIncludeDirectives, Directive directive, BuildableResult resolvedSourceIncludes) {
        boolean found = false;
        for (IncludeDirectives includeDirectives : visibleIncludeDirectives) {
            for (Macro macro : includeDirectives.getMacros()) {
                if (!directive.getValue().equals(macro.getName())) continue;
                found = true;
                this.resolveDirective(sourceFile, include, visibleIncludeDirectives, (Directive)macro, resolvedSourceIncludes, this.includePaths);
            }
        }
        if (!found) {
            resolvedSourceIncludes.unresolved();
        }
    }

    private void resolveMacroFunctionToIncludes(File sourceFile, Include include, List<IncludeDirectives> visibleIncludeDirectives, Directive directive, BuildableResult resolvedSourceIncludes) {
        boolean found = false;
        for (IncludeDirectives includeDirectives : visibleIncludeDirectives) {
            for (MacroFunction macro : includeDirectives.getMacrosFunctions()) {
                if (!directive.getValue().equals(macro.getName()) || macro.getParameterCount() != 0) continue;
                found = true;
                this.resolveDirective(sourceFile, include, visibleIncludeDirectives, (Directive)macro, resolvedSourceIncludes, this.includePaths);
            }
        }
        if (!found) {
            resolvedSourceIncludes.unresolved();
        }
    }

    private List<File> prependSourceDir(File sourceFile, List<File> includePaths) {
        ArrayList<File> quotedSearchPath = new ArrayList<File>(includePaths.size() + 1);
        quotedSearchPath.add(sourceFile.getParentFile());
        quotedSearchPath.addAll(includePaths);
        return quotedSearchPath;
    }

    private void searchForDependency(List<File> searchPath, String include, BuildableResult dependencies) {
        for (File searchDir : searchPath) {
            File candidate = new File(searchDir, include);
            Map<String, Boolean> searchedIncludes = this.includeRoots.get(searchDir);
            if (searchedIncludes == null) {
                searchedIncludes = new HashMap<String, Boolean>();
                this.includeRoots.put(searchDir, searchedIncludes);
            }
            dependencies.searched(candidate);
            if (searchedIncludes.containsKey(include)) {
                if (!searchedIncludes.get(include).booleanValue()) continue;
                dependencies.resolved(FileUtils.canonicalize((File)candidate));
                return;
            }
            boolean found = candidate.isFile();
            searchedIncludes.put(include, found);
            if (!found) continue;
            dependencies.resolved(FileUtils.canonicalize((File)candidate));
            return;
        }
    }

    private static class BuildableResult
    implements SourceIncludesResolver.IncludeResolutionResult {
        private final List<File> files = new ArrayList<File>();
        private final List<File> candidates = new ArrayList<File>();
        private final String include;
        private boolean missing;

        BuildableResult(String include) {
            this.include = include;
        }

        void searched(File candidate) {
            this.candidates.add(candidate);
        }

        void resolved(File file) {
            this.files.add(file);
        }

        void unresolved() {
            this.missing = true;
        }

        @Override
        public String getInclude() {
            return this.include;
        }

        @Override
        public boolean isComplete() {
            return !this.missing;
        }

        @Override
        public List<File> getFiles() {
            return this.files;
        }

        @Override
        public List<File> getCheckedLocations() {
            return this.candidates;
        }
    }
}

