/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.repositories.resolver;

import java.io.InputStream;
import java.net.URI;
import org.gradle.api.Action;
import org.gradle.api.artifacts.repositories.RepositoryResourceAccessor;
import org.gradle.api.internal.artifacts.repositories.resolver.DefaultExternalResourceAccessor;
import org.gradle.api.internal.artifacts.repositories.resolver.ExternalResourceAccessor;
import org.gradle.internal.resource.ExternalResourceName;
import org.gradle.internal.resource.local.FileStore;
import org.gradle.internal.resource.local.LocallyAvailableExternalResource;
import org.gradle.internal.resource.transfer.CacheAwareExternalResourceAccessor;

public class ExternalRepositoryResourceAccessor
implements RepositoryResourceAccessor {
    private final URI rootUri;
    private final ExternalResourceAccessor resourceResolver;

    public ExternalRepositoryResourceAccessor(URI rootUri, CacheAwareExternalResourceAccessor cacheAwareExternalResourceAccessor, FileStore<String> fileStore) {
        this.rootUri = rootUri;
        this.resourceResolver = new DefaultExternalResourceAccessor(fileStore, cacheAwareExternalResourceAccessor);
    }

    public void withResource(String relativePath, Action<? super InputStream> action) {
        ExternalResourceName location = new ExternalResourceName(this.rootUri, relativePath);
        LocallyAvailableExternalResource resource = this.resourceResolver.resolveResource(location);
        if (resource != null) {
            resource.withContent(action);
        }
    }
}

