/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.cli.command.grab;

import java.util.List;
import joptsimple.OptionSet;
import org.springframework.boot.cli.command.OptionParsingCommand;
import org.springframework.boot.cli.command.options.CompilerOptionHandler;
import org.springframework.boot.cli.command.options.OptionSetGroovyCompilerConfiguration;
import org.springframework.boot.cli.command.options.SourceOptions;
import org.springframework.boot.cli.command.status.ExitStatus;
import org.springframework.boot.cli.compiler.GroovyCompiler;
import org.springframework.boot.cli.compiler.RepositoryConfigurationFactory;
import org.springframework.boot.cli.compiler.grape.RepositoryConfiguration;

public class GrabCommand
extends OptionParsingCommand {
    public GrabCommand() {
        super("grab", "Download a spring groovy script's dependencies to ./repository", new GrabOptionHandler());
    }

    private static final class GrabOptionHandler
    extends CompilerOptionHandler {
        private GrabOptionHandler() {
        }

        @Override
        protected ExitStatus run(OptionSet options) throws Exception {
            SourceOptions sourceOptions = new SourceOptions(options);
            List<RepositoryConfiguration> repositoryConfiguration = RepositoryConfigurationFactory.createDefaultRepositoryConfiguration();
            OptionSetGroovyCompilerConfiguration configuration = new OptionSetGroovyCompilerConfiguration(options, this, repositoryConfiguration);
            if (System.getProperty("grape.root") == null) {
                System.setProperty("grape.root", ".");
            }
            GroovyCompiler groovyCompiler = new GroovyCompiler(configuration);
            groovyCompiler.compile(sourceOptions.getSourcesArray());
            return ExitStatus.OK;
        }
    }
}

