/*
 * Decompiled with CFR 0.152.
 */
package org.grails.spring;

import groovy.lang.GroovyObjectSupport;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.grails.spring.BeanConfiguration;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.context.annotation.Lazy;
import org.springframework.util.Assert;

public class DefaultBeanConfiguration
extends GroovyObjectSupport
implements BeanConfiguration {
    private static final String AUTOWIRE = "autowire";
    private static final String SINGLETON = "singleton";
    private static final String CONSTRUCTOR_ARGS = "constructorArgs";
    private static final String DESTROY_METHOD = "destroyMethod";
    private static final String FACTORY_BEAN = "factoryBean";
    private static final String FACTORY_METHOD = "factoryMethod";
    private static final String INIT_METHOD = "initMethod";
    private static final String BY_NAME = "byName";
    private static final String PARENT = "parent";
    private static final String BY_TYPE = "byType";
    private static final String BY_CONSTRUCTOR = "constructor";
    private static final List<String> DYNAMIC_PROPS = Arrays.asList("autowire", "constructorArgs", "destroyMethod", "factoryBean", "factoryMethod", "initMethod", "byName", "byType", "constructor");
    private String parentName;
    private Class<?> clazz;
    private String name;
    private boolean singleton = true;
    private AbstractBeanDefinition definition;
    private Collection<?> constructorArgs = Collections.emptyList();
    private BeanWrapper wrapper;

    public Object getProperty(String property) {
        AbstractBeanDefinition bd = this.getBeanDefinition();
        if (this.wrapper.isReadableProperty(property)) {
            return this.wrapper.getPropertyValue(property);
        }
        if (DYNAMIC_PROPS.contains(property)) {
            return null;
        }
        return super.getProperty(property);
    }

    public void setProperty(String property, Object newValue) {
        if (PARENT.equals(property)) {
            this.setParent(newValue);
            return;
        }
        AbstractBeanDefinition bd = this.getBeanDefinition();
        if (AUTOWIRE.equals(property)) {
            if (BY_NAME.equals(newValue)) {
                bd.setAutowireMode(1);
            } else if (BY_TYPE.equals(newValue)) {
                bd.setAutowireMode(2);
            } else if (Boolean.TRUE.equals(newValue)) {
                bd.setAutowireMode(1);
            } else if (BY_CONSTRUCTOR.equals(newValue)) {
                bd.setAutowireMode(3);
            }
        } else if (CONSTRUCTOR_ARGS.equals(property) && newValue instanceof List) {
            ConstructorArgumentValues cav = new ConstructorArgumentValues();
            for (Object e : (List)newValue) {
                cav.addGenericArgumentValue(e);
            }
            bd.setConstructorArgumentValues(cav);
        } else if (DESTROY_METHOD.equals(property)) {
            if (newValue != null) {
                bd.setDestroyMethodName(newValue.toString());
            }
        } else if (FACTORY_BEAN.equals(property)) {
            if (newValue != null) {
                bd.setFactoryBeanName(newValue.toString());
            }
        } else if (FACTORY_METHOD.equals(property)) {
            if (newValue != null) {
                bd.setFactoryMethodName(newValue.toString());
            }
        } else if (INIT_METHOD.equals(property)) {
            if (newValue != null) {
                bd.setInitMethodName(newValue.toString());
            }
        } else if (SINGLETON.equals(property)) {
            bd.setScope(Boolean.TRUE.equals(newValue) ? SINGLETON : "prototype");
        } else if (this.wrapper.isWritableProperty(property)) {
            this.wrapper.setPropertyValue(property, newValue);
        } else {
            super.setProperty(property, newValue);
        }
    }

    public DefaultBeanConfiguration(String name, Class<?> clazz) {
        this.name = name;
        this.clazz = clazz;
    }

    public DefaultBeanConfiguration(String name, Class<?> clazz, boolean prototype) {
        this(name, clazz, Collections.emptyList());
        this.singleton = !prototype;
    }

    public DefaultBeanConfiguration(String name) {
        this(name, null, Collections.emptyList());
    }

    public DefaultBeanConfiguration(Class<?> clazz2) {
        this.clazz = clazz2;
    }

    public DefaultBeanConfiguration(String name2, Class<?> clazz2, Collection<?> args) {
        this.name = name2;
        this.clazz = clazz2;
        this.constructorArgs = args;
    }

    public DefaultBeanConfiguration(String name2, boolean prototype) {
        this(name2, null, Collections.emptyList());
        this.singleton = !prototype;
    }

    public DefaultBeanConfiguration(Class<?> clazz2, Collection<?> constructorArguments) {
        this.clazz = clazz2;
        this.constructorArgs = constructorArguments;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isSingleton() {
        return this.singleton;
    }

    @Override
    public AbstractBeanDefinition getBeanDefinition() {
        if (this.definition == null) {
            this.definition = this.createBeanDefinition();
        }
        return this.definition;
    }

    @Override
    public void setBeanDefinition(BeanDefinition definition) {
        this.definition = (AbstractBeanDefinition)definition;
    }

    protected AbstractBeanDefinition createBeanDefinition() {
        GenericBeanDefinition bd = new GenericBeanDefinition();
        if (!this.constructorArgs.isEmpty()) {
            ConstructorArgumentValues cav = new ConstructorArgumentValues();
            for (Object constructorArg : this.constructorArgs) {
                cav.addGenericArgumentValue(constructorArg);
            }
            bd.setConstructorArgumentValues(cav);
        }
        if (this.clazz != null) {
            bd.setLazyInit(this.clazz.getAnnotation(Lazy.class) != null);
            bd.setBeanClass(this.clazz);
        }
        bd.setScope(this.singleton ? SINGLETON : "prototype");
        if (this.parentName != null) {
            bd.setParentName(this.parentName);
        }
        this.wrapper = new BeanWrapperImpl((Object)bd);
        return bd;
    }

    @Override
    public BeanConfiguration addProperty(String propertyName, Object propertyValue) {
        if (propertyValue instanceof BeanConfiguration) {
            propertyValue = ((BeanConfiguration)propertyValue).getBeanDefinition();
        }
        this.getBeanDefinition().getPropertyValues().addPropertyValue(propertyName, propertyValue);
        return this;
    }

    @Override
    public BeanConfiguration setDestroyMethod(String methodName) {
        this.getBeanDefinition().setDestroyMethodName(methodName);
        return this;
    }

    @Override
    public BeanConfiguration setDependsOn(String[] dependsOn) {
        this.getBeanDefinition().setDependsOn(dependsOn);
        return this;
    }

    @Override
    public BeanConfiguration setFactoryBean(String beanName) {
        this.getBeanDefinition().setFactoryBeanName(beanName);
        return this;
    }

    @Override
    public BeanConfiguration setFactoryMethod(String methodName) {
        this.getBeanDefinition().setFactoryMethodName(methodName);
        return this;
    }

    @Override
    public BeanConfiguration setAutowire(String type) {
        if (BY_NAME.equals(type)) {
            this.getBeanDefinition().setAutowireMode(1);
        } else if (BY_TYPE.equals(type)) {
            this.getBeanDefinition().setAutowireMode(2);
        }
        return this;
    }

    @Override
    public void setName(String beanName) {
        this.name = beanName;
    }

    @Override
    public Object getPropertyValue(String propName) {
        PropertyValue propertyValue = this.getBeanDefinition().getPropertyValues().getPropertyValue(propName);
        if (propertyValue == null) {
            return null;
        }
        return propertyValue.getValue();
    }

    @Override
    public boolean hasProperty(String propName) {
        return this.getBeanDefinition().getPropertyValues().contains(propName);
    }

    @Override
    public void setPropertyValue(String property, Object newValue) {
        this.getBeanDefinition().getPropertyValues().addPropertyValue(property, newValue);
    }

    @Override
    public BeanConfiguration setAbstract(boolean isAbstract) {
        this.getBeanDefinition().setAbstract(isAbstract);
        return this;
    }

    @Override
    public void setParent(Object obj) {
        Assert.notNull((Object)obj, (String)"Parent bean cannot be set to a null runtime bean reference!");
        if (obj instanceof String) {
            this.parentName = (String)obj;
        } else if (obj instanceof RuntimeBeanReference) {
            this.parentName = ((RuntimeBeanReference)obj).getBeanName();
        } else if (obj instanceof BeanConfiguration) {
            this.parentName = ((BeanConfiguration)obj).getName();
        }
        this.getBeanDefinition().setParentName(this.parentName);
        this.setAbstract(false);
    }
}

