/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types.resources;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.BaseResourceCollectionContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Intersect
extends BaseResourceCollectionContainer {
    @Override
    protected Collection<Resource> getCollection() {
        List<ResourceCollection> rcs = this.getResourceCollections();
        int size = rcs.size();
        if (size < 2) {
            throw new BuildException("The intersection of " + size + " resource collection" + (size == 1 ? "" : "s") + " is undefined.");
        }
        Iterator<ResourceCollection> rc = rcs.iterator();
        LinkedHashSet<Resource> s = new LinkedHashSet<Resource>(this.collect(rc.next()));
        while (rc.hasNext()) {
            s.retainAll(this.collect(rc.next()));
        }
        return s;
    }

    private Set<Resource> collect(ResourceCollection rc) {
        LinkedHashSet<Resource> result = new LinkedHashSet<Resource>();
        for (Resource r : rc) {
            result.add(r);
        }
        return result;
    }
}

