/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.nodes;

import com.android.dex.ClassData;
import com.android.dex.ClassDef;
import com.android.dex.Code;
import com.android.dex.Dex;
import com.android.dex.FieldId;
import com.android.dex.MethodId;
import com.android.dex.ProtoId;
import com.android.dex.TypeList;
import jadx.core.dex.info.ClassInfo;
import jadx.core.dex.info.FieldInfo;
import jadx.core.dex.info.InfoStorage;
import jadx.core.dex.info.MethodInfo;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.FieldNode;
import jadx.core.dex.nodes.IDexNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.nodes.RootNode;
import jadx.core.utils.exceptions.DecodeException;
import jadx.core.utils.files.DexFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DexNode
implements IDexNode {
    public static final int NO_INDEX = -1;
    private final RootNode root;
    private final Dex dexBuf;
    private final DexFile file;
    private final List<ClassNode> classes = new ArrayList<ClassNode>();
    private final Map<ClassInfo, ClassNode> clsMap = new HashMap<ClassInfo, ClassNode>();
    private final InfoStorage infoStorage = new InfoStorage();

    public DexNode(RootNode root, DexFile input) {
        this.root = root;
        this.file = input;
        this.dexBuf = input.getDexBuf();
    }

    public void loadClasses() throws DecodeException {
        for (ClassDef cls : this.dexBuf.classDefs()) {
            ClassNode clsNode = new ClassNode(this, cls);
            this.classes.add(clsNode);
            this.clsMap.put(clsNode.getClassInfo(), clsNode);
        }
    }

    void initInnerClasses() {
        ArrayList<ClassNode> inner = new ArrayList<ClassNode>();
        for (ClassNode cls : this.classes) {
            if (!cls.getClassInfo().isInner()) continue;
            inner.add(cls);
        }
        for (ClassNode cls : inner) {
            ClassInfo clsInfo = cls.getClassInfo();
            ClassNode parent = this.resolveClass(clsInfo.getParentClass());
            if (parent == null) {
                this.clsMap.remove(clsInfo);
                clsInfo.notInner(cls.dex());
                this.clsMap.put(clsInfo, cls);
                continue;
            }
            parent.addInnerClass(cls);
        }
    }

    public List<ClassNode> getClasses() {
        return this.classes;
    }

    @Nullable
    public ClassNode resolveClass(ClassInfo clsInfo) {
        return this.clsMap.get(clsInfo);
    }

    @Nullable
    public ClassNode resolveClass(@NotNull ArgType type) {
        if (type.isGeneric()) {
            type = ArgType.object(type.getObject());
        }
        return this.resolveClass(ClassInfo.fromType(this, type));
    }

    @Nullable
    public MethodNode resolveMethod(@NotNull MethodInfo mth) {
        ClassNode cls = this.resolveClass(mth.getDeclClass());
        if (cls != null) {
            return cls.searchMethod(mth);
        }
        return null;
    }

    @Nullable
    public MethodNode deepResolveMethod(@NotNull MethodInfo mth) {
        ClassNode cls = this.resolveClass(mth.getDeclClass());
        if (cls == null) {
            return null;
        }
        return this.deepResolveMethod(cls, mth.makeSignature(false));
    }

    @Nullable
    private MethodNode deepResolveMethod(@NotNull ClassNode cls, String signature) {
        MethodNode found;
        ClassNode superNode;
        for (MethodNode m : cls.getMethods()) {
            if (!m.getMethodInfo().getShortId().startsWith(signature)) continue;
            return m;
        }
        ArgType superClass = cls.getSuperClass();
        if (superClass != null && (superNode = this.resolveClass(superClass)) != null && (found = this.deepResolveMethod(superNode, signature)) != null) {
            return found;
        }
        for (ArgType iFaceType : cls.getInterfaces()) {
            ClassNode iFaceNode = this.resolveClass(iFaceType);
            if (iFaceNode == null || (found = this.deepResolveMethod(iFaceNode, signature)) == null) continue;
            return found;
        }
        return null;
    }

    @Nullable
    public FieldNode resolveField(FieldInfo field) {
        ClassNode cls = this.resolveClass(field.getDeclClass());
        if (cls != null) {
            return cls.searchField(field);
        }
        return null;
    }

    public InfoStorage getInfoStorage() {
        return this.infoStorage;
    }

    public DexFile getDexFile() {
        return this.file;
    }

    public String getString(int index) {
        return (String)this.dexBuf.strings().get(index);
    }

    public ArgType getType(int index) {
        return ArgType.parse(this.getString((Integer)this.dexBuf.typeIds().get(index)));
    }

    public MethodId getMethodId(int mthIndex) {
        return (MethodId)this.dexBuf.methodIds().get(mthIndex);
    }

    public FieldId getFieldId(int fieldIndex) {
        return (FieldId)this.dexBuf.fieldIds().get(fieldIndex);
    }

    public ProtoId getProtoId(int protoIndex) {
        return (ProtoId)this.dexBuf.protoIds().get(protoIndex);
    }

    public ClassData readClassData(ClassDef cls) {
        return this.dexBuf.readClassData(cls);
    }

    public List<ArgType> readParamList(int parametersOffset) {
        TypeList paramList = this.dexBuf.readTypeList(parametersOffset);
        ArrayList<ArgType> args = new ArrayList<ArgType>(paramList.getTypes().length);
        for (short t : paramList.getTypes()) {
            args.add(this.getType(t));
        }
        return Collections.unmodifiableList(args);
    }

    public Code readCode(ClassData.Method mth) {
        return this.dexBuf.readCode(mth);
    }

    public Dex.Section openSection(int offset) {
        return this.dexBuf.open(offset);
    }

    @Override
    public RootNode root() {
        return this.root;
    }

    @Override
    public DexNode dex() {
        return this;
    }

    public String toString() {
        return "DEX";
    }
}

