/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.quantum;

import java.io.BufferedReader;
import java.util.Hashtable;
import java.util.Map;
import javajs.util.AU;
import javajs.util.Lst;
import javajs.util.PT;
import javajs.util.Rdr;
import javajs.util.SB;
import org.jmol.adapter.readers.quantum.MOReader;
import org.jmol.adapter.readers.quantum.NBOParser;
import org.jmol.adapter.smarter.Atom;
import org.jmol.quantum.QS;
import org.jmol.util.Logger;

public class GenNBOReader
extends MOReader {
    private boolean isOutputFile;
    private String nboType = "";
    private int nOrbitals0;
    private boolean is47File;
    private boolean isOpenShell;
    private boolean alphaOnly;
    private boolean betaOnly;
    private int nAOs;
    private String topoType = "A";
    private int nStructures = 0;
    NBOParser nboParser;
    private static String P_LIST = "101   102   103";
    private static String SP_LIST = "1     101   102   103";
    private static String DS_LIST = "255   252   253   254   251";
    private static String DC_LIST = "201   204   206   202   203   205";
    private static String FS_LIST = "351   352   353   354   355   356   357";
    private static String FC_LIST = "301   307   310   304   302   303   306   309   308   305";

    @Override
    protected void initializeReader() throws Exception {
        boolean isOK;
        String line1 = this.rd().trim();
        this.is47File = line1.indexOf("$GENNBO") >= 0 || line1.indexOf("$NBO") >= 0;
        this.alphaOnly = this.is47File || this.checkFilterKey("ALPHA");
        boolean bl = this.betaOnly = !this.is47File && this.checkFilterKey("BETA");
        if (this.is47File) {
            this.readData47();
            return;
        }
        String line2 = this.rd();
        this.line = line1 + line2;
        boolean bl2 = this.isOutputFile = line2.indexOf("****") >= 0;
        if (this.isOutputFile) {
            isOK = this.getFile31();
            super.initializeReader();
            this.moData.put("isNormalized", Boolean.TRUE);
        } else if (line2.indexOf("s in the AO basis:") >= 0) {
            this.nboType = line2.substring(1, line2.indexOf("s"));
            this.asc.setCollectionName(line1 + ": " + this.nboType + "s");
            isOK = this.getFile31();
        } else {
            this.nboType = "AO";
            this.asc.setCollectionName(line1 + ": " + this.nboType + "s");
            isOK = this.readData31(line1);
        }
        if (!isOK) {
            Logger.error((String)("Unimplemented shell type -- no orbitals available: " + this.line));
        }
        if (this.isOutputFile) {
            return;
        }
        if (isOK) {
            this.readMOs();
        }
        this.continuing = false;
    }

    protected void finalizeSubclassReader() throws Exception {
        this.appendLoadNote("NBO type " + this.nboType);
        if (this.isOpenShell) {
            this.asc.setCurrentModelInfo("isOpenShell", (Object)Boolean.TRUE);
        }
        this.finalizeReaderASCR();
    }

    private void readMOs() throws Exception {
        boolean isAO;
        this.nOrbitals0 = this.orbitals.size();
        this.getFile46();
        if (this.betaOnly) {
            this.discardLinesUntilContains("BETA");
            this.filterMO();
        }
        boolean isNBO = !(isAO = this.nboType.equals("AO")) && !this.nboType.equals("MO");
        this.nOrbitals = this.orbitals.size();
        if (this.nOrbitals == 0) {
            return;
        }
        this.line = null;
        if (!isNBO) {
            this.nOrbitals = this.nOrbitals0 + this.nAOs;
        }
        for (int i = this.nOrbitals0; i < this.nOrbitals; ++i) {
            Map mo = (Map)this.orbitals.get(i);
            float[] coefs = new float[this.nAOs];
            mo.put("coefficients", coefs);
            if (!isAO) {
                if (this.line == null) {
                    while (this.rd() != null && Float.isNaN(this.parseFloatStr(this.line))) {
                        this.filterMO();
                    }
                } else {
                    this.line = null;
                }
                this.fillFloatArray(this.line, 0, coefs);
                if (Float.isNaN(coefs[0])) {
                    System.out.println("testing gennboreader");
                }
                this.line = null;
                continue;
            }
            coefs[i] = 1.0f;
        }
        if (this.nboType.equals("NBO")) {
            float[] occupancies = new float[this.nOrbitals - this.nOrbitals0];
            this.fillFloatArray(null, 0, occupancies);
            for (int i = this.nOrbitals0; i < this.nOrbitals; ++i) {
                Map mo = (Map)this.orbitals.get(i);
                mo.put("occupancy", Float.valueOf(occupancies[i - this.nOrbitals0]));
            }
        }
        this.moData.put(this.nboType + "_coefs", this.orbitals);
        this.setMOData(false);
        this.moData.put("isNormalized", Boolean.TRUE);
        this.moData.put("nboType", this.nboType);
        Logger.info((String)(this.orbitals.size() - this.nOrbitals0 + " orbitals read"));
    }

    protected boolean checkLine() throws Exception {
        if (this.line.indexOf("SECOND ORDER PERTURBATION THEORY ANALYSIS") >= 0 && !this.orbitalsRead) {
            this.nboType = "NBO";
            String data = this.getFileData(".37");
            if (data == null) {
                return true;
            }
            BufferedReader readerSave = this.reader;
            this.reader = Rdr.getBR((String)data);
            this.rd();
            this.rd();
            this.readMOs();
            this.reader = readerSave;
            this.orbitalsRead = false;
            return true;
        }
        if (this.line.indexOf("$NRTSTRA") >= 0) {
            this.getStructures("NRTSTRA");
            return true;
        }
        if (this.line.indexOf("$NRTSTRB") >= 0) {
            this.getStructures("NRTSTRB");
            return true;
        }
        if (this.line.indexOf("$NRTSTR") >= 0) {
            this.getStructures("NRTSTR");
            return true;
        }
        if (this.line.indexOf(" TOPO ") >= 0) {
            this.getStructures("TOPO" + this.topoType);
            this.topoType = "B";
            return true;
        }
        if (this.line.indexOf("$CHOOSE") >= 0) {
            this.getStructures("CHOOSE");
            return true;
        }
        return this.checkNboLine();
    }

    private void getStructures(String type) throws Exception {
        if (this.nboParser == null) {
            this.nboParser = new NBOParser();
        }
        Lst<Object> structures = this.getStructureList();
        SB sb = new SB();
        while (!this.rd().trim().equals("$END")) {
            sb.append(this.line).append("\n");
        }
        this.nStructures = this.nboParser.getStructures(sb.toString(), type, structures);
        this.appendLoadNote(this.nStructures + " NBO " + type + " resonance structures");
    }

    private Lst<Object> getStructureList() {
        Lst structures = (Lst)this.asc.getAtomSetAuxiliaryInfo(this.asc.iSet).get("nboStructures");
        if (structures == null) {
            structures = new Lst();
            this.asc.setCurrentModelInfo("nboStructures", (Object)structures);
        }
        return structures;
    }

    private String getFileData(String ext) throws Exception {
        String fileName = (String)this.htParams.get("fullPathName");
        int pt = fileName.lastIndexOf(".");
        if (pt < 0) {
            pt = fileName.length();
        }
        fileName = fileName.substring(0, pt);
        this.moData.put("nboRoot", fileName);
        fileName = fileName + ext;
        String data = this.vwr.getFileAsString3(fileName, false, null);
        Logger.info((String)(data.length() + " bytes read from " + fileName));
        if (data.length() == 0 || data.indexOf("java.io.FileNotFound") >= 0 && this.nboType != "AO") {
            throw new Exception(" supplemental file " + fileName + " was not found");
        }
        return data;
    }

    private boolean getFile31() throws Exception {
        String data = this.getFileData(".31");
        BufferedReader readerSave = this.reader;
        this.reader = Rdr.getBR((String)data);
        return this.readData31(null) && (this.reader = readerSave) != null;
    }

    private void getFile46() throws Exception {
        String data = this.getFileData(".46");
        BufferedReader readerSave = this.reader;
        this.reader = Rdr.getBR((String)data);
        this.readData46();
        this.reader = readerSave;
    }

    private void readData47() throws Exception {
        this.allowNoOrbitals = true;
        this.discardLinesUntilContains("$COORD");
        this.asc.newAtomSet();
        this.asc.setAtomSetName(this.rd().trim());
        while (this.rd().indexOf("$END") < 0) {
            String[] tokens = this.getTokens();
            this.addAtomXYZSymName((String[])tokens, (int)2, null, null).elementNumber = (short)this.parseIntStr(tokens[0]);
        }
        this.discardLinesUntilContains("$BASIS");
        int[] centers = this.getIntData();
        int[] labels = this.getIntData();
        this.discardLinesUntilContains("NSHELL =");
        this.shellCount = this.parseIntAt(this.line, 10);
        this.gaussianCount = this.parseIntAt(this.rd(), 10);
        this.rd();
        int[] ncomp = this.getIntData();
        int[] nprim = this.getIntData();
        int[] nptr = this.getIntData();
        this.shells = new Lst();
        this.gaussians = AU.newFloat2((int)this.gaussianCount);
        for (int i = 0; i < this.gaussianCount; ++i) {
            this.gaussians[i] = new float[6];
        }
        this.nOrbitals = 0;
        int ptCenter = 0;
        String l = this.line;
        for (int i = 0; i < this.shellCount; ++i) {
            int[] slater = new int[4];
            int nc = ncomp[i];
            slater[0] = centers[ptCenter];
            this.line = "";
            for (int ii = 0; ii < nc; ++ii) {
                this.line = this.line + labels[ptCenter++] + " ";
            }
            if (this.fillSlater(slater, nc, nptr[i] - 1, nprim[i])) continue;
            return;
        }
        this.line = l;
        this.getAlphasAndExponents();
        this.nboType = "AO";
        this.readMOs();
        this.continuing = false;
    }

    private int[] getIntData() throws Exception {
        while (this.line.indexOf("=") < 0) {
            this.rd();
        }
        String s = this.line.substring(this.line.indexOf("=") + 1);
        this.line = "";
        while (this.rd().indexOf("=") < 0 && this.line.indexOf("$") < 0) {
            s = s + this.line;
        }
        String[] tokens = PT.getTokens((String)s);
        int[] f = new int[tokens.length];
        int i = f.length;
        while (--i >= 0) {
            f[i] = this.parseIntStr(tokens[i]);
        }
        return f;
    }

    private boolean fillSlater(int[] slater, int n, int pt, int ng) {
        this.nOrbitals += n;
        switch (n) {
            case 1: {
                slater[1] = 0;
                break;
            }
            case 3: {
                if (!this.getDFMap("P", this.line, 1, P_LIST, 3)) {
                    return false;
                }
                slater[1] = 1;
                break;
            }
            case 4: {
                if (!this.getDFMap("SP", this.line, 2, SP_LIST, 1)) {
                    return false;
                }
                slater[1] = 2;
                break;
            }
            case 5: {
                if (!this.getDFMap("DS", this.line, 3, DS_LIST, 3)) {
                    return false;
                }
                slater[1] = 3;
                break;
            }
            case 6: {
                if (!this.getDFMap("DC", this.line, 4, DC_LIST, 3)) {
                    return false;
                }
                slater[1] = 4;
                break;
            }
            case 7: {
                if (!this.getDFMap("FS", this.line, 5, FS_LIST, 3)) {
                    return false;
                }
                slater[1] = 5;
                break;
            }
            case 10: {
                if (!this.getDFMap("FC", this.line, 6, FC_LIST, 3)) {
                    return false;
                }
                slater[1] = 6;
            }
        }
        slater[2] = pt + 1;
        slater[3] = ng;
        this.shells.addLast((Object)slater);
        return true;
    }

    private void getAlphasAndExponents() throws Exception {
        for (int j = 0; j < 5; ++j) {
            if (this.line.indexOf("=") < 0) {
                this.rd();
            }
            if (this.line.indexOf("$END") >= 0) break;
            this.line = this.line.substring(this.line.indexOf("=") + 1);
            float[] temp = this.fillFloatArray(this.line, 0, new float[this.gaussianCount]);
            for (int i = 0; i < this.gaussianCount; ++i) {
                this.gaussians[i][j] = temp[i];
                if (j <= 1) continue;
                float[] fArray = this.gaussians[i];
                fArray[5] = fArray[5] + temp[i];
            }
        }
        for (int i = 0; i < this.gaussianCount; ++i) {
            if (this.gaussians[i][1] != 0.0f) continue;
            this.gaussians[i][1] = this.gaussians[i][5];
        }
        if (this.debugging) {
            Logger.debug((String)(this.shells.size() + " slater shells read"));
            Logger.debug((String)(this.gaussians.length + " gaussian primitives read"));
        }
    }

    private boolean readData31(String line1) throws Exception {
        int i;
        if (line1 == null) {
            line1 = this.rd();
            this.rd();
        }
        this.rd();
        String[] tokens = PT.getTokens((String)this.rd());
        int ac = this.parseIntStr(tokens[0]);
        this.shellCount = this.parseIntStr(tokens[1]);
        this.gaussianCount = this.parseIntStr(tokens[2]);
        this.rd();
        this.asc.newAtomSet();
        this.asc.setAtomSetName(this.nboType + "s: " + line1.trim());
        this.asc.setCurrentModelInfo("nboType", (Object)this.nboType);
        for (i = 0; i < ac; ++i) {
            tokens = PT.getTokens((String)this.rd());
            int z = this.parseIntStr(tokens[0]);
            if (z < 0) continue;
            Atom atom = this.asc.addNewAtom();
            atom.elementNumber = (short)z;
            this.setAtomCoordTokens(atom, tokens, 1);
        }
        this.shells = new Lst();
        this.gaussians = AU.newFloat2((int)this.gaussianCount);
        for (i = 0; i < this.gaussianCount; ++i) {
            this.gaussians[i] = new float[6];
        }
        this.rd();
        this.nOrbitals = 0;
        for (i = 0; i < this.shellCount; ++i) {
            tokens = PT.getTokens((String)this.rd());
            int[] slater = new int[4];
            slater[0] = this.parseIntStr(tokens[0]);
            int n = this.parseIntStr(tokens[1]);
            int pt = this.parseIntStr(tokens[2]) - 1;
            int ng = this.parseIntStr(tokens[3]);
            this.line = this.rd().trim();
            if (this.fillSlater(slater, n, pt, ng)) continue;
            return false;
        }
        this.rd();
        this.getAlphasAndExponents();
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void readData46() throws Exception {
        Hashtable<String, String[]> map = new Hashtable<String, String[]>();
        String[] tokens = new String[]{};
        this.rd();
        this.nAOs = this.nOrbitals;
        while (true) {
            int n;
            String data;
            SB sb;
            String key;
            String type;
            if (this.line != null && this.line.length() > 0) {
                tokens = PT.getTokens((String)this.line);
                type = tokens[0];
                this.isOpenShell = tokens.length == 3;
                String ab = this.isOpenShell ? tokens[1] : "";
                String count = tokens[tokens.length - 1];
                key = (ab.equals("BETA") ? "beta_" : "") + type;
                if (this.parseIntStr(count) != this.nOrbitals) {
                    Logger.error((String)("file 46 number of orbitals (" + count + ") does not match nOrbitals: " + this.nOrbitals));
                    return;
                }
                sb = new SB();
                while (this.rd() != null && this.line.length() > 4 && " NA NB AO NH".indexOf(this.line.substring(1, 4)) < 0) {
                    sb.append(this.line);
                }
                sb.appendC(' ');
                data = PT.rep((String)sb.toString(), (String)" )", (String)")");
                sb = new SB();
                n = data.length() - 1;
            } else {
                boolean addBetaSet;
                type = this.nboType;
                if (type.charAt(0) == 'P') {
                    type = type.substring(1);
                }
                if (type.equals("NLMO")) {
                    type = "NBO";
                }
                tokens = (String[])map.get((this.betaOnly ? "beta_" : "") + type);
                this.moData.put("nboLabelMap", map);
                if (tokens == null) {
                    tokens = new String[this.nAOs];
                    for (int i = 0; i < this.nAOs; ++i) {
                        tokens[i] = this.nboType + (i + 1);
                    }
                    map.put(this.nboType, tokens);
                    if (this.isOpenShell) {
                        map.put("beta_" + this.nboType, tokens);
                    }
                }
                this.moData.put("nboLabels", tokens);
                boolean bl = addBetaSet = this.isOpenShell && !this.betaOnly && !this.is47File;
                if (addBetaSet) {
                    this.nOrbitals *= 2;
                }
                for (int i = 0; i < this.nOrbitals; ++i) {
                    this.setMO(new Hashtable<String, Object>());
                }
                QS qs = new QS();
                qs.setNboLabels(tokens, this.nAOs, (Lst<Map<String, Object>>)this.orbitals, this.nOrbitals0, this.nboType);
                if (addBetaSet) {
                    this.moData.put("firstBeta", this.nAOs);
                    qs.setNboLabels((String[])map.get("beta_" + type), this.nAOs, (Lst<Map<String, Object>>)this.orbitals, this.nOrbitals0 + this.nAOs, this.nboType);
                }
                Lst<Object> structures = this.getStructureList();
                NBOParser.getStructures46((String[])map.get("NBO"), "alpha", structures, this.asc.ac);
                NBOParser.getStructures46((String[])map.get("beta_NBO"), "beta", structures, this.asc.ac);
                return;
            }
            block8: for (int i = 0; i < n; ++i) {
                char c = data.charAt(i);
                switch (c) {
                    case '(': 
                    case '-': {
                        if (data.charAt(i + 1) != ' ') break;
                        ++i;
                        break;
                    }
                    case ' ': {
                        if (PT.isDigit((char)data.charAt(i + 1)) || data.charAt(i + 1) == '(') continue block8;
                    }
                }
                sb.appendC(c);
            }
            tokens = PT.getTokens((String)sb.toString());
            map.put(key, tokens);
        }
    }
}

