/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.writers;

import javajs.util.Lst;
import org.jmol.viewer.Viewer;

public class QCSchema {
    public static final String version = "QCJSON 0-0-0.Jmol_" + Viewer.getJmolVersion().replace(' ', '_');
    public static final String UNITS_FRACTIONAL = "fractional";
    public static final String UNITS_AU = "au";
    public static final String TOAU_AU = "1";
    public static final String UNITS_ANGSTROMS = "angstroms";
    public static final String TOAU_ANGSTROMS = "1.88972613";
    public static final String UNITS_BOHR = "bohr";
    public static final String TOAU_BOHR = "1";
    public static final String UNITS_HARTREE = "hartree";
    public static final String TOAU_HARTREE = "1";
    public static final String UNITS_EV = "ev";
    public static final String TOAU_EV = "0.03688675765";
    public static final String UNITS_CM_1 = "cm-1";
    public static final String TOAU_CM_1 = "4.5563359e-6";
    public static final String UNITS_KJ_MOL = "kj/mol";
    public static final String TOAU_KJ_MOL = "0.00038087983";
    public static final String UNITS_KCAL_MOL = "kcal/mol";
    public static final String TOAU_KCAL_MOL = "0.00159362549";
    public static final String knownUnits = "cm cm^-1 cm-1 angstroms au atomic units fractional bohr hartree ev kj_mol kcal_mol";

    public static float getUnitConversion(String units, String toUnits) {
        if (units.equalsIgnoreCase(toUnits)) {
            return 1.0f;
        }
        try {
            float toAUDesired = Float.parseFloat(QCSchema.getFactorToAU(toUnits));
            float toAUActual = Float.parseFloat(QCSchema.getFactorToAU(units));
            if (Float.isNaN(toAUActual)) {
                return 1.0f;
            }
            return toAUActual / toAUDesired;
        }
        catch (Exception e) {
            return 1.0f;
        }
    }

    public static String getFactorToAU(String units) {
        String convFactor = "\"?\"";
        units = units.toLowerCase();
        switch (knownUnits.indexOf(units)) {
            case 3: 
            case 9: {
                units = UNITS_CM_1;
                convFactor = TOAU_CM_1;
                break;
            }
            case 14: {
                units = UNITS_ANGSTROMS;
                convFactor = TOAU_ANGSTROMS;
                break;
            }
            case 24: 
            case 27: {
                units = UNITS_AU;
                convFactor = "1";
                break;
            }
            case 40: {
                units = "UNITS_FRACTIONAL";
                convFactor = "0";
                break;
            }
            case 51: {
                units = UNITS_BOHR;
                convFactor = "1";
                break;
            }
            case 56: {
                units = UNITS_HARTREE;
                convFactor = "1";
                break;
            }
            case 64: {
                units = UNITS_EV;
                convFactor = TOAU_EV;
                break;
            }
            case 67: {
                units = UNITS_KCAL_MOL;
                convFactor = TOAU_KCAL_MOL;
                break;
            }
            case 74: {
                units = UNITS_KJ_MOL;
                convFactor = TOAU_KJ_MOL;
            }
        }
        return convFactor;
    }

    public static float getConversionFactorTo(Lst<Object> unitsFactor, String unitsDesired) {
        try {
            float toAUDesired = Float.parseFloat(QCSchema.getFactorToAU(unitsDesired));
            float toAUActual = Float.parseFloat(QCSchema.getFactorToAU(unitsFactor == null ? UNITS_AU : unitsFactor.get(0).toString()));
            if (Float.isNaN(toAUActual)) {
                toAUActual = Float.parseFloat(unitsFactor.get(1).toString());
            }
            return toAUActual / toAUDesired;
        }
        catch (Exception e) {
            return Float.NaN;
        }
    }
}

