/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.thread;

import java.util.Map;
import javajs.util.SB;
import org.jmol.thread.JmolThread;
import org.jmol.viewer.Viewer;

public class TimeoutThread
extends JmolThread {
    public String script;
    private int status;
    private boolean triggered = true;

    public TimeoutThread(Viewer vwr, String name, int ms, String script) {
        this.setViewer(vwr, name);
        this.name = name;
        this.set(ms, script);
    }

    private void set(int ms, String script) {
        this.sleepTime = ms;
        if (script != null) {
            this.script = script;
        }
    }

    @Override
    public String toString() {
        return "timeout name=" + this.name + " executions=" + this.status + " mSec=" + this.sleepTime + " secRemaining=" + (float)(this.targetTime - System.currentTimeMillis()) / 1000.0f + " script=" + this.script;
    }

    @Override
    protected void run1(int mode) throws InterruptedException {
        while (true) {
            switch (mode) {
                case -1: {
                    if (!this.isJS) {
                        Thread.currentThread().setPriority(1);
                    }
                    this.targetTime = System.currentTimeMillis() + (long)Math.abs(this.sleepTime);
                    mode = 0;
                    break;
                }
                case 0: {
                    if (this.checkInterrupted(null) || this.script == null || this.script.length() == 0) {
                        return;
                    }
                    if (!this.runSleep(26, 1)) {
                        return;
                    }
                    mode = 1;
                    break;
                }
                case 1: {
                    mode = System.currentTimeMillis() < this.targetTime ? 0 : 2;
                    break;
                }
                case 2: {
                    boolean continuing;
                    this.currentTime = System.currentTimeMillis();
                    if (this.vwr.timeouts.get(this.name) == null) {
                        return;
                    }
                    ++this.status;
                    boolean bl = continuing = this.sleepTime < 0;
                    if (continuing) {
                        this.targetTime = System.currentTimeMillis() + (long)Math.abs(this.sleepTime);
                    } else {
                        this.vwr.timeouts.remove(this.name);
                    }
                    if (this.triggered) {
                        this.triggered = false;
                        if (this.name.equals("_SET_IN_MOTION_")) {
                            this.vwr.checkInMotion(2);
                        } else {
                            this.vwr.evalStringQuiet(continuing ? this.script + ";\ntimeout ID \"" + this.name + "\";" : this.script);
                        }
                    }
                    mode = continuing ? 0 : -2;
                    break;
                }
                case -2: {
                    this.vwr.timeouts.remove(this.name);
                    return;
                }
            }
        }
    }

    public static void clear(Map<String, Object> timeouts) {
        for (Object o : timeouts.values()) {
            TimeoutThread t = (TimeoutThread)o;
            if (t.script.equals("exitJmol")) continue;
            t.interrupt();
        }
        timeouts.clear();
    }

    public static void setTimeout(Viewer vwr, Map<String, Object> timeouts, String name, int mSec, String script) {
        TimeoutThread t = (TimeoutThread)timeouts.get(name);
        if (mSec == 0) {
            if (t != null) {
                t.interrupt();
                timeouts.remove(name);
            }
            return;
        }
        if (t != null) {
            t.set(mSec, script);
            return;
        }
        t = new TimeoutThread(vwr, name, mSec, script);
        timeouts.put(name, t);
        t.start();
    }

    public static void trigger(Map<String, Object> timeouts, String name) {
        TimeoutThread t = (TimeoutThread)timeouts.get(name);
        if (t != null) {
            t.triggered = t.sleepTime < 0;
        }
    }

    public static String showTimeout(Map<String, Object> timeouts, String name) {
        SB sb = new SB();
        if (timeouts != null) {
            for (Object o : timeouts.values()) {
                TimeoutThread t = (TimeoutThread)o;
                if (name != null && !t.name.equalsIgnoreCase(name)) continue;
                sb.append(t.toString()).append("\n");
            }
        }
        return sb.length() > 0 ? sb.toString() : "<no timeouts set>";
    }
}

