/*
 * Decompiled with CFR 0.152.
 */
package com.sparshui.inputdevice;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeSet;
import javax.swing.SwingUtilities;
import org.jmol.api.JmolTouchSimulatorInterface;
import org.jmol.util.Logger;

public class JmolTouchSimulator
implements JmolTouchSimulatorInterface {
    private TreeSet<TouchData> _events = new TreeSet<TouchData>(new TouchDataComparator());
    protected Map<Integer, TouchData> _active = new Hashtable<Integer, TouchData>();
    private boolean _recording = false;
    private int _touchID = 0;
    private long _when = 0L;
    private Timer _timer;
    private Component _display;
    private DataOutputStream _out;

    public void dispose() {
        try {
            this._out.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this._timer.cancel();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean startSimulator(Object display) {
        this._display = (Component)display;
        String address = "localhost";
        this._timer = new Timer();
        try {
            Socket socket = new Socket(address, 5947);
            this._out = new DataOutputStream(socket.getOutputStream());
            this._out.writeByte(1);
            socket.close();
            return true;
        }
        catch (UnknownHostException e) {
            Logger.error((String)("Could not locate a server at " + address));
        }
        catch (IOException e) {
            Logger.error((String)("Failed to connect to server at " + address));
        }
        return false;
    }

    public void toggleMode() {
        if (this._recording) {
            this.endRecording();
        } else {
            this.startRecording();
        }
    }

    public void startRecording() {
        this._recording = true;
        this._active.clear();
    }

    public void endRecording() {
        this._recording = false;
        this.dispatchTouchEvents();
    }

    public void mousePressed(long time, int x, int y) {
        this.handleMouseEvent(time, x, y, 0);
    }

    public void mouseReleased(long time, int x, int y) {
        this.handleMouseEvent(time, x, y, 1);
    }

    public void mouseDragged(long time, int x, int y) {
        this.handleMouseEvent(time, x, y, 2);
    }

    private void handleMouseEvent(long time, int x, int y, int type) {
        TouchData te = new TouchData();
        te.id = type == 0 ? (this._touchID = this._touchID + 1) : this._touchID;
        Point p = new Point(x, y);
        try {
            SwingUtilities.convertPointToScreen(p, this._display);
        }
        catch (Throwable e) {
            return;
        }
        te.x = p.x;
        te.y = p.y;
        te.type = type;
        te.when = time;
        if (this._recording) {
            if (type == 0) {
                te.delay = 0L;
                this._when = te.when;
            } else {
                te.delay = te.when - this._when;
            }
            this._events.add(te);
        } else {
            this.dispatchTouchEvent(te);
            if (Logger.debugging) {
                Logger.debug((String)("[JmolTouchSimulator] dispatchTouchEvent(" + te.id + ", " + te.x + ", " + te.y + ", " + te.type + ")"));
            }
        }
    }

    private void dispatchTouchEvents() {
        for (TouchData data : this._events) {
            TouchTimerTask task = new TouchTimerTask(data);
            this._timer.schedule((TimerTask)task, data.delay + 250L);
        }
        this._events.clear();
        this._touchID = 0;
    }

    protected void dispatchTouchEvent(TouchData data) {
        Toolkit tk = Toolkit.getDefaultToolkit();
        Dimension dim = tk.getScreenSize();
        if (Logger.debugging) {
            Logger.debug((String)("[JmolTouchSimulator] dispatchTouchEvent(" + data.id + ", " + data.x + ", " + data.y + ", " + data.type + ")"));
        }
        try {
            this._out.writeInt(-1);
            this._out.writeInt(21);
            this._out.writeInt(data.id);
            this._out.writeFloat((float)data.x / (float)dim.width);
            this._out.writeFloat((float)data.y / (float)dim.height);
            this._out.writeByte((byte)data.type);
            this._out.writeLong(data.when);
        }
        catch (IOException e1) {
            System.err.println("Failed to send event to server.");
        }
    }

    private class TouchTimerTask
    extends TimerTask {
        private TouchData data;

        TouchTimerTask(TouchData data) {
            this.data = data;
        }

        @Override
        public void run() {
            Thread.currentThread().setName("JmolTouchSimulator for type " + this.data.id);
            JmolTouchSimulator.this.dispatchTouchEvent(this.data);
            Integer iid = this.data.id;
            if (this.data.type == 1) {
                JmolTouchSimulator.this._active.remove(iid);
            } else {
                JmolTouchSimulator.this._active.put(iid, this.data);
            }
            Thread.currentThread().setName("JmolTouchSimulator idle");
        }
    }

    protected class TouchDataComparator
    implements Comparator<TouchData> {
        protected TouchDataComparator() {
        }

        @Override
        public int compare(TouchData o1, TouchData o2) {
            return o1.delay == o2.delay ? (o1.when < o2.when ? -1 : 1) : (o1.delay < o2.delay ? -1 : 1);
        }
    }

    protected class TouchData {
        public int type;
        public int id;
        public int x;
        public int y;
        public long when;
        public long delay;

        protected TouchData() {
        }
    }
}

