/*
 * Decompiled with CFR 0.152.
 */
package jspecview.source;

import java.io.BufferedReader;
import java.io.IOException;
import javajs.util.BC;
import javajs.util.Base64;
import jspecview.source.JDXSource;
import jspecview.source.XMLReader;

public class AnIMLReader
extends XMLReader {
    private boolean inResult;

    @Override
    protected JDXSource getXML(BufferedReader bufferedReader) {
        try {
            this.source = new JDXSource(0, this.filePath);
            this.getSimpleXmlReader(bufferedReader);
            this.parser.nextEvent();
            this.processXML(0, 3);
            if (!this.checkPointCount()) {
                return null;
            }
            this.xFactor = 1.0;
            this.yFactor = 1.0;
            this.populateVariables();
        }
        catch (Exception exception) {
            System.err.println("That file may be empty...");
            this.errorLog.append("That file may be empty... \n");
        }
        this.processErrors("anIML");
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.source;
    }

    @Override
    protected boolean processTag(int n) throws Exception {
        switch (n) {
            case 0: {
                this.processAuditTrail();
                return true;
            }
            case 1: {
                this.processExperimentStepSet();
                return true;
            }
            case 2: {
                this.processSampleSet();
                return true;
            }
            case 11: {
                this.processAuthor();
                return true;
            }
            case 3: {
                this.inResult = true;
                return true;
            }
        }
        System.out.println("AnIMLReader not processing tag " + tagNames[n]);
        return false;
    }

    @Override
    protected void processEndTag(int n) throws Exception {
        switch (n) {
            case 1: 
            case 3: {
                this.inResult = false;
            }
        }
    }

    private void processAuditTrail() throws Exception {
        if (this.tagName.equals("user")) {
            this.parser.qualifiedValue();
        } else if (this.tagName.equals("timestamp")) {
            this.parser.qualifiedValue();
        }
    }

    private void processSampleSet() throws Exception {
        if (this.tagName.equals("sample")) {
            ++this.samplenum;
        } else if (this.tagName.equals("parameter")) {
            this.attrList = this.parser.getAttrValueLC("name");
            if (this.attrList.equals("name")) {
                this.parser.qualifiedValue();
            } else if (this.attrList.equals("owner")) {
                this.parser.qualifiedValue();
            } else if (this.attrList.equals("molecular formula")) {
                this.molForm = this.parser.qualifiedValue();
            } else if (this.attrList.equals("cas registry number")) {
                this.casRN = this.parser.qualifiedValue();
            }
        }
    }

    private void processExperimentStepSet() throws Exception {
        if (this.tagName.equals("result")) {
            this.inResult = true;
        } else if (this.tagName.equals("sampleref")) {
            if (this.parser.getAttrValueLC("role").contains("samplemeasurement")) {
                this.sampleID = this.parser.getAttrValue("sampleID");
            }
        } else if (this.tagName.equals("author")) {
            this.process(11, true);
        } else if (this.tagName.equals("timestamp")) {
            this.LongDate = this.parser.thisValue();
        } else if (this.tagName.equals("technique")) {
            this.techname = this.parser.getAttrValue("name").toUpperCase() + " SPECTRUM";
        } else if (this.tagName.equals("vectorset") || this.tagName.equals("seriesset") && this.inResult) {
            this.npoints = Integer.parseInt(this.parser.getAttrValue("length"));
            this.xaxisData = new double[this.npoints];
            this.yaxisData = new double[this.npoints];
        } else if (this.tagName.equals("vector") || this.tagName.equals("series") && this.inResult) {
            String string = this.parser.getAttrValue("name");
            String string2 = this.parser.getAttrValueLC("dependency");
            if (string2.equals("independent")) {
                this.xUnits = string;
                this.getXValues();
            } else if (string2.equals("dependent")) {
                this.yUnits = string;
                this.getYValues();
            }
        } else if (this.tagName.equals("parameter")) {
            this.attrList = this.parser.getAttrValueLC("name");
            if (this.attrList.equals("identifier")) {
                this.title = this.parser.qualifiedValue();
            } else if (this.attrList.equals("nucleus")) {
                this.obNucleus = this.parser.qualifiedValue();
            } else if (this.attrList.equals("observefrequency")) {
                this.StrObFreq = this.parser.qualifiedValue();
                this.obFreq = Double.parseDouble(this.StrObFreq);
            } else if (this.attrList.equals("referencepoint")) {
                this.refPoint = Double.parseDouble(this.parser.qualifiedValue());
            } else if (this.attrList.equals("sample path length")) {
                this.pathlength = this.parser.qualifiedValue();
            } else if (this.attrList.equals("scanmode")) {
                this.parser.thisValue();
            } else if (this.attrList.equals("manufacturer")) {
                this.vendor = this.parser.thisValue();
            } else if (this.attrList.equals("model name")) {
                this.modelType = this.parser.thisValue();
            } else if (this.attrList.equals("resolution")) {
                this.resolution = this.parser.qualifiedValue();
            }
        }
    }

    private void getXValues() throws Exception {
        this.parser.nextTag();
        if (this.parser.getTagName().equals("autoincrementedvalueset")) {
            this.parser.nextTag();
            if (this.parser.getTagName().equals("startvalue")) {
                this.firstX = Double.parseDouble(this.parser.qualifiedValue());
            }
            this.nextStartTag();
            if (this.parser.getTagName().equals("increment")) {
                this.deltaX = Double.parseDouble(this.parser.qualifiedValue());
            }
        }
        if (!this.inResult) {
            this.nextStartTag();
            this.xUnits = this.parser.getAttrValue("label");
        }
        this.increasing = this.deltaX > 0.0;
        this.continuous = true;
        for (int i = 0; i < this.npoints; ++i) {
            this.xaxisData[i] = this.firstX + this.deltaX * (double)i;
        }
        this.lastX = this.xaxisData[this.npoints - 1];
    }

    private void nextStartTag() throws Exception {
        this.parser.nextStartTag();
        while (this.parser.getTagType() == 6) {
            this.parser.nextStartTag();
        }
    }

    private void getYValues() throws Exception {
        String string = this.parser.getAttrValueLC("type");
        if (string.length() == 0) {
            string = this.parser.getAttrValueLC("vectorType");
        }
        this.parser.nextTag();
        this.tagName = this.parser.getTagName();
        if (this.tagName.equals("individualvalueset")) {
            for (int i = 0; i < this.npoints; ++i) {
                this.yaxisData[i] = Double.parseDouble(this.parser.qualifiedValue());
            }
        } else if (this.tagName.equals("encodedvalueset")) {
            this.attrList = this.parser.getCharacters();
            byte[] byArray = Base64.decodeBase64(this.attrList);
            if (byArray.length != 0) {
                if (string.equals("float64")) {
                    int n = 0;
                    int n2 = 0;
                    while (n < this.npoints) {
                        this.yaxisData[n] = BC.bytesToDoubleToFloat(byArray, n2, false);
                        ++n;
                        n2 += 8;
                    }
                } else {
                    int n = 0;
                    int n3 = 0;
                    while (n < this.npoints) {
                        this.yaxisData[n] = BC.bytesToFloat(byArray, n3, false);
                        ++n;
                        n3 += 4;
                    }
                }
            }
        }
        this.parser.nextStartTag();
        this.tagName = this.parser.getTagName();
        this.yUnits = this.parser.getAttrValue("label");
        this.firstY = this.yaxisData[0];
    }

    private void processAuthor() throws Exception {
        if (this.tagName.equals("name")) {
            this.owner = this.parser.thisValue();
        } else if (this.tagName.contains("location")) {
            this.origin = this.parser.thisValue();
        }
    }
}

