/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xml;

import java.io.BufferedReader;
import org.jmol.adapter.readers.xml.XmlReader;
import org.jmol.util.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class XmlHandler
extends DefaultHandler {
    private XmlReader xmlReader;
    private String debugContext = "";

    void parseXML(XmlReader xmlReader, Object saxReaderObj, BufferedReader reader) throws Exception {
        this.xmlReader = xmlReader;
        XMLReader saxReader = (XMLReader)saxReaderObj;
        saxReader.setFeature("http://xml.org/sax/features/validation", false);
        saxReader.setFeature("http://xml.org/sax/features/namespaces", true);
        saxReader.setEntityResolver(this);
        saxReader.setContentHandler(this);
        saxReader.setErrorHandler(this);
        InputSource is = new InputSource(reader);
        is.setSystemId("foo");
        saxReader.parse(is);
    }

    @Override
    public void startDocument() {
    }

    @Override
    public void endDocument() {
        this.xmlReader.endDocument();
    }

    @Override
    public void startElement(String namespaceURI, String localName, String nodeName, Attributes attributes) {
        this.xmlReader.atts.clear();
        int i = attributes.getLength();
        while (--i >= 0) {
            this.xmlReader.atts.put(attributes.getLocalName(i).toLowerCase(), attributes.getValue(i));
        }
        if (Logger.debugging) {
            this.debugContext = this.debugContext + " " + localName;
            Logger.debug((String)("start " + this.debugContext));
        }
        this.xmlReader.processStartElement(localName.toLowerCase(), nodeName.toLowerCase());
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        if (Logger.debugging) {
            if (Logger.debugging) {
                Logger.debug((String)("end " + this.debugContext));
            }
            this.debugContext = this.debugContext.substring(0, this.debugContext.lastIndexOf(" "));
        }
        this.xmlReader.processEndElement(localName.toLowerCase());
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.xmlReader.keepChars) {
            this.xmlReader.chars.appendCB(ch, start, length);
        }
    }

    public InputSource resolveEntity(String name, String publicId, String baseURI, String systemId) {
        if (Logger.debugging) {
            Logger.debug((String)("Not resolving this:\n      name: " + name + "\n  systemID: " + systemId + "\n  publicID: " + publicId + "\n   baseURI: " + baseURI));
        }
        return null;
    }

    @Override
    public void error(SAXParseException exception) {
        Logger.error((String)("SAX ERROR:" + exception.getMessage()));
    }

    @Override
    public void fatalError(SAXParseException exception) {
        Logger.error((String)("SAX FATAL:" + exception.getMessage()));
    }

    @Override
    public void warning(SAXParseException exception) {
        Logger.warn((String)("SAX WARNING:" + exception.getMessage()));
    }
}

